/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.utils.Parameters;

public class ReadBuffer {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final Logger LOG = Logger.getLogger(ReadBuffer.class.getName());
    private static final int WAY_NUMBER_OF_TAGS_BITMASK = 15;
    int lastTagPosition;
    private byte[] mBufferData;
    private int mBufferPosition;
    private final RandomAccessFile mInputFile;
    private final List<Integer> mTagIds = new ArrayList<Integer>();

    ReadBuffer(RandomAccessFile randomAccessFile) {
        this.mInputFile = randomAccessFile;
    }

    int getBufferPosition() {
        return this.mBufferPosition;
    }

    int getBufferSize() {
        return this.mBufferData.length;
    }

    public int getPositionAndSkip() {
        int n = this.mBufferPosition;
        this.skipBytes(this.readUnsignedInt());
        return n;
    }

    public byte readByte() {
        byte[] byArray = this.mBufferData;
        int n = this.mBufferPosition;
        this.mBufferPosition = n + 1;
        return byArray[n];
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public boolean readFromFile(int n) throws IOException {
        Object object = this.mBufferData;
        boolean bl = false;
        if (object == null || ((byte[])object).length < n) {
            if (n > Parameters.MAXIMUM_BUFFER_SIZE) {
                object = LOG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("invalid read length: ");
                stringBuilder.append(n);
                ((Logger)object).warning(stringBuilder.toString());
                return false;
            }
            this.mBufferData = new byte[n];
        }
        this.mBufferPosition = 0;
        if (this.mInputFile.read(this.mBufferData, 0, n) == n) {
            bl = true;
        }
        return bl;
    }

    public int readInt() {
        int n = this.mBufferPosition;
        byte[] byArray = this.mBufferData;
        this.mBufferPosition = n + 4;
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        byte by3 = byArray[n + 2];
        return byArray[n + 3] & 0xFF | (by << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8);
    }

    public long readLong() {
        int n = this.mBufferPosition;
        byte[] byArray = this.mBufferData;
        this.mBufferPosition = n + 8;
        long l = byArray[n];
        long l2 = byArray[n + 1];
        long l3 = byArray[n + 2];
        long l4 = byArray[n + 3];
        long l5 = byArray[n + 4];
        long l6 = byArray[n + 5];
        long l7 = byArray[n + 6];
        return (long)byArray[n + 7] & 0xFFL | ((l & 0xFFL) << 56 | (l2 & 0xFFL) << 48 | (l3 & 0xFFL) << 40 | (l4 & 0xFFL) << 32 | (l5 & 0xFFL) << 24 | (l6 & 0xFFL) << 16 | (l7 & 0xFFL) << 8);
    }

    public int readShort() {
        int n;
        this.mBufferPosition = n = this.mBufferPosition + 2;
        byte[] byArray = this.mBufferData;
        byte by = byArray[n - 2];
        return byArray[n - 1] & 0xFF | by << 8;
    }

    public int readSignedInt() {
        byte[] byArray = this.mBufferData;
        int n = this.mBufferPosition;
        if ((byArray[n] & 0x80) == 0) {
            this.mBufferPosition = n + 1;
            int n2 = (byArray[n] & 0x40) >> 6;
            return (byArray[n] & 0x3F ^ -n2) + n2;
        }
        int n3 = n + 1;
        if ((byArray[n3] & 0x80) == 0) {
            this.mBufferPosition = n + 2;
            int n4 = (byArray[n3] & 0x40) >> 6;
            return ((byArray[n] & 0x7F | (byArray[n3] & 0x3F) << 7) ^ -n4) + n4;
        }
        int n5 = n + 2;
        if ((byArray[n5] & 0x80) == 0) {
            this.mBufferPosition = n + 3;
            int n6 = (byArray[n5] & 0x40) >> 6;
            return ((byArray[n] & 0x7F | (byArray[n3] & 0x7F) << 7 | (byArray[n5] & 0x3F) << 14) ^ -n6) + n6;
        }
        int n7 = n + 3;
        if ((byArray[n7] & 0x80) == 0) {
            this.mBufferPosition = n + 4;
            int n8 = (byArray[n7] & 0x40) >> 6;
            return ((byArray[n] & 0x7F | (byArray[n3] & 0x7F) << 7 | (byArray[n5] & 0x7F) << 14 | (byArray[n7] & 0x3F) << 21) ^ -n8) + n8;
        }
        this.mBufferPosition = n + 5;
        int n9 = n + 4;
        int n10 = (byArray[n9] & 0x40) >> 6;
        return ((byArray[n] & 0x7F | (byArray[n3] & 0x7F) << 7 | (byArray[n5] & 0x7F) << 14 | (byArray[n7] & 0x7F) << 21 | (byArray[n9] & 0x3F) << 28) ^ -n10) + n10;
    }

    public void readSignedInt(int[] nArray, int n) {
        int n2 = this.mBufferPosition;
        byte[] byArray = this.mBufferData;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            if ((byArray[n2] & 0x80) == 0) {
                n7 = (byArray[n2] & 0x40) >> 6;
                nArray[i] = (byArray[n2] & 0x3F ^ -n7) + n7;
                ++n2;
                continue;
            }
            n7 = n2 + 1;
            if ((byArray[n7] & 0x80) == 0) {
                n6 = (byArray[n7] & 0x40) >> 6;
                n5 = byArray[n2];
                nArray[i] = (((byArray[n7] & 0x3F) << 7 | n5 & 0x7F) ^ -n6) + n6;
                n2 += 2;
                continue;
            }
            n6 = n2 + 2;
            if ((byArray[n6] & 0x80) == 0) {
                n5 = (byArray[n6] & 0x40) >> 6;
                n4 = byArray[n2];
                nArray[i] = (((byArray[n7] & 0x7F) << 7 | n4 & 0x7F | (byArray[n6] & 0x3F) << 14) ^ -n5) + n5;
                n2 += 3;
                continue;
            }
            n5 = n2 + 3;
            if ((byArray[n5] & 0x80) == 0) {
                n4 = (byArray[n5] & 0x40) >> 6;
                n3 = byArray[n2];
                nArray[i] = (((byArray[n7] & 0x7F) << 7 | n3 & 0x7F | (byArray[n6] & 0x7F) << 14 | (byArray[n5] & 0x3F) << 21) ^ -n4) + n4;
                n2 += 4;
                continue;
            }
            n3 = n2 + 4;
            n4 = (byArray[n3] & 0x40) >> 6;
            byte by = byArray[n2];
            nArray[i] = (((byArray[n7] & 0x7F) << 7 | by & 0x7F | (byArray[n6] & 0x7F) << 14 | (byArray[n5] & 0x7F) << 21 | (byArray[n3] & 0x3F) << 28) ^ -n4) + n4;
            n2 += 5;
        }
        this.mBufferPosition = n2;
    }

    boolean readTags(TagSet tagSet, Tag[] tagArray, byte by) {
        Object object;
        Object object2;
        tagSet.clear();
        this.mTagIds.clear();
        int n = tagArray.length;
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            int n2 = this.readUnsignedInt();
            if (n2 >= 0 && n2 < n) {
                this.mTagIds.add(n2);
                continue;
            }
            object2 = LOG;
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid tag ID: ");
            ((StringBuilder)object).append(n2);
            ((Logger)object2).warning(((StringBuilder)object).toString());
            break;
        }
        Iterator<Integer> iterator2 = this.mTagIds.iterator();
        while (iterator2.hasNext()) {
            object2 = object = tagArray[iterator2.next()];
            if (((Tag)object).value.charAt(0) == '%') {
                object2 = object;
                if (((Tag)object).value.length() == 2) {
                    String string2 = ((Tag)object).value;
                    if (string2.charAt(1) == 'b') {
                        object2 = String.valueOf(this.readByte());
                    } else if (string2.charAt(1) == 'i') {
                        if (((Tag)object).key.contains(":colour")) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("#");
                            ((StringBuilder)object2).append(Integer.toHexString(this.readInt()));
                            object2 = ((StringBuilder)object2).toString();
                        } else {
                            object2 = String.valueOf(this.readInt());
                        }
                    } else if (string2.charAt(1) == 'f') {
                        object2 = String.valueOf(this.readFloat());
                    } else if (string2.charAt(1) == 'h') {
                        object2 = String.valueOf(this.readShort());
                    } else {
                        object2 = string2;
                        if (string2.charAt(1) == 's') {
                            object2 = this.readUTF8EncodedString();
                        }
                    }
                    object2 = new Tag(((Tag)object).key, (String)object2);
                }
            }
            tagSet.add((Tag)object2);
        }
        return true;
    }

    public String readUTF8EncodedString() {
        return this.readUTF8EncodedString(this.readUnsignedInt());
    }

    public String readUTF8EncodedString(int n) {
        Object object;
        int n2;
        if (n > 0 && (n2 = this.mBufferPosition) + n <= ((Object)(object = this.mBufferData)).length) {
            this.mBufferPosition = n2 += n;
            try {
                object = new String((byte[])object, n2 - n, n, CHARSET_UTF8);
                return object;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException(unsupportedEncodingException);
            }
        }
        Logger logger = LOG;
        object = new StringBuilder();
        ((StringBuilder)object).append("invalid string length: ");
        ((StringBuilder)object).append(n);
        logger.warning(((StringBuilder)object).toString());
        return null;
    }

    public String readUTF8EncodedStringAt(int n) {
        int n2 = this.mBufferPosition;
        this.mBufferPosition = n;
        String string2 = this.readUTF8EncodedString(this.readUnsignedInt());
        this.mBufferPosition = n2;
        return string2;
    }

    public int readUnsignedInt() {
        byte[] byArray = this.mBufferData;
        int n = this.mBufferPosition;
        if ((byArray[n] & 0x80) == 0) {
            this.mBufferPosition = n + 1;
            return byArray[n] & 0x7F;
        }
        int n2 = n + 1;
        if ((byArray[n2] & 0x80) == 0) {
            this.mBufferPosition = n + 2;
            return byArray[n] & 0x7F | (byArray[n2] & 0x7F) << 7;
        }
        int n3 = n + 2;
        if ((byArray[n3] & 0x80) == 0) {
            this.mBufferPosition = n + 3;
            return byArray[n] & 0x7F | (byArray[n2] & 0x7F) << 7 | (byArray[n3] & 0x7F) << 14;
        }
        int n4 = n + 3;
        if ((byArray[n4] & 0x80) == 0) {
            this.mBufferPosition = n + 4;
            return byArray[n] & 0x7F | (byArray[n2] & 0x7F) << 7 | (byArray[n3] & 0x7F) << 14 | (byArray[n4] & 0x7F) << 21;
        }
        this.mBufferPosition = n + 5;
        byte by = byArray[n];
        n2 = byArray[n2];
        n3 = byArray[n3];
        n4 = byArray[n4];
        return (byArray[n + 4] & 0x7F) << 28 | ((n2 & 0x7F) << 7 | by & 0x7F | (n3 & 0x7F) << 14 | (n4 & 0x7F) << 21);
    }

    void setBufferPosition(int n) {
        this.mBufferPosition = n;
    }

    void skipBytes(int n) {
        this.mBufferPosition += n;
    }

    int skipWays(int n, int n2) {
        int n3;
        int n4;
        block11: {
            n4 = this.mBufferPosition;
            byte[] byArray = this.mBufferData;
            this.lastTagPosition = -1;
            n3 = n2;
            n2 = n4;
            while (true) {
                int n5;
                n4 = n2;
                if (n3 <= 0) break block11;
                if ((byArray[n2] & 0x80) == 0) {
                    n4 = byArray[n2] & 0x7F;
                    ++n2;
                } else {
                    n4 = n2 + 1;
                    if ((byArray[n4] & 0x80) == 0) {
                        n5 = byArray[n2];
                        n4 = (byArray[n4] & 0x7F) << 7 | n5 & 0x7F;
                        n2 += 2;
                    } else {
                        int n6;
                        n5 = n2 + 2;
                        if ((byArray[n5] & 0x80) == 0) {
                            n6 = byArray[n2];
                            n4 = (byArray[n4] & 0x7F) << 7 | n6 & 0x7F | (byArray[n5] & 0x7F) << 14;
                            n2 += 3;
                        } else {
                            byte by;
                            n6 = n2 + 3;
                            if ((byArray[n6] & 0x80) == 0) {
                                by = byArray[n2];
                                n4 = (byArray[n4] & 0x7F) << 7 | by & 0x7F | (byArray[n5] & 0x7F) << 14 | (byArray[n6] & 0x7F) << 21;
                                n2 += 4;
                            } else {
                                by = byArray[n2];
                                n4 = (byArray[n4] & 0x7F) << 7 | by & 0x7F | (byArray[n5] & 0x7F) << 14 | (byArray[n6] & 0x7F) << 21 | (byArray[n2 + 4] & 0x7F) << 28;
                                n2 += 5;
                            }
                        }
                    }
                }
                if (n4 < 0) {
                    this.mBufferPosition = n2;
                    return -1;
                }
                if (((byArray[n2] << 8 | byArray[n2 + 1] & 0xFF) & n) != 0) break;
                n5 = n2 + 2;
                if ((byArray[n5] & 0xF) != 0) {
                    this.lastTagPosition = n5;
                }
                n2 += n4;
                --n3;
            }
            n4 = n2 + 2;
        }
        this.mBufferPosition = n4;
        return n3;
    }
}

