/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.util.Arrays;
import java.util.List;
import org.oscim.core.GeoPoint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.Tag;

public class Way {
    public final GeoPoint[][] geoPoints;
    public GeometryBuffer.GeometryType geometryType = GeometryBuffer.GeometryType.NONE;
    public final GeoPoint labelPosition;
    public final byte layer;
    public final List<Tag> tags;

    public Way(byte by, List<Tag> list, GeoPoint[][] geoPointArray, GeoPoint geoPoint) {
        this.layer = by;
        this.tags = list;
        this.geoPoints = geoPointArray;
        this.labelPosition = geoPoint;
    }

    public Way(byte by, List<Tag> list, GeoPoint[][] geoPointArray, GeoPoint geoPoint, GeometryBuffer.GeometryType geometryType) {
        this(by, list, geoPointArray, geoPoint);
        this.geometryType = geometryType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Way)) {
            return false;
        }
        object = (Way)object;
        if (this.layer != ((Way)object).layer) {
            return false;
        }
        if (!this.tags.equals(((Way)object).tags)) {
            return false;
        }
        GeoPoint[][] geoPointArray = this.labelPosition;
        if (geoPointArray == null && ((Way)object).labelPosition != null) {
            return false;
        }
        if (geoPointArray != null && !geoPointArray.equals(((Way)object).labelPosition)) {
            return false;
        }
        if (this.geoPoints.length != ((Way)object).geoPoints.length) {
            return false;
        }
        for (int i = 0; i < (geoPointArray = this.geoPoints).length; ++i) {
            if (geoPointArray[i].length != ((Way)object).geoPoints[i].length) {
                return false;
            }
            for (int j = 0; j < (geoPointArray = this.geoPoints)[i].length; ++j) {
                if (geoPointArray[i][j].equals(((Way)object).geoPoints[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = ((this.layer + 31) * 31 + this.tags.hashCode()) * 31 + Arrays.deepHashCode((Object[])this.geoPoints);
        GeoPoint geoPoint = this.labelPosition;
        int n2 = n;
        if (geoPoint != null) {
            n2 = n * 31 + geoPoint.hashCode();
        }
        return n2;
    }
}

