/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile.header;

import java.io.IOException;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.header.MapFileInfo;
import org.oscim.tiling.source.mapfile.header.MapFileInfoBuilder;
import org.oscim.tiling.source.mapfile.header.OptionalFields;
import org.oscim.tiling.source.mapfile.header.RequiredFields;
import org.oscim.tiling.source.mapfile.header.SubFileParameter;
import org.oscim.tiling.source.mapfile.header.SubFileParameterBuilder;

public class MapFileHeader {
    private static final int BASE_ZOOM_LEVEL_MAX = 20;
    private static final int HEADER_SIZE_MIN = 70;
    private static final byte SIGNATURE_LENGTH_INDEX = 16;
    private static final char SPACE = ' ';
    private MapFileInfo mapFileInfo;
    private SubFileParameter[] subFileParameters;
    private byte zoomLevelMaximum;
    private byte zoomLevelMinimum;

    private TileSource.OpenResult readSubFileParameters(ReadBuffer object, long l, MapFileInfoBuilder mapFileInfoBuilder) {
        int n;
        int n2 = ((ReadBuffer)object).readByte();
        if (n2 < 1) {
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid number of sub-files: ");
            ((StringBuilder)object).append(n2);
            return new TileSource.OpenResult(((StringBuilder)object).toString());
        }
        mapFileInfoBuilder.numberOfSubFiles = (byte)n2;
        SubFileParameter[] subFileParameterArray = new SubFileParameter[n2];
        this.zoomLevelMinimum = (byte)127;
        this.zoomLevelMaximum = (byte)-128;
        int n3 = 0;
        for (n = 0; n < n2; n = (int)((byte)(n + 1))) {
            SubFileParameterBuilder subFileParameterBuilder = new SubFileParameterBuilder();
            byte by = ((ReadBuffer)object).readByte();
            if (by >= 0 && by <= 20) {
                subFileParameterBuilder.baseZoomLevel = by;
                byte by2 = ((ReadBuffer)object).readByte();
                if (by2 >= 0 && by2 <= 22) {
                    subFileParameterBuilder.zoomLevelMin = by2;
                    by = ((ReadBuffer)object).readByte();
                    if (by >= 0 && by <= 22) {
                        subFileParameterBuilder.zoomLevelMax = by;
                        if (by2 > by) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("invalid zoom level range: ");
                            ((StringBuilder)object).append(by2);
                            ((StringBuilder)object).append(' ');
                            ((StringBuilder)object).append(by);
                            return new TileSource.OpenResult(((StringBuilder)object).toString());
                        }
                        long l2 = ((ReadBuffer)object).readLong();
                        if (l2 >= 70L && l2 < l) {
                            subFileParameterBuilder.startAddress = l2;
                            long l3 = l2;
                            if (mapFileInfoBuilder.optionalFields.isDebugFile) {
                                l3 = l2 + 16L;
                            }
                            subFileParameterBuilder.indexStartAddress = l3;
                            l3 = ((ReadBuffer)object).readLong();
                            if (l3 < 1L) {
                                object = new StringBuilder();
                                ((StringBuilder)object).append("invalid sub-file size: ");
                                ((StringBuilder)object).append(l3);
                                return new TileSource.OpenResult(((StringBuilder)object).toString());
                            }
                            subFileParameterBuilder.subFileSize = l3;
                            subFileParameterBuilder.boundingBox = mapFileInfoBuilder.boundingBox;
                            subFileParameterArray[n] = subFileParameterBuilder.build();
                            this.updateZoomLevelInformation(subFileParameterArray[n]);
                            continue;
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("invalid start address: ");
                        ((StringBuilder)object).append(l2);
                        return new TileSource.OpenResult(((StringBuilder)object).toString());
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("invalid maximum zoom level: ");
                    ((StringBuilder)object).append(by);
                    return new TileSource.OpenResult(((StringBuilder)object).toString());
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("invalid minimum zoom level: ");
                ((StringBuilder)object).append(by2);
                return new TileSource.OpenResult(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid base zooom level: ");
            ((StringBuilder)object).append(by);
            return new TileSource.OpenResult(((StringBuilder)object).toString());
        }
        mapFileInfoBuilder.zoomLevel = new int[n2];
        this.subFileParameters = new SubFileParameter[this.zoomLevelMaximum + 1];
        for (n = n3; n < n2; ++n) {
            object = subFileParameterArray[n];
            mapFileInfoBuilder.zoomLevel[n] = ((SubFileParameter)object).baseZoomLevel;
            for (n3 = ((SubFileParameter)object).zoomLevelMin; n3 <= ((SubFileParameter)object).zoomLevelMax; n3 = (int)((byte)(n3 + 1))) {
                this.subFileParameters[n3] = object;
            }
        }
        return TileSource.OpenResult.SUCCESS;
    }

    private void updateZoomLevelInformation(SubFileParameter subFileParameter) {
        if (this.zoomLevelMinimum > subFileParameter.zoomLevelMin) {
            this.zoomLevelMinimum = subFileParameter.zoomLevelMin;
        }
        if (this.zoomLevelMaximum < subFileParameter.zoomLevelMax) {
            this.zoomLevelMaximum = subFileParameter.zoomLevelMax;
        }
    }

    public MapFileInfo getMapFileInfo() {
        return this.mapFileInfo;
    }

    public byte getQueryZoomLevel(byte by) {
        byte by2 = this.zoomLevelMaximum;
        if (by > by2) {
            return by2;
        }
        by2 = this.zoomLevelMinimum;
        if (by < by2) {
            return by2;
        }
        return by;
    }

    public SubFileParameter getSubFileParameter(int n) {
        return this.subFileParameters[n];
    }

    public TileSource.OpenResult readHeader(ReadBuffer object, long l) throws IOException {
        Object object2 = RequiredFields.readMagicByte((ReadBuffer)object);
        if (!((TileSource.OpenResult)object2).isSuccess()) {
            return object2;
        }
        object2 = RequiredFields.readRemainingHeader((ReadBuffer)object);
        if (!((TileSource.OpenResult)object2).isSuccess()) {
            return object2;
        }
        object2 = new MapFileInfoBuilder();
        TileSource.OpenResult openResult = RequiredFields.readFileVersion((ReadBuffer)object, (MapFileInfoBuilder)object2);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readFileSize((ReadBuffer)object, l, (MapFileInfoBuilder)object2);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readMapDate((ReadBuffer)object, (MapFileInfoBuilder)object2);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readBoundingBox((ReadBuffer)object, (MapFileInfoBuilder)object2);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readTilePixelSize((ReadBuffer)object, (MapFileInfoBuilder)object2);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readProjectionName((ReadBuffer)object, (MapFileInfoBuilder)object2);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = OptionalFields.readOptionalFields((ReadBuffer)object, (MapFileInfoBuilder)object2);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readPoiTags((ReadBuffer)object, (MapFileInfoBuilder)object2);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = RequiredFields.readWayTags((ReadBuffer)object, (MapFileInfoBuilder)object2);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        if (!((TileSource.OpenResult)(object = this.readSubFileParameters((ReadBuffer)object, l, (MapFileInfoBuilder)object2))).isSuccess()) {
            return object;
        }
        this.mapFileInfo = ((MapFileInfoBuilder)object2).build();
        return TileSource.OpenResult.SUCCESS;
    }
}

