/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile.header;

import org.oscim.core.GeoPoint;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.header.MapFileInfoBuilder;

final class OptionalFields {
    private static final int HEADER_BITMASK_COMMENT = 8;
    private static final int HEADER_BITMASK_CREATED_BY = 4;
    private static final int HEADER_BITMASK_DEBUG = 128;
    private static final int HEADER_BITMASK_LANGUAGES_PREFERENCE = 16;
    private static final int HEADER_BITMASK_START_POSITION = 64;
    private static final int HEADER_BITMASK_START_ZOOM_LEVEL = 32;
    private static final int START_ZOOM_LEVEL_MAX = 22;
    String comment;
    String createdBy;
    final boolean hasComment;
    final boolean hasCreatedBy;
    final boolean hasLanguagesPreference;
    final boolean hasStartPosition;
    final boolean hasStartZoomLevel;
    final boolean isDebugFile;
    String languagesPreference;
    GeoPoint startPosition;
    Byte startZoomLevel;

    private OptionalFields(byte by) {
        boolean bl = true;
        boolean bl2 = (by & 0x80) != 0;
        this.isDebugFile = bl2;
        bl2 = (by & 0x40) != 0;
        this.hasStartPosition = bl2;
        bl2 = (by & 0x20) != 0;
        this.hasStartZoomLevel = bl2;
        bl2 = (by & 0x10) != 0;
        this.hasLanguagesPreference = bl2;
        bl2 = (by & 8) != 0;
        this.hasComment = bl2;
        bl2 = (by & 4) != 0 ? bl : false;
        this.hasCreatedBy = bl2;
    }

    private TileSource.OpenResult readLanguagesPreference(ReadBuffer readBuffer) {
        if (this.hasLanguagesPreference) {
            this.languagesPreference = readBuffer.readUTF8EncodedString();
        }
        return TileSource.OpenResult.SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TileSource.OpenResult readMapStartPosition(ReadBuffer object) {
        if (!this.hasStartPosition) return TileSource.OpenResult.SUCCESS;
        int n = ((ReadBuffer)object).readInt();
        if (n >= -90000000 && n <= 90000000) {
            int n2 = ((ReadBuffer)object).readInt();
            if (n2 >= -180000000 && n2 <= 180000000) {
                this.startPosition = new GeoPoint(n, n2);
                return TileSource.OpenResult.SUCCESS;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid map start longitude: ");
            ((StringBuilder)object).append(n2);
            return new TileSource.OpenResult(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("invalid map start latitude: ");
        ((StringBuilder)object).append(n);
        return new TileSource.OpenResult(((StringBuilder)object).toString());
    }

    private TileSource.OpenResult readMapStartZoomLevel(ReadBuffer object) {
        if (this.hasStartZoomLevel) {
            byte by = ((ReadBuffer)object).readByte();
            if (by >= 0 && by <= 22) {
                this.startZoomLevel = by;
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("invalid map start zoom level: ");
                ((StringBuilder)object).append(by);
                return new TileSource.OpenResult(((StringBuilder)object).toString());
            }
        }
        return TileSource.OpenResult.SUCCESS;
    }

    private TileSource.OpenResult readOptionalFields(ReadBuffer readBuffer) {
        TileSource.OpenResult openResult = this.readMapStartPosition(readBuffer);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = this.readMapStartZoomLevel(readBuffer);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = this.readLanguagesPreference(readBuffer);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        if (this.hasComment) {
            this.comment = readBuffer.readUTF8EncodedString();
        }
        if (this.hasCreatedBy) {
            this.createdBy = readBuffer.readUTF8EncodedString();
        }
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readOptionalFields(ReadBuffer object, MapFileInfoBuilder mapFileInfoBuilder) {
        OptionalFields optionalFields;
        mapFileInfoBuilder.optionalFields = optionalFields = new OptionalFields(((ReadBuffer)object).readByte());
        if (!((TileSource.OpenResult)(object = optionalFields.readOptionalFields((ReadBuffer)object))).isSuccess()) {
            return object;
        }
        return TileSource.OpenResult.SUCCESS;
    }
}

