/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile.header;

import java.io.IOException;
import org.oscim.core.BoundingBox;
import org.oscim.core.Tag;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.header.MapFileInfoBuilder;

final class RequiredFields {
    private static final String BINARY_OSM_MAGIC_BYTE = "mapsforge binary OSM";
    private static final int HEADER_SIZE_MAX = 1000000;
    private static final int HEADER_SIZE_MIN = 70;
    static final int LATITUDE_MAX = 90000000;
    static final int LATITUDE_MIN = -90000000;
    static final int LONGITUDE_MAX = 180000000;
    static final int LONGITUDE_MIN = -180000000;
    private static final String MERCATOR = "Mercator";
    private static final char SPACE = ' ';
    private static final int SUPPORTED_FILE_VERSION_MAX = 5;
    private static final int SUPPORTED_FILE_VERSION_MIN = 3;

    private RequiredFields() {
        throw new IllegalStateException();
    }

    static TileSource.OpenResult readBoundingBox(ReadBuffer object, MapFileInfoBuilder mapFileInfoBuilder) {
        int n = ((ReadBuffer)object).readInt();
        if (n >= -90000000 && n <= 90000000) {
            int n2 = ((ReadBuffer)object).readInt();
            if (n2 >= -180000000 && n2 <= 180000000) {
                int n3 = ((ReadBuffer)object).readInt();
                if (n3 >= -90000000 && n3 <= 90000000) {
                    int n4 = ((ReadBuffer)object).readInt();
                    if (n4 >= -180000000 && n4 <= 180000000) {
                        if (n > n3) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("invalid latitude range: ");
                            ((StringBuilder)object).append(n);
                            ((StringBuilder)object).append(' ');
                            ((StringBuilder)object).append(n3);
                            return new TileSource.OpenResult(((StringBuilder)object).toString());
                        }
                        if (n2 > n4) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("invalid longitude range: ");
                            ((StringBuilder)object).append(n2);
                            ((StringBuilder)object).append(' ');
                            ((StringBuilder)object).append(n4);
                            return new TileSource.OpenResult(((StringBuilder)object).toString());
                        }
                        mapFileInfoBuilder.boundingBox = new BoundingBox(n, n2, n3, n4);
                        return TileSource.OpenResult.SUCCESS;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("invalid maximum longitude: ");
                    ((StringBuilder)object).append(n4);
                    return new TileSource.OpenResult(((StringBuilder)object).toString());
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("invalid maximum latitude: ");
                ((StringBuilder)object).append(n3);
                return new TileSource.OpenResult(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid minimum longitude: ");
            ((StringBuilder)object).append(n2);
            return new TileSource.OpenResult(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("invalid minimum latitude: ");
        ((StringBuilder)object).append(n);
        return new TileSource.OpenResult(((StringBuilder)object).toString());
    }

    static TileSource.OpenResult readFileSize(ReadBuffer object, long l, MapFileInfoBuilder mapFileInfoBuilder) {
        long l2 = ((ReadBuffer)object).readLong();
        if (l2 != l) {
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid file size: ");
            ((StringBuilder)object).append(l2);
            return new TileSource.OpenResult(((StringBuilder)object).toString());
        }
        mapFileInfoBuilder.fileSize = l;
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readFileVersion(ReadBuffer object, MapFileInfoBuilder mapFileInfoBuilder) {
        int n = ((ReadBuffer)object).readInt();
        if (n >= 3 && n <= 5) {
            mapFileInfoBuilder.fileVersion = n;
            return TileSource.OpenResult.SUCCESS;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("unsupported file version: ");
        ((StringBuilder)object).append(n);
        return new TileSource.OpenResult(((StringBuilder)object).toString());
    }

    static TileSource.OpenResult readMagicByte(ReadBuffer object) throws IOException {
        if (!((ReadBuffer)object).readFromFile(24)) {
            return new TileSource.OpenResult("reading magic byte has failed");
        }
        if (!BINARY_OSM_MAGIC_BYTE.equals(object = ((ReadBuffer)object).readUTF8EncodedString(20))) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("invalid magic byte: ");
            stringBuilder.append((String)object);
            return new TileSource.OpenResult(stringBuilder.toString());
        }
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readMapDate(ReadBuffer object, MapFileInfoBuilder mapFileInfoBuilder) {
        long l = ((ReadBuffer)object).readLong();
        if (l < 1200000000000L) {
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid map date: ");
            ((StringBuilder)object).append(l);
            return new TileSource.OpenResult(((StringBuilder)object).toString());
        }
        mapFileInfoBuilder.mapDate = l;
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readPoiTags(ReadBuffer object, MapFileInfoBuilder mapFileInfoBuilder) {
        int n = ((ReadBuffer)object).readShort();
        if (n < 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid number of POI tags: ");
            ((StringBuilder)object).append(n);
            return new TileSource.OpenResult(((StringBuilder)object).toString());
        }
        Tag[] tagArray = new Tag[n];
        for (int i = 0; i < n; ++i) {
            String string2 = ((ReadBuffer)object).readUTF8EncodedString();
            if (string2 == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("POI tag must not be null: ");
                ((StringBuilder)object).append(i);
                return new TileSource.OpenResult(((StringBuilder)object).toString());
            }
            tagArray[i] = Tag.parse(string2);
        }
        mapFileInfoBuilder.poiTags = tagArray;
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readProjectionName(ReadBuffer object, MapFileInfoBuilder object2) {
        if (!MERCATOR.equals(object = ((ReadBuffer)object).readUTF8EncodedString())) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("unsupported projection: ");
            ((StringBuilder)object2).append((String)object);
            return new TileSource.OpenResult(((StringBuilder)object2).toString());
        }
        ((MapFileInfoBuilder)object2).projectionName = object;
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readRemainingHeader(ReadBuffer object) throws IOException {
        int n = ((ReadBuffer)object).readInt();
        if (n >= 70 && n <= 1000000) {
            if (!((ReadBuffer)object).readFromFile(n)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("reading header data has failed: ");
                ((StringBuilder)object).append(n);
                return new TileSource.OpenResult(((StringBuilder)object).toString());
            }
            return TileSource.OpenResult.SUCCESS;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("invalid remaining header size: ");
        ((StringBuilder)object).append(n);
        return new TileSource.OpenResult(((StringBuilder)object).toString());
    }

    static TileSource.OpenResult readTilePixelSize(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        mapFileInfoBuilder.tilePixelSize = readBuffer.readShort();
        return TileSource.OpenResult.SUCCESS;
    }

    static TileSource.OpenResult readWayTags(ReadBuffer object, MapFileInfoBuilder mapFileInfoBuilder) {
        int n = ((ReadBuffer)object).readShort();
        if (n < 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid number of way tags: ");
            ((StringBuilder)object).append(n);
            return new TileSource.OpenResult(((StringBuilder)object).toString());
        }
        Tag[] tagArray = new Tag[n];
        for (int i = 0; i < n; ++i) {
            String string2 = ((ReadBuffer)object).readUTF8EncodedString();
            if (string2 == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("way tag must not be null: ");
                ((StringBuilder)object).append(i);
                return new TileSource.OpenResult(((StringBuilder)object).toString());
            }
            tagArray[i] = Tag.parse(string2);
        }
        mapFileInfoBuilder.wayTags = tagArray;
        return TileSource.OpenResult.SUCCESS;
    }
}

