/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile.header;

import org.oscim.tiling.source.mapfile.Projection;
import org.oscim.tiling.source.mapfile.header.SubFileParameterBuilder;

public class SubFileParameter {
    public static final byte BYTES_PER_INDEX_ENTRY = 5;
    private static final double COORDINATES_DIVISOR = 1000000.0;
    public final byte baseZoomLevel;
    public final int blockEntriesTableSize;
    public final long blocksHeight;
    public final long blocksWidth;
    public final long boundaryTileBottom;
    public final long boundaryTileLeft;
    public final long boundaryTileRight;
    public final long boundaryTileTop;
    private final int hashCodeValue;
    public final long indexEndAddress;
    public final long indexStartAddress;
    public final long numberOfBlocks;
    public final long startAddress;
    public final long subFileSize;
    public final byte zoomLevelMax;
    public final byte zoomLevelMin;

    SubFileParameter(SubFileParameterBuilder subFileParameterBuilder) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        this.startAddress = subFileParameterBuilder.startAddress;
        this.indexStartAddress = l5 = subFileParameterBuilder.indexStartAddress;
        this.subFileSize = subFileParameterBuilder.subFileSize;
        byte by = subFileParameterBuilder.baseZoomLevel;
        this.baseZoomLevel = by;
        byte by2 = subFileParameterBuilder.zoomLevelMin;
        this.zoomLevelMin = by2;
        byte by3 = subFileParameterBuilder.zoomLevelMax;
        this.zoomLevelMax = by3;
        this.hashCodeValue = this.calculateHashCode();
        this.boundaryTileBottom = l4 = Projection.latitudeToTileY((double)subFileParameterBuilder.boundingBox.minLatitudeE6 / 1000000.0, by);
        this.boundaryTileLeft = l3 = Projection.longitudeToTileX((double)subFileParameterBuilder.boundingBox.minLongitudeE6 / 1000000.0, by);
        this.boundaryTileTop = l2 = Projection.latitudeToTileY((double)subFileParameterBuilder.boundingBox.maxLatitudeE6 / 1000000.0, by);
        this.boundaryTileRight = l = Projection.longitudeToTileX((double)subFileParameterBuilder.boundingBox.maxLongitudeE6 / 1000000.0, by);
        this.blocksWidth = l = l - l3 + 1L;
        this.blocksHeight = l4 = l4 - l2 + 1L;
        this.numberOfBlocks = l4 = l * l4;
        this.indexEndAddress = l5 + l4 * 5L;
        this.blockEntriesTableSize = (by3 - by2 + 1) * 2 * 2;
    }

    private int calculateHashCode() {
        long l = this.startAddress;
        int n = (int)(l ^ l >>> 32);
        l = this.subFileSize;
        return ((217 + n) * 31 + (int)(l >>> 32 ^ l)) * 31 + this.baseZoomLevel;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SubFileParameter)) {
            return false;
        }
        object = (SubFileParameter)object;
        if (this.startAddress != ((SubFileParameter)object).startAddress) {
            return false;
        }
        if (this.subFileSize != ((SubFileParameter)object).subFileSize) {
            return false;
        }
        return this.baseZoomLevel == ((SubFileParameter)object).baseZoomLevel;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SubFileParameter [baseZoomLevel=");
        stringBuilder.append(this.baseZoomLevel);
        stringBuilder.append(", blockEntriesTableSize=");
        stringBuilder.append(this.blockEntriesTableSize);
        stringBuilder.append(", blocksHeight=");
        stringBuilder.append(this.blocksHeight);
        stringBuilder.append(", blocksWidth=");
        stringBuilder.append(this.blocksWidth);
        stringBuilder.append(", boundaryTileBottom=");
        stringBuilder.append(this.boundaryTileBottom);
        stringBuilder.append(", boundaryTileLeft=");
        stringBuilder.append(this.boundaryTileLeft);
        stringBuilder.append(", boundaryTileRight=");
        stringBuilder.append(this.boundaryTileRight);
        stringBuilder.append(", boundaryTileTop=");
        stringBuilder.append(this.boundaryTileTop);
        stringBuilder.append(", indexStartAddress=");
        stringBuilder.append(this.indexStartAddress);
        stringBuilder.append(", numberOfBlocks=");
        stringBuilder.append(this.numberOfBlocks);
        stringBuilder.append(", startAddress=");
        stringBuilder.append(this.startAddress);
        stringBuilder.append(", subFileSize=");
        stringBuilder.append(this.subFileSize);
        stringBuilder.append(", zoomLevelMax=");
        stringBuilder.append(this.zoomLevelMax);
        stringBuilder.append(", zoomLevelMin=");
        stringBuilder.append(this.zoomLevelMin);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

