/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mvt;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.source.PbfDecoder;
import org.oscim.utils.math.MathUtils;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDecoder
extends PbfDecoder {
    private static final int CLOSE_PATH = 7;
    private static final int LINE_TO = 2;
    private static final int MOVE_TO = 1;
    private static final float REF_TILE_SIZE = 4096.0f;
    private static final int TAG_FEATURE_GEOMETRY = 4;
    private static final int TAG_FEATURE_ID = 1;
    private static final int TAG_FEATURE_TAGS = 2;
    private static final int TAG_FEATURE_TYPE = 3;
    private static final int TAG_GEOM_LINE = 2;
    private static final int TAG_GEOM_POINT = 1;
    private static final int TAG_GEOM_POLYGON = 3;
    private static final int TAG_GEOM_UNKNOWN = 0;
    private static final int TAG_LAYER_EXTENT = 5;
    private static final int TAG_LAYER_FEATURES = 2;
    private static final int TAG_LAYER_KEYS = 3;
    private static final int TAG_LAYER_NAME = 1;
    private static final int TAG_LAYER_VALUES = 4;
    private static final int TAG_LAYER_VERSION = 15;
    private static final int TAG_TILE_LAYERS = 3;
    private static final int TAG_VALUE_BOOL = 7;
    private static final int TAG_VALUE_DOUBLE = 3;
    private static final int TAG_VALUE_FLOAT = 2;
    private static final int TAG_VALUE_LONG = 4;
    private static final int TAG_VALUE_SINT = 6;
    private static final int TAG_VALUE_STRING = 1;
    private static final int TAG_VALUE_UINT = 5;
    private static final Logger log = LoggerFactory.getLogger(TileDecoder.class);
    private int lastX;
    private int lastY;
    private final Pool<Feature> mFeaturePool;
    private final String mLocale;
    private ITileDataSink mMapDataCallback;
    private float mScale;
    private Tile mTile;
    private short[] mTmpTags = new short[1024];

    public TileDecoder() {
        this("");
    }

    public TileDecoder(String string2) {
        this.mFeaturePool = new Pool<Feature>(){
            int count;

            @Override
            protected boolean clearItem(Feature feature) {
                int n = this.count;
                if (n > 100) {
                    this.count = n - 1;
                    return false;
                }
                feature.elem.tags.clear();
                feature.elem.clear();
                feature.tags = null;
                feature.type = 0;
                feature.numTags = 0;
                return true;
            }

            @Override
            protected Feature createItem() {
                ++this.count;
                return new Feature();
            }
        };
        this.mLocale = string2;
    }

    /*
     * Unable to fully structure code
     */
    private int decodeCoordinates(int var1_1, Feature var2_2) throws IOException {
        block14: {
            block15: {
                block13: {
                    var3_3 = this.decodeVarint32();
                    this.fillBuffer(var3_3);
                    if (var2_2 == null) {
                        this.bufferPos += var3_3;
                        return 0;
                    }
                    var2_2 = var2_2.elem;
                    if (var1_1 != 2) break block13;
                    var2_2.startLine();
                    var4_4 = 0;
                    var5_5 = true;
                    break block14;
                }
                if (var1_1 != 3) break block15;
                var2_2.startPolygon();
                ** GOTO lbl26
            }
            if (var1_1 == 1) {
                var2_2.startPoints();
                var6_6 = 1;
            } else {
                if (var1_1 == 0) {
                    var2_2.startPoints();
                }
lbl26:
                // 4 sources

                var6_6 = 0;
            }
            var5_5 = false;
            var4_4 = var6_6;
        }
        var7_7 = this.bufferPos;
        var6_6 = 0;
        var8_8 = 0;
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = 0;
        while (this.bufferPos < var7_7 + var3_3) {
            var12_12 = var6_6;
            if (var6_6 == 0) {
                var6_6 = this.decodeVarint32Filled();
                var12_12 = var6_6 >>> 3;
                var6_6 &= 7;
                var11_11 = var8_8;
                if (var5_5) {
                    var11_11 = var8_8;
                    if (var8_8 != 0) {
                        var13_13 = var9_9;
                        var14_14 = this.mScale;
                        var2_2.addPoint(var13_13 / var14_14, (float)var10_10 / var14_14);
                        var11_11 = 0;
                    }
                }
                if (var6_6 == 7) {
                    var2_2.startHole();
                    var12_12 = var6_6;
                    var6_6 = 0;
                    var8_8 = var11_11;
                    var11_11 = var12_12;
                    continue;
                }
                if (var6_6 == 1 && var1_1 == 2) {
                    var2_2.startLine();
                }
                if (var12_12 == 0) {
                    var15_15 = var6_6;
                    var6_6 = var12_12;
                    var8_8 = var11_11;
                    var11_11 = var15_15;
                    continue;
                }
                var11_11 = var6_6;
            }
            var6_6 = var12_12 - 1;
            var8_8 = this.decodeVarint32Filled();
            var10_10 = -(var8_8 & 1);
            this.lastX = var9_9 = this.lastX + (var10_10 ^ var8_8 >>> 1);
            var8_8 = this.decodeVarint32Filled();
            var10_10 = -(var8_8 & 1);
            this.lastY = var10_10 = this.lastY + (var10_10 ^ var8_8 >>> 1);
            if (var4_4 == 0 && var11_11 != 1 && var11_11 != 2) {
                var8_8 = 1;
                continue;
            }
            var13_13 = var9_9;
            var14_14 = this.mScale;
            var2_2.addPoint(var13_13 / var14_14, (float)var10_10 / var14_14);
            var8_8 = 0;
        }
        if (var5_5 && var8_8 != 0) {
            var14_14 = var9_9;
            var13_13 = this.mScale;
            var2_2.addPoint(var14_14 / var13_13, (float)var10_10 / var13_13);
        }
        return 1;
    }

    private void decodeFeature(ArrayList<Feature> arrayList) throws IOException {
        int n;
        int n2 = this.decodeVarint32();
        int n3 = this.position();
        this.lastX = 0;
        this.lastY = 0;
        this.mTmpTags[0] = (short)-1;
        Object object = null;
        int n4 = 0;
        int n5 = 0;
        while (this.position() < n3 + n2 && (n = this.decodeVarint32()) != 0) {
            if ((n >>>= 3) != 1) {
                Object object2;
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append(this.mTile);
                            ((StringBuilder)object2).append(" invalid type for feature: ");
                            ((StringBuilder)object2).append(n);
                            this.error(((StringBuilder)object2).toString());
                            continue;
                        }
                        Iterator<Feature> iterator2 = arrayList.iterator();
                        do {
                            object2 = object;
                        } while (iterator2.hasNext() && !((Feature)(object2 = iterator2.next())).match(this.mTmpTags, n4, n5));
                        object = object2;
                        if (object2 == null) {
                            object = this.mFeaturePool.get();
                            n = n4 << 1;
                            ((Feature)object).tags = new short[n];
                            System.arraycopy(this.mTmpTags, 0, ((Feature)object).tags, 0, n);
                            ((Feature)object).numTags = n4;
                            ((Feature)object).type = n5;
                            arrayList.add((Feature)object);
                        }
                        this.decodeCoordinates(n5, (Feature)object);
                        continue;
                    }
                    n5 = this.decodeVarint32();
                    continue;
                }
                this.mTmpTags = this.decodeUnsignedVarintArray(this.mTmpTags);
                while (n4 < ((short[])(object2 = this.mTmpTags)).length && object2[n4] >= 0) {
                    n4 += 2;
                }
                n4 >>= 1;
                continue;
            }
            this.decodeVarint32();
        }
    }

    private boolean decodeLayer() throws IOException {
        Object object;
        int n;
        int n2 = this.decodeVarint32();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Object object2 = new ArrayList<Feature>();
        int n3 = this.position();
        Object object3 = null;
        int n4 = 0;
        while (this.position() < n3 + n2 && (n = this.decodeVarint32()) != 0) {
            if ((n >>= 3) != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            if (n != 5) {
                                if (n != 15) {
                                    object = new StringBuilder();
                                    ((StringBuilder)object).append(this.mTile);
                                    ((StringBuilder)object).append(" invalid type for layer: ");
                                    ((StringBuilder)object).append(n);
                                    this.error(((StringBuilder)object).toString());
                                    continue;
                                }
                                this.decodeVarint32();
                                continue;
                            }
                            this.decodeVarint32();
                            continue;
                        }
                        arrayList2.add(this.decodeValue());
                        continue;
                    }
                    arrayList.add(this.decodeString());
                    continue;
                }
                ++n4;
                this.decodeFeature((ArrayList<Feature>)object2);
                continue;
            }
            object3 = this.decodeString();
        }
        object = new Tag("layer", (String)object3);
        if (n4 == 0) {
            return true;
        }
        n2 = -1;
        n3 = -1;
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            object3 = (String)arrayList.get(n4);
            if (!((String)object3).startsWith("name")) {
                n = n2;
            } else {
                n = ((String)object3).length();
                if (n == 4) {
                    n = n4;
                } else if (n < 7) {
                    n = n2;
                } else {
                    n = n2;
                    if (this.mLocale.equals(((String)object3).substring(5))) {
                        n3 = n4;
                        n = n2;
                    }
                }
            }
            n2 = n;
        }
        object2 = ((ArrayList)object2).iterator();
        while (object2.hasNext()) {
            Feature feature = (Feature)object2.next();
            if (feature.elem.type == GeometryBuffer.GeometryType.NONE) continue;
            feature.elem.tags.clear();
            feature.elem.tags.add((Tag)object);
            n = 0;
            object3 = null;
            for (n4 = 0; n4 < feature.numTags << 1; n4 += 2) {
                short s = feature.tags[n4];
                if (s == n2) {
                    object3 = (String)arrayList2.get(feature.tags[n4 + 1]);
                    continue;
                }
                String string2 = (String)arrayList2.get(feature.tags[n4 + 1]);
                if (s == n3) {
                    feature.elem.tags.add(new Tag("name", string2, false));
                    n = 1;
                    continue;
                }
                String string3 = (String)arrayList.get(s);
                if (string3.startsWith("name")) continue;
                feature.elem.tags.add(new Tag(string3, string2));
            }
            if (n == 0 && object3 != null) {
                feature.elem.tags.add(new Tag("name", (String)object3, false));
            }
            if (!feature.elem.tags.containsKey("height") && feature.elem.tags.containsKey("volume") && feature.elem.tags.containsKey("area")) {
                float f = MathUtils.round2(Float.parseFloat(feature.elem.tags.getValue("volume")) / Float.parseFloat(feature.elem.tags.getValue("area")));
                feature.elem.tags.add(new Tag("height", String.valueOf(f), false));
            }
            feature.elem.setLayer(5);
            this.mMapDataCallback.process(feature.elem);
            object3 = this.mFeaturePool.release(feature);
        }
        return true;
    }

    private String decodeValue() throws IOException {
        int n;
        int n2 = this.decodeVarint32();
        int n3 = this.position();
        String string2 = null;
        block9: while (this.position() < n3 + n2 && (n = this.decodeVarint32()) != 0) {
            switch (n >> 3) {
                default: {
                    continue block9;
                }
                case 7: {
                    if (this.decodeBool()) {
                        string2 = "yes";
                        continue block9;
                    }
                    string2 = "no";
                    continue block9;
                }
                case 6: {
                    string2 = String.valueOf(TileDecoder.deZigZag(this.decodeVarint32()));
                    continue block9;
                }
                case 5: {
                    string2 = String.valueOf(this.decodeVarint32());
                    continue block9;
                }
                case 4: {
                    string2 = String.valueOf(this.decodeVarint64());
                    continue block9;
                }
                case 3: {
                    string2 = String.valueOf(this.decodeDouble());
                    continue block9;
                }
                case 2: {
                    string2 = String.valueOf(this.decodeFloat());
                    continue block9;
                }
                case 1: 
            }
            string2 = this.decodeString();
        }
        return string2;
    }

    @Override
    public boolean decode(Tile object, ITileDataSink object2, InputStream inputStream) throws IOException {
        int n;
        this.setInputStream(inputStream);
        this.mTile = object;
        this.mMapDataCallback = object2;
        this.mScale = 4096.0f / (float)Tile.SIZE;
        while (this.hasData() && (n = this.decodeVarint32()) > 0) {
            if ((n >>= 3) != 3) {
                object = new StringBuilder();
                ((StringBuilder)object).append(this.mTile);
                ((StringBuilder)object).append(" invalid type for tile: ");
                ((StringBuilder)object).append(n);
                this.error(((StringBuilder)object).toString());
                return false;
            }
            this.decodeLayer();
        }
        if (this.hasData()) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(object);
            ((StringBuilder)object2).append(" invalid tile");
            this.error(((StringBuilder)object2).toString());
            return false;
        }
        return true;
    }

    static class Feature
    extends Inlist<Feature> {
        final MapElement elem = new MapElement();
        int numTags;
        short[] tags;
        int type;

        Feature() {
        }

        boolean match(short[] sArray, int n, int n2) {
            if (this.numTags != n) {
                return false;
            }
            if (this.type != n2) {
                return false;
            }
            for (n = 0; n < this.numTags << 1; ++n) {
                if (this.tags[n] == sArray[n]) continue;
                return false;
            }
            return true;
        }
    }
}

