/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.oscimap4;

import java.io.IOException;
import java.io.InputStream;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.source.PbfDecoder;
import org.oscim.tiling.source.oscimap4.Tags;
import org.oscim.utils.math.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDecoder
extends PbfDecoder {
    private static final float REF_TILE_SIZE = 4096.0f;
    private static final int TAG_ELEM_COORDS = 13;
    private static final int TAG_ELEM_INDEX = 12;
    private static final int TAG_ELEM_LAYER = 21;
    private static final int TAG_ELEM_NUM_COORDINATES = 3;
    private static final int TAG_ELEM_NUM_INDICES = 1;
    private static final int TAG_ELEM_NUM_TAGS = 2;
    private static final int TAG_ELEM_TAGS = 11;
    private static final int TAG_TILE_LINE = 21;
    private static final int TAG_TILE_MESH = 24;
    private static final int TAG_TILE_NUM_KEYS = 12;
    private static final int TAG_TILE_NUM_TAGS = 11;
    private static final int TAG_TILE_NUM_VALUES = 13;
    private static final int TAG_TILE_POINT = 23;
    private static final int TAG_TILE_POLY = 22;
    private static final int TAG_TILE_TAGS = 16;
    private static final int TAG_TILE_TAG_KEYS = 14;
    private static final int TAG_TILE_TAG_VALUES = 15;
    private static final int TAG_TILE_VERSION = 1;
    static final Logger log = LoggerFactory.getLogger(TileDecoder.class);
    private final MapElement mElem;
    private ITileDataSink mMapDataSink;
    private int[] mSArray = new int[100];
    private final float mScaleFactor = 4096.0f / (float)Tile.SIZE;
    private Tile mTile;
    private final TagSet mTileTags;
    private int mVersion;

    public TileDecoder() {
        this.mElem = new MapElement();
        this.mTileTags = new TagSet(100);
    }

    private boolean decodeElementTags(int n) throws IOException {
        if (this.mSArray.length < n) {
            this.mSArray = new int[n];
        }
        int[] nArray = this.mSArray;
        this.decodeVarintArray(n, nArray);
        this.mElem.tags.clear();
        int n2 = this.mTileTags.size();
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 >= 0 && n3 <= n2 - 1) {
                this.mElem.tags.add(this.mTileTags.get(n3));
                continue;
            }
            log.debug("{} invalid tag:{}", this.mTile, n3, i);
            return false;
        }
        return true;
    }

    private boolean decodeTileElement(int n) throws IOException {
        int n2;
        int n3 = this.decodeVarint32();
        int n4 = this.position();
        if (n == 23) {
            this.mElem.index[0] = 2;
            n2 = 1;
        } else {
            n2 = 0;
        }
        this.mElem.layer = 5;
        int n5 = 1;
        boolean bl = false;
        int n6 = 1;
        int n7 = n2;
        while (this.position() < n4 + n3 && (n2 = this.decodeVarint32()) != 0) {
            int n8;
            int n9;
            block27: {
                block23: {
                    block24: {
                        block25: {
                            block26: {
                                if ((n2 >>= 3) == 1) break block23;
                                if (n2 == 2) break block24;
                                if (n2 == 3) break block25;
                                if (n2 == 21) break block26;
                                switch (n2) {
                                    default: {
                                        log.debug("{} invalid type for way: {}", (Object)this.mTile, (Object)n2);
                                        n2 = n7;
                                        n9 = n5;
                                        n8 = n6;
                                        break block27;
                                    }
                                    case 13: {
                                        if (n7 == 0) {
                                            log.debug("{} no coordinates", (Object)this.mTile);
                                        }
                                        if (n == 24) {
                                            MapElement mapElement = this.mElem;
                                            n9 = n7 * 3;
                                            mapElement.ensurePointSize(n9 / 2, false);
                                            n2 = this.decodeInterleavedPoints3D(this.mElem.points, 1.0f);
                                            if (n2 != n9) {
                                                log.debug("{} wrong number of coordintes {}/{}", this.mTile, n7, n2);
                                                bl = true;
                                            }
                                            this.mElem.pointNextPos = n2;
                                            n2 = n7;
                                            n9 = n5;
                                            n8 = n6;
                                        } else {
                                            this.mElem.ensurePointSize(n7, false);
                                            int n10 = this.decodeInterleavedPoints(this.mElem, this.mScaleFactor);
                                            n2 = n7;
                                            n9 = n5;
                                            n8 = n6;
                                            if (n10 != n7) {
                                                log.debug("{} wrong number of coordintes {}/{}", this.mTile, n7, n10);
                                                bl = true;
                                                n2 = n7;
                                                n9 = n5;
                                                n8 = n6;
                                            }
                                        }
                                        break block27;
                                    }
                                    case 12: {
                                        if (n == 24) {
                                            this.decodeWayIndices(n6, false);
                                            n2 = n7;
                                            n9 = n5;
                                            n8 = n6;
                                        } else {
                                            n2 = this.decodeWayIndices(n6, true);
                                            n9 = n5;
                                            n8 = n6;
                                        }
                                        break block27;
                                    }
                                    case 11: {
                                        n2 = n7;
                                        n9 = n5;
                                        n8 = n6;
                                        if (!this.decodeElementTags(n5)) {
                                            return false;
                                        }
                                        break block27;
                                    }
                                }
                            }
                            this.mElem.layer = this.decodeVarint32();
                            n2 = n7;
                            n9 = n5;
                            n8 = n6;
                            break block27;
                        }
                        n2 = this.decodeVarint32();
                        n9 = n5;
                        n8 = n6;
                        break block27;
                    }
                    n9 = this.decodeVarint32();
                    n2 = n7;
                    n8 = n6;
                    break block27;
                }
                n8 = this.decodeVarint32();
                n9 = n5;
                n2 = n7;
            }
            n7 = n2;
            n5 = n9;
            n6 = n8;
        }
        if (!bl && n5 != 0 && n6 != 0) {
            switch (n) {
                default: {
                    break;
                }
                case 24: {
                    this.mElem.type = GeometryBuffer.GeometryType.TRIS;
                    break;
                }
                case 23: {
                    this.mElem.type = GeometryBuffer.GeometryType.POINT;
                    break;
                }
                case 22: {
                    this.mElem.type = GeometryBuffer.GeometryType.POLY;
                    break;
                }
                case 21: {
                    this.mElem.type = GeometryBuffer.GeometryType.LINE;
                }
            }
            this.mMapDataSink.process(this.mElem);
            return true;
        }
        log.debug("{} failed: bytes:{} tags:{} ({},{})", this.mTile, n3, this.mElem.tags, n6, n7);
        return false;
    }

    private boolean decodeTileTags(int n, int[] nArray, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < n << 1; i += 2) {
            String string2;
            Object object;
            int n2 = nArray[i];
            int n3 = nArray[i + 1];
            if (n2 < 256) {
                if (n2 > Tags.MAX_KEY) {
                    return false;
                }
                object = Tags.keys[n2];
            } else {
                if ((n2 -= 256) >= stringArray.length) {
                    return false;
                }
                object = stringArray[n2];
            }
            if (n3 < 256) {
                if (n3 > Tags.MAX_VALUE) {
                    return false;
                }
                string2 = Tags.values[n3];
            } else {
                if ((n3 -= 256) >= stringArray2.length) {
                    return false;
                }
                string2 = stringArray2[n3];
            }
            object = !("name".equals(object) || "addr:housenumber".equals(object) || "ref".equals(object) || "ele".equals(object)) ? (!"height".equals(object) && !"min_height".equals(object) ? new Tag((String)object, string2, false, true) : new Tag((String)object, String.valueOf(MathUtils.round2(Float.valueOf(string2).floatValue() / 100.0f)), false)) : new Tag((String)object, string2, false);
            this.mTileTags.add((Tag)object);
        }
        return true;
    }

    private int decodeWayIndices(int n, boolean bl) throws IOException {
        Object object = this.mElem;
        int n2 = 0;
        ((GeometryBuffer)object).ensureIndexSize(n, false);
        this.decodeVarintArray(n, this.mElem.index);
        object = this.mElem.index;
        if (bl) {
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 += object[i];
                object[i] = object[i] * 2;
            }
        }
        if (n < ((Object)object).length) {
            object[n] = -1;
        }
        return n2;
    }

    @Override
    public boolean decode(Tile stringArray, ITileDataSink stringArray2, InputStream inputStream) throws IOException {
        int n;
        TileDecoder.readUnsignedInt(inputStream, this.buffer);
        this.setInputStream(inputStream);
        this.mTile = stringArray;
        this.mMapDataSink = stringArray2;
        this.mTileTags.clearAndNullTags();
        stringArray2 = null;
        stringArray = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        block11: while (this.hasData() && (n = this.decodeVarint32()) > 0) {
            if ((n >>= 3) != 1) {
                switch (n) {
                    default: {
                        switch (n) {
                            default: {
                                log.debug("{} invalid type for tile:{}", (Object)this.mTile, (Object)n);
                                return false;
                            }
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                        }
                        this.decodeTileElement(n);
                        continue block11;
                    }
                    case 16: {
                        n = n4 * 2;
                        if (this.mSArray.length < n) {
                            this.mSArray = new int[n];
                        }
                        this.decodeVarintArray(n, this.mSArray);
                        if (this.decodeTileTags(n4, this.mSArray, stringArray2, stringArray)) continue block11;
                        log.debug("{} invalid tags", (Object)this.mTile);
                        return false;
                    }
                    case 15: {
                        if (stringArray != null && n6 < n3) {
                            stringArray[n6] = this.decodeString();
                            ++n6;
                            continue block11;
                        }
                        log.debug("{} wrong number of values {}", (Object)this.mTile, (Object)n3);
                        return false;
                    }
                    case 14: {
                        if (stringArray2 != null && n5 < n2) {
                            stringArray2[n5] = this.decodeString().intern();
                            ++n5;
                            continue block11;
                        }
                        log.debug("{} wrong number of keys {}", (Object)this.mTile, (Object)n2);
                        return false;
                    }
                    case 13: {
                        n3 = this.decodeVarint32();
                        stringArray = new String[n3];
                        continue block11;
                    }
                    case 12: {
                        n2 = this.decodeVarint32();
                        stringArray2 = new String[n2];
                        continue block11;
                    }
                    case 11: 
                }
                n4 = this.decodeVarint32();
                continue;
            }
            n = this.decodeVarint32();
            if (n >= 4 && this.mVersion <= 5) continue;
            log.debug("{} invalid version:{}", (Object)this.mTile, (Object)n);
            return false;
        }
        return true;
    }
}

