/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.test;

import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.TileSource;

public class TestTileSource
extends TileSource {
    public TestTileSource() {
        super(0, 18);
    }

    @Override
    public void close() {
    }

    @Override
    public ITileDataSource getDataSource() {
        return new TileDataSource();
    }

    @Override
    public TileSource.OpenResult open() {
        return TileSource.OpenResult.SUCCESS;
    }

    static class TileDataSource
    implements ITileDataSource {
        private static final Tag[] mTags = new Tag[]{new Tag("natural", "water")};
        private static final Tag[] mTagsBoundary;
        private static final Tag[] mTagsPlace;
        private static final Tag[] mTagsWay;
        private final MapElement mElem = new MapElement();
        private boolean renderBoundary = true;
        private boolean renderPlace = false;
        private boolean renderWays = true;

        static {
            mTagsWay = new Tag[]{new Tag("highway", "primary"), new Tag("name", "Highway Rd")};
            mTagsBoundary = new Tag[]{new Tag("boundary", "administrative"), new Tag("admin_level", "2")};
            mTagsPlace = new Tag[]{new Tag("place", "city"), null};
        }

        @Override
        public void cancel() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void query(MapTile mapTile, ITileDataSink iTileDataSink) {
            float f;
            int n = Tile.SIZE;
            MapElement mapElement = this.mElem;
            float f2 = n + 1;
            mapElement.clear();
            mapElement.startPolygon();
            mapElement.addPoint(-1.0f, -1.0f);
            mapElement.addPoint(f2, -1.0f);
            mapElement.addPoint(f2, f2);
            mapElement.addPoint(-1.0f, f2);
            f2 = n - 5;
            mapElement.startHole();
            mapElement.addPoint(5.0f, 5.0f);
            mapElement.addPoint(f2, 5.0f);
            mapElement.addPoint(f2, f2);
            mapElement.addPoint(5.0f, f2);
            int n2 = 0;
            mapElement.setLayer(0);
            mapElement.tags.set(mTags);
            iTileDataSink.process(mapElement);
            if (this.renderWays) {
                mapElement.clear();
                mapElement.startLine();
                int n3 = n / 2;
                f = n3;
                mapElement.addPoint(0.0f, f);
                f2 = n;
                mapElement.addPoint(f2, f);
                mapElement.startLine();
                mapElement.addPoint(f, -n / 2);
                mapElement.addPoint(f, f);
                mapElement.startLine();
                mapElement.addPoint(f, f);
                mapElement.addPoint(f, n3 + n);
                iTileDataSink.process(mapElement);
                mapElement.clear();
                mapElement.startLine();
                mapElement.addPoint(f, f);
                mapElement.addPoint(10.0f, 10.0f);
                mapElement.startLine();
                mapElement.addPoint(0.0f, 10.0f);
                mapElement.addPoint(f2, 10.0f);
                mapElement.startLine();
                mapElement.addPoint(10.0f, 0.0f);
                mapElement.addPoint(10.0f, f2);
                mapElement.setLayer(1);
                mapElement.tags.set(mTagsWay);
                iTileDataSink.process(mapElement);
            }
            if (this.renderBoundary) {
                mapElement.clear();
                mapElement.startPolygon();
                f2 = n / 2;
                while (n2 < 360) {
                    double d = Math.toRadians(n2);
                    float f3 = (float)Math.cos(d);
                    f = f2 - 40.0f;
                    mapElement.addPoint(f3 * f + f2, (float)Math.sin(d) * f + f2);
                    n2 += 4;
                }
                mapElement.setLayer(1);
                mapElement.tags.set(mTagsBoundary);
                iTileDataSink.process(mapElement);
            }
            if (this.renderPlace) {
                mapElement.clear();
                mapElement.startPoints();
                f2 = n / 2;
                mapElement.addPoint(f2, f2);
                Tag[] tagArray = mTagsPlace;
                tagArray[1] = new Tag("name", mapTile.toString());
                mapElement.tags.set(tagArray);
                iTileDataSink.process(mapElement);
            }
            iTileDataSink.completed(QueryResult.SUCCESS);
        }
    }
}

