/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.renderer.atlas.TextureAtlas;

public class BitmapPacker {
    private final int atlasHeight;
    private final int atlasWidth;
    private final boolean flipY;
    private final PackStrategy packStrategy;
    private final List<PackerAtlasItem> packerAtlasItems = new ArrayList<PackerAtlasItem>();
    private final int padding;

    public BitmapPacker(int n, int n2, int n3, PackStrategy packStrategy, boolean bl) {
        this.atlasWidth = n;
        this.atlasHeight = n2;
        this.padding = n3;
        this.packStrategy = packStrategy;
        this.flipY = bl;
    }

    public BitmapPacker(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3, new GuillotineStrategy(), bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rect add(Object object, Bitmap object2) {
        synchronized (this) {
            RuntimeException runtimeException;
            Object object3 = new Rect(0, 0, runtimeException.getWidth(), runtimeException.getHeight());
            if (((Rect)object3).width <= this.atlasWidth && ((Rect)object3).height <= this.atlasHeight) {
                PackerAtlasItem packerAtlasItem = this.packStrategy.pack(this, object, (Rect)object3);
                if (object != null) {
                    packerAtlasItem.rects.put(object, (Rect)object3);
                    packerAtlasItem.addedRects.add(object);
                }
                int n = ((Rect)object3).x;
                int n2 = ((Rect)object3).y;
                int n3 = ((Rect)object3).width;
                int n4 = ((Rect)object3).height;
                n3 = n2;
                if (this.flipY) {
                    n3 = packerAtlasItem.image.getHeight() - n2 - n4;
                }
                packerAtlasItem.drawBitmap((Bitmap)((Object)runtimeException), n, n3);
                return object3;
            }
            if (object == null) {
                object = new RuntimeException("PackerAtlasItem size too small for Bitmap.");
                throw object;
            }
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("PackerAtlasItem size too small for Bitmap: ");
            ((StringBuilder)object3).append(object);
            runtimeException = new RuntimeException(((StringBuilder)object3).toString());
            throw runtimeException;
        }
    }

    public int getAtlasCount() {
        return this.packerAtlasItems.size();
    }

    public PackerAtlasItem getAtlasItem(int n) {
        synchronized (this) {
            PackerAtlasItem packerAtlasItem = this.packerAtlasItems.get(n);
            return packerAtlasItem;
        }
    }

    public static class GuillotineStrategy
    implements PackStrategy {
        Comparator<Bitmap> comparator;

        private Node insert(Node node, Rect rect) {
            if (!node.full && node.leftChild != null && node.rightChild != null) {
                Node node2;
                Node node3 = node2 = this.insert(node.leftChild, rect);
                if (node2 == null) {
                    node3 = this.insert(node.rightChild, rect);
                }
                return node3;
            }
            if (node.full) {
                return null;
            }
            if (node.rect.width == rect.width && node.rect.height == rect.height) {
                return node;
            }
            if (node.rect.width >= rect.width && node.rect.height >= rect.height) {
                node.leftChild = new Node();
                node.rightChild = new Node();
                if (node.rect.width - rect.width > node.rect.height - rect.height) {
                    node.leftChild.rect.x = node.rect.x;
                    node.leftChild.rect.y = node.rect.y;
                    node.leftChild.rect.width = rect.width;
                    node.leftChild.rect.height = node.rect.height;
                    node.rightChild.rect.x = node.rect.x + rect.width;
                    node.rightChild.rect.y = node.rect.y;
                    node.rightChild.rect.width = node.rect.width - rect.width;
                    node.rightChild.rect.height = node.rect.height;
                } else {
                    node.leftChild.rect.x = node.rect.x;
                    node.leftChild.rect.y = node.rect.y;
                    node.leftChild.rect.width = node.rect.width;
                    node.leftChild.rect.height = rect.height;
                    node.rightChild.rect.x = node.rect.x;
                    node.rightChild.rect.y = node.rect.y + rect.height;
                    node.rightChild.rect.width = node.rect.width;
                    node.rightChild.rect.height = node.rect.height - rect.height;
                }
                return this.insert(node.leftChild, rect);
            }
            return null;
        }

        @Override
        public PackerAtlasItem pack(BitmapPacker bitmapPacker, Object object, Rect rect) {
            Node node;
            if (bitmapPacker.packerAtlasItems.size() == 0) {
                object = new GuillotineAtlasItem(bitmapPacker);
                bitmapPacker.packerAtlasItems.add(object);
            } else {
                object = (GuillotineAtlasItem)bitmapPacker.packerAtlasItems.get(bitmapPacker.packerAtlasItems.size() - 1);
            }
            int n = bitmapPacker.padding;
            rect.width += n;
            rect.height += n;
            Node node2 = node = this.insert(((GuillotineAtlasItem)object).root, rect);
            if (node == null) {
                object = new GuillotineAtlasItem(bitmapPacker);
                bitmapPacker.packerAtlasItems.add(object);
                node2 = this.insert(((GuillotineAtlasItem)object).root, rect);
            }
            node2.full = true;
            rect.set(node2.rect.x, node2.rect.y, node2.rect.width - n, node2.rect.height - n);
            return object;
        }

        @Override
        public void sort(ArrayList<Bitmap> arrayList) {
            if (this.comparator == null) {
                this.comparator = new Comparator<Bitmap>(){

                    @Override
                    public int compare(Bitmap bitmap, Bitmap bitmap2) {
                        return Math.max(bitmap.getWidth(), bitmap.getHeight()) - Math.max(bitmap2.getWidth(), bitmap2.getHeight());
                    }
                };
            }
            Collections.sort(arrayList, this.comparator);
        }

        static class GuillotineAtlasItem
        extends PackerAtlasItem {
            Node root;

            GuillotineAtlasItem(BitmapPacker bitmapPacker) {
                super(bitmapPacker);
                Node node;
                this.root = node = new Node();
                node.rect.x = bitmapPacker.padding;
                this.root.rect.y = bitmapPacker.padding;
                this.root.rect.width = bitmapPacker.atlasWidth - bitmapPacker.padding * 2;
                this.root.rect.height = bitmapPacker.atlasHeight - bitmapPacker.padding * 2;
            }
        }

        static final class Node {
            boolean full;
            Node leftChild;
            final Rect rect = new Rect();
            Node rightChild;

            Node() {
            }
        }
    }

    public static interface PackStrategy {
        public PackerAtlasItem pack(BitmapPacker var1, Object var2, Rect var3);

        public void sort(ArrayList<Bitmap> var1);
    }

    public static class PackerAtlasItem {
        final ArrayList<Object> addedRects;
        final Canvas canvas;
        final Bitmap image;
        HashMap<Object, Rect> rects = new HashMap();

        PackerAtlasItem(BitmapPacker object) {
            Bitmap bitmap;
            this.addedRects = new ArrayList();
            int n = CanvasAdapter.platform.isDesktop() ? 3 : 0;
            this.image = bitmap = CanvasAdapter.newBitmap(((BitmapPacker)object).atlasWidth, ((BitmapPacker)object).atlasHeight, n);
            this.canvas = object = CanvasAdapter.newCanvas();
            object.setBitmap(bitmap);
            object.fillColor(0);
        }

        void drawBitmap(Bitmap bitmap, int n, int n2) {
            this.canvas.drawBitmap(bitmap, n, n2);
        }

        public TextureAtlas getAtlas() {
            TextureAtlas textureAtlas = new TextureAtlas(this.image);
            for (Map.Entry<Object, Rect> entry : this.rects.entrySet()) {
                textureAtlas.addTextureRegion(entry.getKey(), entry.getValue().getAtlasRect());
            }
            return textureAtlas;
        }
    }

    private static class Rect {
        int height;
        int width;
        int x;
        int y;

        Rect() {
        }

        Rect(int n, int n2, int n3, int n4) {
            this.set(n, n2, n3, n4);
        }

        TextureAtlas.Rect getAtlasRect() {
            return new TextureAtlas.Rect(this.x, this.y, this.width, this.height);
        }

        void set(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }

    public static class SkylineStrategy
    implements PackStrategy {
        Comparator<Bitmap> comparator;

        @Override
        public PackerAtlasItem pack(BitmapPacker object, Object object2, Rect rect) {
            int n = ((BitmapPacker)object).padding;
            int n2 = ((BitmapPacker)object).atlasWidth;
            int n3 = n * 2;
            int n4 = n2 - n3;
            int n5 = ((BitmapPacker)object).atlasHeight - n3;
            int n6 = rect.width + n;
            int n7 = rect.height + n;
            int n8 = ((BitmapPacker)object).packerAtlasItems.size();
            for (n3 = 0; n3 < n8; ++n3) {
                Object object3;
                SkylineAtlasItem skylineAtlasItem = (SkylineAtlasItem)((BitmapPacker)object).packerAtlasItems.get(n3);
                object2 = null;
                int n9 = skylineAtlasItem.rows.size();
                for (n2 = 0; n2 < n9 - 1; ++n2) {
                    block10: {
                        SkylineAtlasItem.Row row;
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        row = skylineAtlasItem.rows.get(n2);
                                        if (row.x + n6 < n4) break block9;
                                        object3 = object2;
                                        break block10;
                                    }
                                    if (row.y + n7 < n5) break block11;
                                    object3 = object2;
                                    break block10;
                                }
                                if (n7 <= row.height) break block12;
                                object3 = object2;
                                break block10;
                            }
                            if (object2 == null) break block13;
                            object3 = object2;
                            if (row.height >= ((SkylineAtlasItem.Row)object2).height) break block10;
                        }
                        object3 = row;
                    }
                    object2 = object3;
                }
                object3 = object2;
                if (object2 == null) {
                    object2 = skylineAtlasItem.rows.get(skylineAtlasItem.rows.size() - 1);
                    if (((SkylineAtlasItem.Row)object2).y + n7 >= n5) continue;
                    if (((SkylineAtlasItem.Row)object2).x + n6 < n4) {
                        ((SkylineAtlasItem.Row)object2).height = Math.max(((SkylineAtlasItem.Row)object2).height, n7);
                        object3 = object2;
                    } else {
                        object3 = new SkylineAtlasItem.Row();
                        ((SkylineAtlasItem.Row)object3).y = ((SkylineAtlasItem.Row)object2).y + ((SkylineAtlasItem.Row)object2).height;
                        ((SkylineAtlasItem.Row)object3).height = n7;
                        if (((SkylineAtlasItem.Row)object3).y + ((SkylineAtlasItem.Row)object3).height > n5) {
                            continue;
                        }
                        skylineAtlasItem.rows.add((SkylineAtlasItem.Row)object3);
                    }
                }
                rect.x = ((SkylineAtlasItem.Row)object3).x;
                rect.y = ((SkylineAtlasItem.Row)object3).y;
                ((SkylineAtlasItem.Row)object3).x += n6;
                return skylineAtlasItem;
            }
            object2 = new SkylineAtlasItem((BitmapPacker)object);
            ((BitmapPacker)object).packerAtlasItems.add(object2);
            object = new SkylineAtlasItem.Row();
            ((SkylineAtlasItem.Row)object).x = n6 + n;
            ((SkylineAtlasItem.Row)object).y = n;
            ((SkylineAtlasItem.Row)object).height = n7;
            ((SkylineAtlasItem)object2).rows.add((SkylineAtlasItem.Row)object);
            rect.x = n;
            rect.y = n;
            return object2;
        }

        @Override
        public void sort(ArrayList<Bitmap> arrayList) {
            if (this.comparator == null) {
                this.comparator = new Comparator<Bitmap>(){

                    @Override
                    public int compare(Bitmap bitmap, Bitmap bitmap2) {
                        return bitmap.getHeight() - bitmap2.getHeight();
                    }
                };
            }
            Collections.sort(arrayList, this.comparator);
        }

        static class SkylineAtlasItem
        extends PackerAtlasItem {
            ArrayList<Row> rows = new ArrayList();

            SkylineAtlasItem(BitmapPacker bitmapPacker) {
                super(bitmapPacker);
            }

            static class Row {
                int height;
                int x;
                int y;

                Row() {
                }
            }
        }
    }
}

