/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.backend.canvas.Color;
import org.oscim.utils.FastMath;
import org.oscim.utils.math.Vec3;

public class ColorUtil {
    private static final Vec3 TMP_VEC = new Vec3();

    public static int desaturate(int n) {
        synchronized (ColorUtil.class) {
            Vec3 vec3 = TMP_VEC;
            ColorUtil.rgbToHsl(Color.r(n), Color.g(n), Color.b(n), vec3);
            n = ColorUtil.hslToRgb(vec3.x, 0.0, vec3.z);
            return n;
        }
    }

    public static int hslToRgb(double d, double d2, double d3) {
        return ColorUtil.hslToRgb(d, d2, d3, null);
    }

    public static int hslToRgb(double d, double d2, double d3, Vec3 vec3) {
        if (d2 == 0.0) {
            d2 = d = d3;
        } else {
            d2 = d3 < 0.5 ? (d2 + 1.0) * d3 : d3 + d2 - d3 * d2;
            double d4 = 2.0 * d3 - d2;
            double d5 = ColorUtil.hue2rgb(d4, d2, d + 0.0);
            d3 = ColorUtil.hue2rgb(d4, d2, d);
            d = ColorUtil.hue2rgb(d4, d2, d - 0.0);
            d2 = d5;
        }
        if (vec3 != null) {
            vec3.set(d2, d3, d);
        }
        return Color.get(d2, d3, d);
    }

    public static int hsvToRgb(double d, double d2, double d3) {
        return ColorUtil.hsvToRgb(d, d2, d3, null);
    }

    public static int hsvToRgb(double d, double d2, double d3, Vec3 vec3) {
        double d4;
        block7: {
            double d5;
            block8: {
                block1: {
                    block2: {
                        block3: {
                            block4: {
                                block5: {
                                    block6: {
                                        d = 6.0 * d;
                                        int n = (int)Math.floor(d);
                                        d5 = d - (double)n;
                                        d4 = (1.0 - d2) * d3;
                                        d = (1.0 - d5 * d2) * d3;
                                        d2 = d3 * (1.0 - (1.0 - d5) * d2);
                                        d5 = 0.0;
                                        if ((n %= 6) == 0) break block1;
                                        if (n == 1) break block2;
                                        if (n == 2) break block3;
                                        if (n == 3) break block4;
                                        if (n == 4) break block5;
                                        if (n == 5) break block6;
                                        d4 = d = 0.0;
                                        d2 = d5;
                                        break block7;
                                    }
                                    d5 = d;
                                    d = d4;
                                    break block8;
                                }
                                d = d4;
                                d4 = d2;
                                d2 = d3;
                                break block7;
                            }
                            d2 = d3;
                            break block7;
                        }
                        d = d3;
                        break block7;
                    }
                    d2 = d4;
                    d4 = d;
                    d = d3;
                    break block7;
                }
                d5 = d4;
                d = d2;
            }
            d4 = d3;
            d2 = d5;
        }
        if (vec3 != null) {
            vec3.set(d4, d, d2);
        }
        return Color.get(d4, d, d2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static double hue2rgb(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6 = d3;
        if (d3 < 0.0) {
            d6 = d3 + 1.0;
        }
        d3 = d6;
        if (d6 > 1.0) {
            d3 = d6 - 1.0;
        }
        if ((d5 = (d4 = d3 - 0.0) == 0.0 ? 0 : (d4 < 0.0 ? -1 : 1)) < 0) {
            d2 = (d2 - d) * 6.0 * d3;
            return d + d2;
        }
        if (d5 < 0) {
            return d2;
        }
        if (d5 >= 0) return d;
        d2 = (d2 - d) * (0.0 - d3) * 6.0;
        return d + d2;
    }

    public static int modHsv(int n, double d, double d2, double d3, boolean bl) {
        synchronized (ColorUtil.class) {
            Vec3 vec3 = TMP_VEC;
            ColorUtil.rgbToHsv(Color.r(n), Color.g(n), Color.b(n), vec3);
            n = ColorUtil.hsvToRgb(FastMath.clamp(d * vec3.x, 0.0, 1.0), FastMath.clamp(d2 * vec3.y, 0.0, 1.0), FastMath.clamp(vec3.z * d3, 0.0, 1.0));
            return n;
        }
    }

    public static Vec3 rgbToHsl(double d, double d2, double d3) {
        return ColorUtil.rgbToHsl(d, d2, d3, new Vec3());
    }

    /*
     * Unable to fully structure code
     */
    public static Vec3 rgbToHsl(double var0, double var2_1, double var4_2, Vec3 var6_3) {
        block5: {
            block3: {
                block4: {
                    var7_4 = var0 / 255.0;
                    var9_5 = var2_1 / 255.0;
                    var11_6 = var4_2 / 255.0;
                    var2_1 = Math.max(var7_4, Math.max(var9_5, var11_6));
                    var4_2 = Math.min(var7_4, Math.min(var9_5, var11_6));
                    var0 = var2_1 + var4_2;
                    var13_7 = var0 / 2.0;
                    if (var2_1 == var4_2) break block3;
                    var15_8 = var2_1 - var4_2;
                    if (var13_7 > 0.5) {
                        var0 = 2.0 - var2_1 - var4_2;
                    }
                    var4_2 = var15_8 / var0;
                    if (var2_1 != var7_4) break block4;
                    var2_1 = (var9_5 - var11_6) / var15_8;
                    var17_9 = var9_5 < var11_6 ? 6 : 0;
                    var0 = var17_9;
                    ** GOTO lbl24
                }
                if (var2_1 == var9_5) {
                    var0 = (var11_6 - var7_4) / var15_8 + 2.0;
                } else {
                    var2_1 = (var7_4 - var9_5) / var15_8;
                    var0 = 4.0;
lbl24:
                    // 2 sources

                    var0 = var2_1 + var0;
                }
                var0 /= 6.0;
                var2_1 = var4_2;
                break block5;
            }
            var0 = var2_1 = 0.0;
        }
        var6_3.set(var0, var2_1, var13_7);
        return var6_3;
    }

    public static Vec3 rgbToHsv(double d, double d2, double d3) {
        return ColorUtil.rgbToHsv(d, d2, d3, new Vec3());
    }

    public static Vec3 rgbToHsv(double d, double d2, double d3, Vec3 vec3) {
        double d4;
        block2: {
            block6: {
                block4: {
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    block5: {
                        block3: {
                            d8 = d / 255.0;
                            d7 = d2 / 255.0;
                            d6 = d3 / 255.0;
                            d4 = Math.max(d8, Math.max(d7, d6));
                            double d9 = Math.min(d8, Math.min(d7, d6));
                            d5 = d4 - d9;
                            d = 0.0;
                            d2 = d4 == 0.0 ? 0.0 : d5 / d4;
                            d3 = d;
                            if (d4 == d9) break block2;
                            if (d4 != d8) break block3;
                            d = (d7 - d6) / d5;
                            int n = d7 < d6 ? 6 : 0;
                            d3 = n;
                            break block4;
                        }
                        if (d4 != d7) break block5;
                        d = (d6 - d8) / d5 + 2.0;
                        break block6;
                    }
                    if (d4 != d6) break block6;
                    d = (d8 - d7) / d5;
                    d3 = 4.0;
                }
                d += d3;
            }
            d3 = d / 6.0;
        }
        vec3.set(d3, d2, d4);
        return vec3;
    }

    public static int saturate(int n, double d) {
        synchronized (ColorUtil.class) {
            Vec3 vec3 = TMP_VEC;
            ColorUtil.rgbToHsv(Color.r(n), Color.g(n), Color.b(n), vec3);
            n = ColorUtil.hsvToRgb(vec3.x, d, vec3.z);
            return n;
        }
    }

    public static int saturate(int n, double d, boolean bl) {
        synchronized (ColorUtil.class) {
            Vec3 vec3 = TMP_VEC;
            ColorUtil.rgbToHsv(Color.r(n), Color.g(n), Color.b(n), vec3);
            n = ColorUtil.hsvToRgb(vec3.x, FastMath.clamp(d * vec3.y, 0.0, 1.0), vec3.z);
            return n;
        }
    }

    public static int setHue(int n, double d) {
        synchronized (ColorUtil.class) {
            Vec3 vec3 = TMP_VEC;
            ColorUtil.rgbToHsv(Color.r(n), Color.g(n), Color.b(n), vec3);
            n = ColorUtil.hsvToRgb(d, vec3.y, vec3.z, null);
            return n;
        }
    }

    public static int shiftHue(int n, double d) {
        synchronized (ColorUtil.class) {
            Vec3 vec3 = TMP_VEC;
            ColorUtil.rgbToHsv(Color.r(n), Color.g(n), Color.b(n), vec3);
            vec3.x += d;
            vec3.x -= Math.floor(vec3.x);
            n = ColorUtil.hsvToRgb(FastMath.clamp(vec3.x, 0.0, 1.0), vec3.y, vec3.z, null);
            return n;
        }
    }
}

