/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.utils.FastMath;

public class Easing {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float cubicInout(float f, float f2, float f3, float f4, float f5) {
        if ((f2 /= f5 / 2.0f) < 1.0f) {
            f = f4 / 2.0f * f2 * f2 * f2;
            return f + f3;
        }
        f = f4 / 2.0f;
        f *= (f2 -= 2.0f) * f2 * f2 + 2.0f;
        return f + f3;
    }

    public static float ease(long l, long l2, float f, Type type) {
        float f2 = l2 - l;
        if (f2 > f) {
            return 1.0f;
        }
        float f3 = f2 / f;
        switch (1.$SwitchMap$org$oscim$utils$Easing$Type[type.ordinal()]) {
            default: {
                f = 0.0f;
                break;
            }
            case 7: {
                f = Easing.quintInout(f3, f2, 0.0f, 1.0f, f);
                break;
            }
            case 6: {
                f = Easing.quartInout(f3, f2, 0.0f, 1.0f, f);
                break;
            }
            case 5: {
                f = Easing.cubicInout(f3, f2, 0.0f, 1.0f, f);
                break;
            }
            case 4: {
                f = Easing.quadInout(f3, f2, 0.0f, 1.0f, f);
                break;
            }
            case 3: {
                f = Easing.expoOut(f3, f2, 0.0f, 1.0f, f);
                break;
            }
            case 2: {
                f = Easing.sineInout(f3, f2, 0.0f, 1.0f, f);
                break;
            }
            case 1: {
                f = Easing.linear(f3, f2, 0.0f, 1.0f, f);
            }
        }
        return FastMath.clamp(f, 0.0f, 1.0f);
    }

    private static float expoOut(float f, float f2, float f3, float f4, float f5) {
        f = f2 == f5 ? f3 + f4 : f3 + f4 * (float)(-Math.pow(2.0, f * -10.0f) + 1.0);
        return f;
    }

    private static float linear(float f, float f2, float f3, float f4, float f5) {
        return f4 * f + f3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float quadInout(float f, float f2, float f3, float f4, float f5) {
        if ((f2 /= f5 / 2.0f) < 1.0f) {
            f = f4 / 2.0f * f2;
            return f * f2 + f3;
        }
        f = -f4 / 2.0f;
        f2 -= 1.0f;
        f2 = f2 * (f2 - 2.0f) - 1.0f;
        return f * f2 + f3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float quartInout(float f, float f2, float f3, float f4, float f5) {
        if ((f2 /= f5 / 2.0f) < 1.0f) {
            f = f4 / 2.0f * f2 * f2 * f2 * f2;
            return f + f3;
        }
        f = -f4 / 2.0f;
        f *= (f2 -= 2.0f) * f2 * f2 * f2 - 2.0f;
        return f + f3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float quintInout(float f, float f2, float f3, float f4, float f5) {
        if ((f2 /= f5 / 2.0f) < 1.0f) {
            f = f4 / 2.0f * f2 * f2 * f2 * f2 * f2;
            return f + f3;
        }
        f = f4 / 2.0f;
        f *= (f2 -= 2.0f) * f2 * f2 * f2 * f2 + 2.0f;
        return f + f3;
    }

    private static float sineInout(float f, float f2, float f3, float f4, float f5) {
        return -f4 / 2.0f * (float)(Math.cos((double)f2 * Math.PI / (double)f5) - 1.0) + f3;
    }

    public static final class Type
    extends Enum<Type> {
        private static final /* synthetic */ Type[] $VALUES;
        public static final /* enum */ Type CUBIC_INOUT;
        public static final /* enum */ Type EXPO_OUT;
        public static final /* enum */ Type LINEAR;
        public static final /* enum */ Type QUAD_INOUT;
        public static final /* enum */ Type QUART_INOUT;
        public static final /* enum */ Type QUINT_INOUT;
        public static final /* enum */ Type SINE_INOUT;

        static {
            Type type;
            Type type2;
            Type type3;
            Type type4;
            Type type5;
            Type type6;
            Type type7;
            LINEAR = type7 = new Type();
            SINE_INOUT = type6 = new Type();
            EXPO_OUT = type5 = new Type();
            QUAD_INOUT = type4 = new Type();
            CUBIC_INOUT = type3 = new Type();
            QUART_INOUT = type2 = new Type();
            QUINT_INOUT = type = new Type();
            $VALUES = new Type[]{type7, type6, type5, type4, type3, type2, type};
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }
    }
}

