/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.core.BoundingBox;
import org.oscim.core.GeoPoint;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;

public final class GeoPointUtils {
    public static final double LATITUDE_MAX = 90.0;
    public static final double LATITUDE_MIN = -90.0;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double LONGITUDE_MIN = -180.0;

    private GeoPointUtils() {
        throw new IllegalStateException();
    }

    public static boolean contains(GeoPoint[] geoPointArray, GeoPoint geoPoint) {
        int n = geoPointArray.length - 1;
        int n2 = 0;
        boolean bl = false;
        while (n2 < geoPointArray.length) {
            boolean bl2 = geoPointArray[n2].getLatitude() > geoPoint.getLatitude();
            boolean bl3 = geoPointArray[n].getLatitude() > geoPoint.getLatitude();
            boolean bl4 = bl;
            if (bl2 != bl3) {
                bl4 = bl;
                if (geoPoint.getLongitude() < (geoPointArray[n].getLongitude() - geoPointArray[n2].getLongitude()) * (geoPoint.getLatitude() - geoPointArray[n2].getLatitude()) / (geoPointArray[n].getLatitude() - geoPointArray[n2].getLatitude()) + geoPointArray[n2].getLongitude()) {
                    bl4 = bl ^ true;
                }
            }
            n = n2++;
            bl = bl4;
        }
        return bl;
    }

    public static double distanceSegmentPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        Point point = GeoPointUtils.nearestSegmentPoint(d, d2, d3, d4, d5, d6);
        return Math.hypot(point.x - d5, point.y - d6);
    }

    public static boolean isClosedWay(GeoPoint[] geoPointArray) {
        boolean bl = false;
        if (geoPointArray[0].distance(geoPointArray[geoPointArray.length - 1]) < 1.0E-9) {
            bl = true;
        }
        return bl;
    }

    public static Point nearestSegmentPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = d7 * d7 + d8 * d8;
        if (d9 == 0.0) {
            return new Point(d, d2);
        }
        if ((d5 = ((d5 - d) * d7 + (d6 - d2) * d8) / d9) < 0.0) {
            return new Point(d, d2);
        }
        if (d5 > 1.0) {
            return new Point(d3, d4);
        }
        return new Point(d + d7 * d5, d2 + d5 * d8);
    }

    public static double scaleForBounds(BoundingBox boundingBox, int n, int n2) {
        double d = MercatorProjection.longitudeToX(boundingBox.getMinLongitude());
        double d2 = MercatorProjection.latitudeToY(boundingBox.getMaxLatitude());
        d = Math.abs(MercatorProjection.longitudeToX(boundingBox.getMaxLongitude()) - d);
        d2 = Math.abs(MercatorProjection.latitudeToY(boundingBox.getMinLatitude()) - d2);
        return Math.min((double)n / (d * (double)Tile.SIZE), (double)n2 / (d2 * (double)Tile.SIZE));
    }

    public static double validateLatitude(double d) {
        if (!(Double.isNaN(d) || d < -90.0 || d > 90.0)) {
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid latitude: ");
        stringBuilder.append(d);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static double validateLongitude(double d) {
        if (!(Double.isNaN(d) || d < -180.0 || d > 180.0)) {
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid longitude: ");
        stringBuilder.append(d);
        throw new IllegalArgumentException(stringBuilder.toString());
    }
}

