/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.Arrays;
import org.oscim.utils.pool.Inlist;

public class KeyMap<K extends HashItem>
extends Inlist<KeyMap<K>> {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final HashItem[] EMPTY_TABLE = new HashItem[2];
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MINIMUM_CAPACITY = 4;
    static final boolean STATS = false;
    int size;
    HashItem[] table;
    private int threshold;

    public KeyMap() {
        this.table = EMPTY_TABLE;
        this.threshold = -1;
    }

    public KeyMap(int n) {
        if (n >= 0) {
            if (n == 0) {
                this.table = EMPTY_TABLE;
                this.threshold = -1;
                return;
            }
            int n2 = 0x40000000;
            n = n < 4 ? 4 : (n > 0x40000000 ? n2 : KeyMap.roundUpToPowerOfTwo(n));
            this.makeTable(n);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Capacity: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public KeyMap(int n, float f) {
        this(n);
        if (!(f <= 0.0f) && !Float.isNaN(f)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Load factor: ");
        stringBuilder.append(f);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    static int capacityForInitSize(int n) {
        if ((0xC0000000 & (n = (n >> 1) + n)) != 0) {
            n = 0x40000000;
        }
        return n;
    }

    private HashItem[] doubleCapacity() {
        HashItem[] hashItemArray = this.table;
        int n = hashItemArray.length;
        if (n == 0x40000000) {
            return hashItemArray;
        }
        HashItem[] hashItemArray2 = this.makeTable(n * 2);
        if (this.size == 0) {
            return hashItemArray2;
        }
        for (int i = 0; i < n; ++i) {
            HashItem hashItem = hashItemArray[i];
            if (hashItem == null) continue;
            int n2 = hashItem.hash & n;
            hashItemArray2[i | n2] = hashItem;
            HashItem hashItem2 = (HashItem)hashItem.next;
            HashItem hashItem3 = null;
            while (hashItem2 != null) {
                int n3 = hashItem2.hash & n;
                int n4 = n2;
                HashItem hashItem4 = hashItem3;
                if (n3 != n2) {
                    if (hashItem3 == null) {
                        hashItemArray2[i | n3] = hashItem2;
                    } else {
                        hashItem3.next = hashItem2;
                    }
                    n4 = n3;
                    hashItem4 = hashItem;
                }
                hashItem3 = (HashItem)hashItem2.next;
                hashItem = hashItem2;
                hashItem2 = hashItem3;
                n2 = n4;
                hashItem3 = hashItem4;
            }
            if (hashItem3 == null) continue;
            hashItem3.next = null;
        }
        return hashItemArray2;
    }

    private HashItem[] makeTable(int n) {
        HashItem[] hashItemArray = new HashItem[n];
        this.table = hashItemArray;
        this.threshold = (n >> 1) + (n >> 2);
        return hashItemArray;
    }

    private static int roundUpToPowerOfTwo(int n) {
        --n;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n | n >>> 16) + 1;
    }

    private static int secondaryHash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n >>> 4 ^ (n >>> 7 ^ n);
    }

    void addNewEntry(K k, int n, int n2) {
        ((HashItem)k).setIndex(n, this.table[n2]);
        this.table[n2] = k;
    }

    public void clear() {
        if (this.size != 0) {
            Arrays.fill(this.table, null);
            this.size = 0;
        }
    }

    public K get(HashItem hashItem) {
        int n = hashItem.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        n ^= n >>> 7 ^ n >>> 4;
        Object object = this.table;
        object = object[((HashItem[])object).length - 1 & n];
        while (object != null) {
            if (!(object == hashItem || object.hash == n && hashItem.equals(object))) {
                object = (HashItem)object.next;
                continue;
            }
            return (K)object;
        }
        return null;
    }

    void init() {
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    void postRemove(HashItem hashItem) {
    }

    public K put(K k) {
        return this.put(k, true);
    }

    public K put(K k, boolean bl) {
        if (((HashItem)k).next == null) {
            int n = KeyMap.secondaryHash(k.hashCode());
            HashItem[] hashItemArray = this.table;
            int n2 = hashItemArray.length - 1 & n;
            HashItem hashItem = hashItemArray[n2];
            while (hashItem != null) {
                if (hashItem.hash == n && k.equals(hashItem)) {
                    if (bl) {
                        hashItemArray[n2] = Inlist.remove(hashItemArray[n2], hashItem);
                        hashItemArray[n2] = Inlist.push(hashItemArray[n2], k);
                    }
                    return (K)hashItem;
                }
                hashItem = (HashItem)hashItem.next;
            }
            int n3 = this.size;
            this.size = n3 + 1;
            if (n3 > this.threshold) {
                n2 = n & this.doubleCapacity().length - 1;
            }
            this.addNewEntry(k, n, n2);
            return null;
        }
        throw new IllegalStateException("item not unhooked");
    }

    public K releaseItems() {
        if (this.size == 0) {
            return null;
        }
        int n = this.table.length;
        HashItem hashItem = null;
        for (int i = 0; i < n; ++i) {
            HashItem[] hashItemArray = this.table;
            HashItem hashItem2 = hashItemArray[i];
            if (hashItem2 == null) continue;
            hashItemArray[i] = null;
            Inlist.last(hashItem2).next = hashItem;
            hashItem = hashItem2;
        }
        Arrays.fill(this.table, null);
        this.size = 0;
        return (K)hashItem;
    }

    public K remove(K k) {
        int n = KeyMap.secondaryHash(k.hashCode());
        HashItem[] hashItemArray = this.table;
        int n2 = hashItemArray.length - 1 & n;
        HashItem hashItem = hashItemArray[n2];
        HashItem hashItem2 = null;
        while (hashItem != null) {
            if (hashItem.hash == n && k.equals(hashItem)) {
                if (hashItem2 == null) {
                    hashItemArray[n2] = (HashItem)hashItem.next;
                } else {
                    hashItem2.next = hashItem.next;
                }
                hashItem.next = null;
                --this.size;
                return (K)hashItem;
            }
            HashItem hashItem3 = (HashItem)hashItem.next;
            hashItem2 = hashItem;
            hashItem = hashItem3;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public static class HashItem
    extends Inlist<HashItem> {
        int hash;

        public void setIndex(int n, HashItem hashItem) {
            this.hash = n;
            this.next = hashItem;
        }
    }
}

