/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final float LOAD_FACTOR = 0.6f;
    private static final long serialVersionUID = 1L;
    private final int capacity;

    public LRUCache(int n) {
        super(LRUCache.calculateInitialCapacity(n), 0.6f, true);
        this.capacity = n;
    }

    private static int calculateInitialCapacity(int n) {
        if (n >= 0) {
            return (int)((float)n / 0.6f) + 2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("capacity must not be negative: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        boolean bl = this.size() > this.capacity;
        return bl;
    }
}

