/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PausableThread
extends Thread {
    private static final boolean dbg = false;
    private static final Logger log = LoggerFactory.getLogger(PausableThread.class);
    private boolean mPausing = true;
    private boolean mRunning = true;
    private boolean mShouldPause = false;
    private boolean mShouldStop = false;

    protected void afterPause() {
    }

    protected void afterRun() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void awaitPausing() {
        synchronized (this) {
            boolean bl;
            while (!(bl = this.isPausing())) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                    continue;
                }
                break;
            }
            return;
        }
    }

    protected abstract void doWork() throws InterruptedException;

    public void finish() {
        synchronized (this) {
            block4: {
                boolean bl = this.mRunning;
                if (bl) break block4;
                return;
            }
            log.debug("Finish {}", (Object)this.getThreadName());
            this.mShouldStop = true;
            this.interrupt();
            return;
        }
    }

    protected abstract String getThreadName();

    protected int getThreadPriority() {
        return 5;
    }

    protected abstract boolean hasWork();

    public final boolean isCanceled() {
        synchronized (this) {
            boolean bl = this.mShouldPause;
            return bl;
        }
    }

    public final boolean isPausing() {
        synchronized (this) {
            boolean bl = this.mPausing;
            return bl;
        }
    }

    public final void pause() {
        synchronized (this) {
            if (!this.mShouldPause) {
                this.mShouldPause = true;
                this.interrupt();
            }
            return;
        }
    }

    public final void proceed() {
        synchronized (this) {
            if (this.mShouldPause) {
                this.mShouldPause = false;
                this.notify();
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        this.mRunning = true;
        this.setName(this.getThreadName());
        this.setPriority(this.getThreadPriority());
        block8: while (!this.mShouldStop) {
            synchronized (this) {
                if (this.mShouldStop) {
                    break;
                }
                while (true) {
                    if (this.mShouldPause || !this.hasWork()) break block13;
                    if (this.mPausing) {
                        this.mPausing = false;
                        this.afterPause();
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 8, 9] lbl15 : MonitorExitStatement: MONITOREXIT : this
                    break;
                }
                {
                    catch (Throwable var1_4) {}
                }
                {
                    throw var1_4;
                }
                {
                    block13: {
                        try {
                            this.doWork();
                        }
                        catch (InterruptedException var1_2) {}
                        continue block8;
                    }
                    try {
                        if (this.mShouldPause) {
                            this.mPausing = true;
                        }
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException var1_3) {
                        if (this.mShouldStop) ** break;
                        continue;
                        break block8;
                    }
                }
            }
        }
        PausableThread.log.debug("Done {}", (Object)this.getThreadName());
        this.mPausing = true;
        this.mRunning = false;
        this.afterRun();
    }
}

