/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.List;
import org.oscim.core.Box;
import org.oscim.utils.SpatialIndex;
import org.oscim.utils.pool.Pool;
import org.oscim.utils.quadtree.BoxTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuadTree<T>
extends BoxTree<BoxTree.BoxItem<T>, T>
implements SpatialIndex<T> {
    static final Logger log = LoggerFactory.getLogger(QuadTree.class);
    final Pool<BoxTree.BoxItem<T>> boxPool = new Pool<BoxTree.BoxItem<T>>(){

        @Override
        protected BoxTree.BoxItem<T> createItem() {
            return new BoxTree.BoxItem();
        }
    };
    final CollectCb<T> collectCb = new CollectCb();

    public QuadTree(int n, int n2) {
        super(n, n2);
    }

    private BoxTree.BoxItem<T> getBox(Box box) {
        BoxTree.BoxItem<T> boxItem = this.boxPool.get();
        boxItem.x1 = (int)box.xmin;
        boxItem.y1 = (int)box.ymin;
        boxItem.x2 = (int)box.xmax;
        boxItem.y2 = (int)box.ymax;
        return boxItem;
    }

    @Override
    public void insert(Box box, T t) {
        this.insert(new BoxTree.BoxItem<T>(box, t));
    }

    @Override
    public boolean remove(Box object, T t) {
        object = this.getBox((Box)object);
        boolean bl = this.remove(object, t);
        this.boxPool.release((BoxTree.BoxItem<Object>)object);
        return bl;
    }

    @Override
    public List<T> search(Box object, List<T> list) {
        object = this.getBox((Box)object);
        this.search((BoxTree.BoxItem<?>)object, this.collectCb, (Object)list);
        this.boxPool.release((BoxTree.BoxItem<Object>)object);
        return list;
    }

    @Override
    public boolean search(Box object, SpatialIndex.SearchCb<T> searchCb, Object object2) {
        object = this.getBox((Box)object);
        boolean bl = this.search((BoxTree.BoxItem<?>)object, searchCb, object2);
        this.boxPool.release((BoxTree.BoxItem<Object>)object);
        return bl;
    }

    static class CollectCb<T>
    implements SpatialIndex.SearchCb<T> {
        CollectCb() {
        }

        @Override
        public boolean call(T t, Object object) {
            ((List)object).add(t);
            return true;
        }
    }
}

