/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.oscim.core.Box;
import org.oscim.utils.Partition;
import org.oscim.utils.SpatialIndex;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.SyncPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTree<T>
implements SpatialIndex<T>,
Iterable<T> {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    static final boolean DEBUG = true;
    static final int MAXNODES = 8;
    static final int MAX_STACK = 32;
    static final int MINNODES = 4;
    static final int NUMDIMS = 2;
    static final Logger log = LoggerFactory.getLogger(RTree.class);
    private final Partition mLocalVars = new Partition(8, 4);
    private final ArrayList<Node> mReinsertNodes;
    protected Node mRoot;
    private Rect mTmpRect = new Rect();
    public int nodesAlloc;
    public int nodesFree;
    SyncPool<Stack> stackPool;

    public RTree() {
        Node node;
        this.mReinsertNodes = new ArrayList();
        this.stackPool = new SyncPool<Stack>(10){

            @Override
            protected boolean clearItem(Stack stack) {
                if (stack.tos != 0) {
                    stack.tos = 0;
                    Arrays.fill(stack.nodes, null);
                }
                return true;
            }

            @Override
            protected Stack createItem() {
                return new Stack();
            }
        };
        this.mRoot = node = this.allocNode();
        node.level = 0;
    }

    private void countRec(Node node, int[] nArray) {
        boolean bl = node.isLeaf();
        if (bl) {
            nArray[0] = nArray[0] + node.count;
            return;
        }
        Branch<Node>[] branchArray = node.children();
        for (int i = 0; i < node.count; ++i) {
            this.countRec((Node)branchArray[i].node, nArray);
        }
    }

    private Rect getRect() {
        Rect rect = this.mTmpRect;
        if (rect == null) {
            return new Rect();
        }
        this.mTmpRect = null;
        return rect;
    }

    private Node insertRectRec(Rect branch, T object, Node node, int n) {
        if (node.level > n) {
            int n2 = this.pickBranch(node, branch);
            Branch<Node>[] branchArray = node.children();
            if ((object = this.insertRectRec(branch, object, (Node)branchArray[n2].node, n)) != null) {
                node.branch[n2].setCover((Node)branchArray[n2].node);
                branch = new Branch();
                branch.node = object;
                branch.setCover((Node)object);
                if (node.addBranch(branch)) {
                    return this.splitNode(node, branch);
                }
                return null;
            }
            node.branch[n2].add(branch);
            return null;
        }
        Branch branch2 = new Branch();
        branch2.set(branch);
        branch2.node = object;
        if (node.addBranch(branch2)) {
            return this.splitNode(node, branch2);
        }
        return null;
    }

    static final double mergedArea(Rect rect, Rect rect2) {
        double d = rect.xmax > rect2.xmax ? rect.xmax : rect2.xmax;
        double d2 = rect.xmin < rect2.xmin ? rect.xmin : rect2.xmin;
        double d3 = rect.ymax > rect2.ymax ? rect.ymax : rect2.ymax;
        double d4 = rect.ymin < rect2.ymin ? rect.ymin : rect2.ymin;
        return d - d2 * (d3 - d4);
    }

    private void releaseRect(Rect rect) {
        this.mTmpRect = rect;
    }

    private boolean removeRectRec(Rect rect, T t, Node node, ArrayList<Node> arrayList) {
        if (node.isLeaf()) {
            for (int i = 0; i < node.count; ++i) {
                if (node.branch[i].node != t) continue;
                this.disconnectBranch(node, i);
                return true;
            }
            return false;
        }
        for (int i = 0; i < node.count; ++i) {
            if (!rect.overlap(node.branch[i])) continue;
            Branch<Node>[] branchArray = node.children();
            if (!this.removeRectRec(rect, t, (Node)branchArray[i].node, arrayList)) continue;
            if (((Node)branchArray[i].node).count >= 4) {
                branchArray[i].setCover((Node)branchArray[i].node);
            } else {
                arrayList.add((Node)branchArray[i].node);
                this.disconnectBranch(node, i);
            }
            return true;
        }
        return false;
    }

    Node allocNode() {
        ++this.nodesAlloc;
        return new Node(8);
    }

    @Override
    public void clear() {
        Node node;
        this.reset();
        this.mRoot = node = this.allocNode();
        node.level = 0;
    }

    void disconnectBranch(Node node, int n) {
        --node.count;
        if (node.count != n) {
            node.branch[n] = node.branch[node.count];
        }
        node.branch[node.count] = null;
    }

    void freeNode(Node node) {
        ++this.nodesFree;
    }

    @Override
    public void insert(Box box, T t) {
        Rect rect = this.getRect();
        rect.set(box);
        this.insertRect(rect, t, 0);
        this.releaseRect(rect);
    }

    public void insert(double[] dArray, double[] dArray2, T t) {
        Rect rect = this.getRect();
        rect.set(dArray, dArray2);
        this.insertRect(rect, t, 0);
        this.releaseRect(rect);
    }

    public boolean insertRect(Rect object, T object2, int n) {
        Object object3 = this.mRoot;
        if ((object = this.insertRectRec((Rect)object, object2, (Node)object3, n)) != null) {
            object2 = this.allocNode();
            ((Node)object2).level = ((Node)object3).level + 1;
            Branch branch = new Branch();
            branch.setCover((Node)object3);
            branch.node = object3;
            ((Node)object2).addBranch(branch);
            object3 = new Branch();
            ((Rect)object3).setCover((Node)object);
            ((Branch)object3).node = object;
            ((Node)object2).addBranch((Branch<?>)object3);
            this.mRoot = object2;
            return true;
        }
        return false;
    }

    @Override
    public java.util.Iterator<T> iterator() {
        return new Iterator(this.mRoot);
    }

    int pickBranch(Node node, Rect rect) {
        boolean bl = true;
        double d = -1.0;
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < node.count; ++i) {
            int n2;
            double d3;
            double d4;
            boolean bl2;
            Branch<?> branch = node.branch[i];
            double d5 = branch.calcRectVolume();
            double d6 = RTree.mergedArea(rect, branch) - d5;
            if (!(d6 < d) && !bl) {
                bl2 = bl;
                d4 = d;
                d3 = d2;
                n2 = n;
                if (d6 == d) {
                    bl2 = bl;
                    d4 = d;
                    d3 = d2;
                    n2 = n;
                    if (d5 < d2) {
                        n2 = i;
                        d3 = d5;
                        d4 = d6;
                        bl2 = bl;
                    }
                }
            } else {
                n2 = i;
                d3 = d5;
                d4 = d6;
                bl2 = false;
            }
            bl = bl2;
            d = d4;
            d2 = d3;
            n = n2;
        }
        return n;
    }

    public void printStats() {
        Appendable appendable = System.out;
        Appendable appendable2 = new StringBuilder();
        ((StringBuilder)appendable2).append("nodes alloc:\t");
        ((StringBuilder)appendable2).append(this.nodesAlloc);
        ((PrintStream)appendable).println(((StringBuilder)appendable2).toString());
        appendable2 = System.out;
        appendable = new StringBuilder();
        ((StringBuilder)appendable).append("nodes free:\t");
        ((StringBuilder)appendable).append(this.nodesFree);
        ((PrintStream)appendable2).println(((StringBuilder)appendable).toString());
    }

    @Override
    public boolean remove(Box box, T t) {
        Rect rect = this.getRect();
        rect.set(box);
        boolean bl = this.removeRect(rect, t);
        this.releaseRect(rect);
        return bl;
    }

    public boolean remove(double[] dArray, double[] dArray2, T t) {
        Rect rect = this.getRect();
        rect.set(dArray, dArray2);
        boolean bl = this.removeRect(rect, t);
        this.releaseRect(rect);
        return bl;
    }

    void removeAllRec(Node node) {
        if (!node.isLeaf()) {
            Branch<Node>[] branchArray = node.children();
            for (int i = 0; i < node.count; ++i) {
                this.removeAllRec((Node)branchArray[i].node);
            }
        }
        this.freeNode(node);
    }

    public boolean removeRect(Rect object3, T object2) {
        java.util.Iterator<Node> iterator2;
        Node node = this.mRoot;
        ArrayList<Node> arrayList = this.mReinsertNodes;
        if (this.removeRectRec((Rect)object3, iterator2, node, arrayList)) {
            for (Node node2 : arrayList) {
                for (int i = 0; i < node2.count; ++i) {
                    this.insertRect(node2.branch[i], node2.branch[i].node, node2.level);
                }
                this.freeNode(node2);
            }
            arrayList.clear();
            if (node.count == 1 && !node.isLeaf()) {
                Node node3 = (Node)node.children()[0].node;
                this.freeNode(node);
                this.mRoot = node3;
            }
            return true;
        }
        return false;
    }

    void reset() {
        this.removeAllRec(this.mRoot);
    }

    @Override
    public List<T> search(Box box, List<T> object) {
        List<T> list = object;
        if (object == null) {
            list = new ArrayList<T>(16);
        }
        object = this.getRect();
        ((Rect)object).set(box);
        this.searchStack((Rect)object, list);
        this.releaseRect((Rect)object);
        return list;
    }

    @Override
    public boolean search(Box box, SpatialIndex.SearchCb<T> searchCb, Object object) {
        Rect rect = this.getRect();
        rect.set(box);
        this.searchStack(rect, searchCb, object);
        this.releaseRect(rect);
        return true;
    }

    public boolean search(double[] dArray, double[] dArray2, SpatialIndex.SearchCb<T> searchCb, Object object) {
        Rect rect = this.getRect();
        rect.set(dArray, dArray2);
        this.searchStack(rect, searchCb, object);
        this.releaseRect(rect);
        return true;
    }

    public void searchStack(Rect rect, SpatialIndex.SearchCb<T> searchCb, Object object) {
        Stack stack = this.stackPool.get();
        stack.push(this.mRoot, 0);
        block0: while (!stack.empty()) {
            Object object2;
            int n;
            stack.pop();
            Node node = stack.node();
            if (node.level == 0) {
                for (n = 0; n < node.count; ++n) {
                    object2 = node.branch;
                    if (rect.overlap(object2[n]) && !searchCb.call(object2[n].node, object)) break block0;
                }
                continue;
            }
            int n2 = stack.branchIndex();
            for (n = n2 + 1; n < node.count; ++n) {
                if (!rect.overlap(node.branch[n])) continue;
                stack.push(node, n);
                break;
            }
            object2 = (Node)node.branch[n2].node;
            for (n = 0; n < object2.count; ++n) {
                if (!rect.overlap(object2.branch[n])) continue;
                stack.push((Node)object2, n);
                continue block0;
            }
        }
        this.stackPool.release(stack);
    }

    public boolean searchStack(Rect rect, List<T> list) {
        Stack stack = this.stackPool.get();
        stack.push(this.mRoot, 0);
        block0: while (!stack.empty()) {
            int n;
            stack.pop();
            Node node = stack.node();
            if (node.level == 0) {
                for (n = 0; n < node.count; ++n) {
                    if (!rect.overlap(node.branch[n])) continue;
                    list.add(node.branch[n].node);
                }
                continue;
            }
            int n2 = stack.branchIndex();
            for (n = n2 + 1; n < node.count; ++n) {
                if (!rect.overlap(node.branch[n])) continue;
                stack.push(node, n);
                break;
            }
            node = (Node)node.branch[n2].node;
            for (n = 0; n < node.count; ++n) {
                if (!rect.overlap(node.branch[n])) continue;
                stack.push(node, n);
                continue block0;
            }
        }
        this.stackPool.release(stack);
        return true;
    }

    @Override
    public int size() {
        int[] nArray = new int[]{0};
        this.countRec(this.mRoot, nArray);
        return nArray[0];
    }

    Node splitNode(Node node, Branch<?> object) {
        Partition partition = this.mLocalVars.clear();
        int n = node.level;
        partition.getBranches(node, (Branch<?>)object);
        partition.choosePartition();
        object = this.allocNode();
        node.level = n;
        ((Node)object).level = n;
        partition.loadNodes(node, (Node)object);
        for (n = node.count; n < 8; ++n) {
            node.branch[n] = null;
        }
        return object;
    }

    static final class Branch<E>
    extends Rect {
        E node;

        Branch() {
        }

        public String toString() {
            return this.node.toString();
        }
    }

    public static class Iterator<T>
    implements java.util.Iterator<T> {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        final StackElement[] stack = new StackElement[32];
        int tos;

        Iterator(Node node) {
            for (int i = 0; i < 32; ++i) {
                this.stack[i] = new StackElement();
            }
            this.push(node, 0);
            this.findNextData();
        }

        boolean findNextData() {
            while (true) {
                if (this.tos <= 0) {
                    return false;
                }
                Object object = this.pop();
                if (((StackElement)object).node.isLeaf()) {
                    if (((StackElement)object).branchIndex >= ((StackElement)object).node.count) continue;
                    this.push(((StackElement)object).node, ((StackElement)object).branchIndex);
                    return true;
                }
                int n = ((StackElement)object).branchIndex;
                int n2 = n + 1;
                if (n2 < ((StackElement)object).node.count) {
                    this.push(((StackElement)object).node, n2);
                }
                object = (Node)((StackElement)object).node.branch[n].node;
                this.push((Node)object, 0);
                if (((Node)object).isLeaf()) break;
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.isNotNull();
        }

        boolean isNotNull() {
            boolean bl = this.tos > 0;
            return bl;
        }

        boolean isNull() {
            boolean bl = this.tos <= 0;
            return bl;
        }

        @Override
        public T next() {
            StackElement stackElement = this.stack[this.tos - 1];
            Object e = stackElement.node.branch[stackElement.branchIndex].node;
            ++stackElement.branchIndex;
            this.findNextData();
            return (T)e;
        }

        StackElement pop() {
            int n;
            this.tos = n = this.tos - 1;
            return this.stack[n];
        }

        void push(Node node, int n) {
            this.stack[this.tos].node = node;
            this.stack[this.tos].branchIndex = n;
            ++this.tos;
        }

        @Override
        public void remove() {
        }
    }

    static final class Node {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        final Branch<?>[] branch;
        int count;
        int level = -1;

        public Node(int n) {
            this.branch = new Branch[n];
        }

        boolean addBranch(Branch<?> branch) {
            int n = this.count;
            if (n < 8) {
                this.branch[n] = branch;
                this.count = n + 1;
                return false;
            }
            return true;
        }

        Branch<Node>[] children() {
            if (this.level != 0) {
                return this.branch;
            }
            throw new IllegalStateException();
        }

        boolean isLeaf() {
            boolean bl = this.level == 0;
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.count);
            stringBuilder.append("/");
            stringBuilder.append(Arrays.deepToString(this.branch));
            stringBuilder.append('\n');
            return stringBuilder.toString();
        }
    }

    static class Rect {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        double xmax;
        double xmin;
        double ymax;
        double ymin;

        public Rect() {
        }

        public Rect(Box box) {
            this.xmin = box.xmin;
            this.ymin = box.ymin;
            this.xmax = box.xmax;
            this.ymax = box.ymax;
        }

        public Rect(double[] dArray, double[] dArray2) {
            for (int i = 0; i < 2; ++i) {
            }
            this.xmin = dArray[0];
            this.ymin = dArray[1];
            this.xmax = dArray2[0];
            this.ymax = dArray2[1];
        }

        public void add(Rect rect) {
            this.xmin = Math.min(this.xmin, rect.xmin);
            this.ymin = Math.min(this.ymin, rect.ymin);
            this.xmax = Math.max(this.xmax, rect.xmax);
            this.ymax = Math.max(this.ymax, rect.ymax);
        }

        public double calcRectVolume() {
            return (this.xmax - this.xmin) * (this.ymax - this.ymin);
        }

        public void combine(Rect rect, Rect rect2) {
            this.xmin = Math.min(rect.xmin, rect2.xmin);
            this.ymin = Math.min(rect.ymin, rect2.ymin);
            this.xmax = Math.max(rect.xmax, rect2.xmax);
            this.ymax = Math.max(rect.ymax, rect2.ymax);
        }

        public boolean overlap(Rect rect) {
            boolean bl = !(this.xmin > rect.xmax || this.xmax < rect.xmin || this.ymin > rect.ymax || this.ymax < rect.ymin);
            return bl;
        }

        public void set(Box box) {
            this.xmin = box.xmin;
            this.ymin = box.ymin;
            this.xmax = box.xmax;
            this.ymax = box.ymax;
        }

        public void set(Rect rect) {
            this.xmin = rect.xmin;
            this.ymin = rect.ymin;
            this.xmax = rect.xmax;
            this.ymax = rect.ymax;
        }

        public void set(double[] dArray, double[] dArray2) {
            for (int i = 0; i < 2; ++i) {
            }
            this.xmin = dArray[0];
            this.ymin = dArray[1];
            this.xmax = dArray2[0];
            this.ymax = dArray2[1];
        }

        void setCover(Node node) {
            this.set(node.branch[0]);
            for (int i = 1; i < node.count; ++i) {
                this.add(node.branch[i]);
            }
        }
    }

    static class Stack
    extends Inlist<Stack> {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        final int[] branchIndex;
        final Node[] nodes = new Node[32];
        int tos;

        Stack() {
            this.branchIndex = new int[32];
        }

        int branchIndex() {
            return this.branchIndex[this.tos];
        }

        boolean empty() {
            boolean bl = this.tos <= 0;
            return bl;
        }

        Node node() {
            return this.nodes[this.tos];
        }

        boolean pop() {
            Node[] nodeArray = this.nodes;
            int n = this.tos;
            nodeArray[n] = null;
            boolean bl = true;
            this.tos = --n;
            if (n < 0) {
                bl = false;
            }
            return bl;
        }

        @Override
        void push(Node node, int n) {
            Node[] nodeArray = this.nodes;
            int n2 = this.tos;
            nodeArray[n2] = node;
            this.branchIndex[n2] = n;
            this.tos = n2 + 1;
        }
    }

    static class StackElement {
        int branchIndex;
        Node node;

        StackElement() {
        }
    }
}

