/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.core.Tile;

public abstract class ScanBox {
    private Edge ab;
    private Edge bc;
    private Edge ca;
    private final float[] mBox = new float[8];
    protected int mZoom;
    private int xmax;
    private int xmin;

    public ScanBox() {
        this.ab = new Edge();
        this.bc = new Edge();
        this.ca = new Edge();
    }

    private void scanSpans(Edge edge, Edge edge2) {
        Edge edge3;
        Edge edge4;
        int n;
        int n2;
        int n3;
        int n4;
        block11: {
            block12: {
                block10: {
                    n4 = (int)Math.max(0.0, Math.floor(edge2.y0));
                    n3 = this.mZoom;
                    n2 = 1;
                    n = (int)Math.min((double)(1 << n3), Math.ceil(edge2.y1));
                    if (edge.x0 != edge2.x0 || edge.y0 != edge2.y0) break block10;
                    edge4 = edge;
                    edge3 = edge2;
                    if (!(edge.x0 + edge2.dy / edge.dy * edge.dx < edge2.x1)) break block11;
                    break block12;
                }
                edge4 = edge;
                edge3 = edge2;
                if (!(edge.x1 - edge2.dy / edge.dy * edge.dx < edge2.x0)) break block11;
            }
            edge3 = edge;
            edge4 = edge2;
        }
        float f = edge4.dx / edge4.dy;
        float f2 = edge3.dx / edge3.dy;
        n3 = edge4.dx > 0.0f ? 1 : 0;
        if (!(edge3.dx < 0.0f)) {
            n2 = 0;
        }
        while (n4 < n) {
            float f3;
            float f4 = f3 = (float)(n3 + n4) - edge4.y0;
            if (f3 > edge4.dy) {
                f4 = edge4.dy;
            }
            int n5 = (int)Math.ceil(edge4.x0 + f4 * f);
            f4 = f3 = (float)(n2 + n4) - edge3.y0;
            if (f3 > edge3.dy) {
                f4 = edge3.dy;
            }
            int n6 = (int)Math.floor(edge3.x0 + f4 * f2);
            int n7 = this.xmin;
            int n8 = n6;
            if (n6 < n7) {
                n8 = n7;
            }
            n7 = this.xmax;
            n6 = n5;
            if (n5 > n7) {
                n6 = n7;
            }
            if (n8 < n6) {
                this.setVisible(n4, n8, n6);
            }
            ++n4;
        }
    }

    private void scanTriangle() {
        Edge edge;
        if (this.ab.dy > this.bc.dy) {
            edge = this.ab;
            this.ab = this.bc;
            this.bc = edge;
        }
        if (this.ab.dy > this.ca.dy) {
            edge = this.ab;
            this.ab = this.ca;
            this.ca = edge;
        }
        if (this.bc.dy > this.ca.dy) {
            edge = this.bc;
            this.bc = this.ca;
            this.ca = edge;
        }
        if (this.ca.dy == 0.0f) {
            return;
        }
        if ((double)this.ab.dy > 0.0) {
            this.scanSpans(this.ca, this.ab);
        }
        if ((double)this.bc.dy > 0.0) {
            this.scanSpans(this.ca, this.bc);
        }
    }

    private float[] transScale(double d, double d2, double d3, int n, float[] fArray) {
        double d4 = (d3 *= (double)Tile.SIZE) / (double)(1 << n);
        for (n = 0; n < 8; n += 2) {
            float[] fArray2 = this.mBox;
            int n2 = n + 0;
            fArray2[n2] = (float)(((double)fArray[n2] + d * d3) / d4);
            n2 = n + 1;
            fArray2[n2] = (float)(((double)fArray[n2] + d2 * d3) / d4);
        }
        return this.mBox;
    }

    public void scan(double d, double d2, double d3, int n, float[] fArray) {
        float f;
        float f2;
        this.mZoom = n;
        fArray = this.transScale(d, d2, d3, n, fArray);
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MAX_VALUE;
        for (n = 0; n < 8; n += 2) {
            f2 = fArray[n];
            f = f3;
            if (f2 > f3) {
                f = f2;
            }
            float f5 = f4;
            if (f2 < f4) {
                f5 = f2;
            }
            f3 = f;
            f4 = f5;
        }
        f2 = (float)Math.ceil(f3);
        f = (float)Math.floor(f4);
        f4 = f2;
        if (f == f2) {
            f4 = f2 + 1.0f;
        }
        this.xmin = (int)f;
        this.xmax = (int)f4;
        this.ab.set(fArray[0], fArray[1], fArray[2], fArray[3]);
        this.bc.set(fArray[2], fArray[3], fArray[4], fArray[5]);
        this.ca.set(fArray[4], fArray[5], fArray[0], fArray[1]);
        this.scanTriangle();
        this.ab.set(fArray[0], fArray[1], fArray[4], fArray[5]);
        this.bc.set(fArray[4], fArray[5], fArray[6], fArray[7]);
        this.ca.set(fArray[6], fArray[7], fArray[0], fArray[1]);
        this.scanTriangle();
    }

    protected abstract void setVisible(int var1, int var2, int var3);

    static class Edge {
        float dx;
        float dy;
        float x0;
        float x1;
        float y0;
        float y1;

        Edge() {
        }

        void set(float f, float f2, float f3, float f4) {
            if (f2 <= f4) {
                this.x0 = f;
                this.y0 = f2;
                this.x1 = f3;
                this.y1 = f4;
            } else {
                this.x0 = f3;
                this.y0 = f4;
                this.x1 = f;
                this.y1 = f2;
            }
            this.dx = this.x1 - this.x0;
            this.dy = this.y1 - this.y0;
        }
    }
}

