/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

public class TessJNI {
    private long inst;

    public TessJNI() {
        this.inst = TessJNI.newTess(0);
    }

    public TessJNI(int n) {
        this.inst = TessJNI.newTess(n);
    }

    static native void addContour(long var0, int var2, float[] var3, int var4, int var5, int var6);

    static native void addMultiContour2D(long var0, int[] var2, float[] var3, int var4, int var5);

    static native void freeTess(long var0);

    static native int getElementCount(long var0);

    static native boolean getElements(long var0, int[] var2, int var3, int var4);

    static native void getElementsS(long var0, short[] var2, int var3, int var4);

    static native void getElementsWithInputVertexIds(long var0, short[] var2, int var3, int var4, int var5);

    static native int getVertexCount(long var0);

    static native boolean getVertexIndices(long var0, int[] var2, int var3, int var4);

    static native boolean getVertices(long var0, float[] var2, int var3, int var4);

    static native void getVerticesS(long var0, short[] var2, int var3, int var4, float var5);

    static native long newTess(int var0);

    static native int tessContour2D(long var0, int var2, int var3, int var4, int var5);

    public void addContour2D(float[] fArray) {
        this.addContour2D(fArray, 0, fArray.length >> 1);
    }

    public void addContour2D(float[] fArray, int n, int n2) {
        if (n2 < 6) {
            return;
        }
        if (n2 % 2 == 0 && n % 2 == 0 && fArray.length >> 1 >= n + n2) {
            TessJNI.addContour(this.inst, 2, fArray, 8, n, n2);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid input: length:");
        stringBuilder.append(n2);
        stringBuilder.append(", offset:");
        stringBuilder.append(n);
        stringBuilder.append(", points.length:");
        stringBuilder.append(fArray.length);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addContour2D(int[] nArray, float[] fArray) {
        TessJNI.addMultiContour2D(this.inst, nArray, fArray, 0, nArray.length);
    }

    public void addContour2D(int[] nArray, float[] fArray, int n, int n2) {
        TessJNI.addMultiContour2D(this.inst, nArray, fArray, n, n2);
    }

    public void dispose() {
        long l = this.inst;
        if (l != 0L) {
            TessJNI.freeTess(l);
            this.inst = 0L;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public int getElementCount() {
        return TessJNI.getElementCount(this.inst);
    }

    public void getElements(int[] nArray, int n, int n2) {
        TessJNI.getElements(this.inst, nArray, n, n2);
    }

    public void getElements(short[] sArray, int n, int n2) {
        TessJNI.getElementsS(this.inst, sArray, n, n2);
    }

    public void getElementsWithInputVertexIds(short[] sArray, int n, int n2, int n3) {
        TessJNI.getElementsWithInputVertexIds(this.inst, sArray, n, n2, n3);
    }

    public int getVertexCount() {
        return TessJNI.getVertexCount(this.inst);
    }

    public void getVertexIndices(int[] nArray, int n, int n2) {
        TessJNI.getVertexIndices(this.inst, nArray, n, n2);
    }

    public void getVertices(float[] fArray, int n, int n2) {
        TessJNI.getVertices(this.inst, fArray, n, n2);
    }

    public void getVertices(short[] sArray, int n, int n2, float f) {
        TessJNI.getVerticesS(this.inst, sArray, n, n2, f);
    }

    protected long instance() {
        return this.inst;
    }

    public boolean tesselate() {
        int n = TessJNI.tessContour2D(this.inst, 2, 0, 3, 2);
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean tesselate(int n, int n2) {
        n = TessJNI.tessContour2D(this.inst, n, n2, 3, 2);
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    public static final class ElementType {
        public static final int BOUNDARY_CONTOURS = 2;
        public static final int CONNECTED_POLYGONS = 1;
        public static final int POLYGONS = 0;
    }

    public static final class WindingRule {
        public static final int ABS_GEQ_TWO = 4;
        public static final int NEGATIVE = 3;
        public static final int NONZERO = 1;
        public static final int ODD = 0;
        public static final int POSITIVE = 2;
    }
}

