/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.utils.Parameters;
import org.oscim.utils.math.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
        throw new IllegalStateException();
    }

    public static boolean equals(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    public static TextureItem loadTexture(String object, String string2, int n, int n2, int n3) {
        block4: {
            if (string2 != null && string2.length() != 0) {
                object = CanvasAdapter.getBitmapAsset((String)object, string2, n, n2, n3);
                if (object == null) break block4;
                try {
                    log.debug("loading {}", (Object)string2);
                    object = new TextureItem(Utils.potBitmap((Bitmap)object), true);
                    return object;
                }
                catch (Exception exception) {
                    log.error("{}: missing file / {}", (Object)string2, (Object)exception.getMessage());
                }
            }
        }
        return null;
    }

    public static Bitmap potBitmap(Bitmap bitmap) {
        Bitmap bitmap2;
        block2: {
            int n;
            int n2;
            block3: {
                bitmap2 = bitmap;
                if (!Parameters.POT_TEXTURES) break block2;
                n2 = MathUtils.nextPowerOfTwo(bitmap.getWidth());
                n = MathUtils.nextPowerOfTwo(bitmap.getHeight());
                if (n2 != bitmap.getWidth()) break block3;
                bitmap2 = bitmap;
                if (n == bitmap.getHeight()) break block2;
            }
            log.debug("POT texture: {}x{} -> {}x{}", bitmap.getWidth(), bitmap.getHeight(), n2, n);
            bitmap2 = CanvasAdapter.newBitmap(n2, n, 0);
            Canvas canvas = CanvasAdapter.newCanvas();
            canvas.setBitmap(bitmap2);
            canvas.drawBitmapScaled(bitmap);
        }
        return bitmap2;
    }
}

