/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.async;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.oscim.utils.async.AsyncTask;
import org.oscim.utils.async.TaskQueue;

public class AsyncExecutor {
    private final ExecutorService executor;
    private final TaskQueue mainloop;

    public AsyncExecutor(int n, TaskQueue taskQueue) {
        this.mainloop = taskQueue;
        this.executor = Executors.newFixedThreadPool(n, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                runnable = new Thread(runnable, "VtmAsyncExecutor");
                ((Thread)runnable).setDaemon(true);
                ((Thread)runnable).setPriority(4);
                return runnable;
            }
        });
    }

    public void dispose() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Couldn't shutdown loading thread");
        }
    }

    public boolean post(Runnable runnable) {
        if (runnable instanceof AsyncTask) {
            ((AsyncTask)runnable).setTaskQueue(this.mainloop);
        }
        try {
            this.executor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return false;
        }
    }
}

