/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.async;

import org.oscim.map.Map;

public abstract class SimpleWorker<T>
implements Runnable {
    protected boolean mCancel;
    protected boolean mDelayed;
    protected final Map mMap;
    protected long mMinDelay;
    protected boolean mRunning;
    protected T mTaskDone;
    protected T mTaskLocked;
    protected T mTaskTodo;
    protected boolean mWait;

    public SimpleWorker(Map map, long l, T t, T t2) {
        this.mMap = map;
        this.mMinDelay = l;
        this.mTaskTodo = t;
        this.mTaskLocked = t2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancel(boolean bl) {
        synchronized (this) {
            if (this.mRunning) {
                this.mCancel = true;
                return;
            }
            T t = this.mTaskTodo;
            if (t != null) {
                this.cleanup(t);
            }
            this.finish();
            return;
        }
    }

    public abstract void cleanup(T var1);

    public abstract boolean doWork(T var1);

    public void finish() {
    }

    public boolean isRunning() {
        synchronized (this) {
            boolean bl = this.mRunning;
            return bl;
        }
    }

    public void onMainLoop(T t) {
    }

    public T poll() {
        synchronized (this) {
            T t;
            block5: {
                t = this.mTaskDone;
                if (t != null) break block5;
                return null;
            }
            this.cleanup(this.mTaskLocked);
            this.mTaskTodo = this.mTaskLocked;
            this.mTaskLocked = this.mTaskDone;
            this.mTaskDone = null;
            if (this.mWait) {
                this.submit(this.mMinDelay);
                this.mWait = false;
            }
            t = this.mTaskLocked;
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        synchronized (this) {
            T t;
            if (this.mCancel) {
                this.mCancel = false;
                this.mRunning = false;
                this.mDelayed = false;
                this.mWait = false;
                T t2 = this.mTaskTodo;
                if (t2 != null) {
                    this.cleanup(t2);
                }
                this.finish();
                return;
            }
            boolean bl = this.mDelayed;
            if (!bl && (t = this.mTaskTodo) != null) {
                // MONITOREXIT @DISABLED, blocks:[3, 11] lbl15 : MonitorExitStatement: MONITOREXIT : this
                bl = this.doWork(t);
                synchronized (this) {
                    this.mRunning = false;
                    if (this.mCancel) {
                        this.cleanup(this.mTaskTodo);
                        this.finish();
                        this.mCancel = false;
                    } else if (bl) {
                        this.mTaskDone = this.mTaskTodo;
                        this.mTaskTodo = null;
                    } else if (this.mWait) {
                        this.submit(this.mMinDelay);
                        this.mWait = false;
                    }
                    return;
                }
            }
            if (bl && (t = this.mTaskTodo) != null) {
                this.onMainLoop(t);
            }
            this.mDelayed = false;
            this.mRunning = false;
            this.submit(0L);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void submit(long l) {
        synchronized (this) {
            if (this.mRunning) {
                this.mWait = true;
                return;
            }
            this.mRunning = true;
            if (l <= 0L) {
                this.mMap.addTask(this);
                return;
            }
            if (!this.mDelayed) {
                this.mDelayed = true;
                this.mMap.postDelayed(this, l);
            }
            return;
        }
    }
}

