/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import java.util.ArrayList;
import java.util.List;
import org.oscim.core.Point;

public class BezierPath {
    public static Point bezier3(Point point, Point point2, Point point3, double d) {
        Point point4 = new Point();
        double d2 = d * d;
        double d3 = 1.0 - d;
        double d4 = d3 * d3;
        point4.x = point.x * d4 + point2.x * 2.0 * d3 * d + point3.x * d2;
        point4.y = point.y * d4 + point2.y * 2.0 * d3 * d + point3.y * d2;
        return point4;
    }

    public static Point cubicBezier(Point point, Point point2, Point point3, Point point4, double d) {
        Point point5 = new Point();
        double d2 = 1.0 - d;
        double d3 = d2 * d2 * d2;
        double d4 = d * d * d;
        double d5 = point.x;
        double d6 = 3.0 * d;
        double d7 = d6 * d2 * d2;
        double d8 = point2.x;
        d = d6 * d * d2;
        point5.x = d5 * d3 + d8 * d7 + point3.x * d + point4.x * d4;
        point5.y = d3 * point.y + d7 * point2.y + d * point3.y + d4 * point4.y;
        return point5;
    }

    public static List<Point> cubicSplineControlPoints(Point[] pointArray, float f) {
        Object object = pointArray;
        double d = f;
        if (!(d < 0.0) && !(d > 1.0)) {
            if (((Point[])object).length >= 2) {
                int n = ((Point[])object).length;
                ArrayList<Point> arrayList = new ArrayList<Point>();
                Object object2 = new Point(object[0].x * 2.0 - object[1].x, object[0].y * 2.0 - object[1].y);
                Object object3 = object[0];
                Point point = new Point();
                point.x = (object2.x + object3.x) / 2.0;
                point.y = (object2.y + object3.y) / 2.0;
                Point point2 = new Point();
                int n2 = n - 1;
                double d2 = object[n2].x;
                int n3 = n - 2;
                object = new Point(d2 * 2.0 - object[n3].x, object[n2].y * 2.0 - object[n3].y);
                Point point3 = new Point();
                d2 = object2.distance((Point)object3);
                for (n3 = 0; n3 < n; ++n3) {
                    object2 = n3 < n2 ? pointArray[n3 + 1] : object;
                    point2.x = point.x;
                    point2.y = point.y;
                    point.x = (object3.x + object2.x) / 2.0;
                    point.y = (object3.y + object2.y) / 2.0;
                    double d3 = object3.distance((Point)object2);
                    d2 /= d2 + d3;
                    point3.x = point2.x + (point.x - point2.x) * d2;
                    point3.y = point2.y + d2 * (point.y - point2.y);
                    d2 = point3.x - object3.x;
                    double d4 = point3.y - object3.y;
                    if (n3 > 0) {
                        arrayList.add(new Point(d * (object3.x - point2.x + d2) + point2.x - d2, d * (object3.y - point2.y + d4) + point2.y - d4));
                    }
                    if (n3 < n2) {
                        arrayList.add(new Point((object3.x - point.x + d2) * d + point.x - d2, d * (object3.y - point.y + d4) + point.y - d4));
                    }
                    d2 = d3;
                    object3 = object2;
                }
                return arrayList;
            }
            throw new IllegalArgumentException("number of Points must be >= 2");
        }
        throw new IllegalArgumentException("alpha must be between 0 and 1 inclusive");
    }
}

