/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;

public class GeomBuilder {
    Deque<Coordinate> cstack = new ArrayDeque<Coordinate>();
    GeometryFactory factory;
    Deque<Geometry> gstack = new ArrayDeque<Geometry>();

    public GeomBuilder() {
        this(new GeometryFactory());
    }

    public GeomBuilder(int n) {
        this.factory = new GeometryFactory(new PrecisionModel(), n);
    }

    public GeomBuilder(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    public GeomBuilder buffer(double d) {
        this.gstack.push(this.gpop(Geometry.class).buffer(d));
        return this;
    }

    public GeomBuilder collection() {
        this.gstack.push((Geometry)this.factory.createGeometryCollection(this.gpopAll(Geometry.class)));
        return this;
    }

    Coordinate cpop() {
        return this.cpop(1)[0];
    }

    Coordinate[] cpop(int n) {
        int n2 = this.cstack.size();
        if (n2 >= n) {
            Coordinate[] coordinateArray = new Coordinate[n];
            for (int i = 0; i < n; ++i) {
                coordinateArray[n - i - 1] = this.cstack.pop();
            }
            return coordinateArray;
        }
        throw new IllegalStateException(String.format("Expected %d values on coordinate stack, but found %d", n, this.cstack.size()));
    }

    Coordinate[] cpopAll() {
        if (!this.cstack.isEmpty()) {
            return this.cpop(this.cstack.size());
        }
        throw new IllegalStateException("Coordinate stack is empty");
    }

    public Geometry get() {
        return this.gpop(Geometry.class);
    }

    <T extends Geometry> T gpop(Class<T> clazz) {
        return (T)this.gpop(1, clazz)[0];
    }

    <T extends Geometry> T[] gpop(int n, Class<T> clazz) {
        if (this.gstack.size() >= n) {
            Geometry[] geometryArray = (Geometry[])Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                Geometry geometry = this.gstack.pop();
                if (clazz.isInstance(geometry)) {
                    geometryArray[n - i - 1] = (Geometry)clazz.cast(geometry);
                    continue;
                }
                throw new IllegalStateException(String.format("Expected %s on geometry stack, but found %s", clazz.getSimpleName(), geometry.getClass().getSimpleName()));
            }
            return geometryArray;
        }
        throw new IllegalStateException(String.format("Expected %d values on geometry stack, but found %d", n, this.gstack.size()));
    }

    <T extends Geometry> T[] gpopAll(Class<T> clazz) {
        if (!this.gstack.isEmpty()) {
            Iterator<Geometry> iterator2 = this.gstack.iterator();
            int n = 0;
            while (iterator2.hasNext() && clazz.isInstance(iterator2.next())) {
                ++n;
            }
            if (n != 0) {
                return this.gpop(n, clazz);
            }
            throw new IllegalArgumentException(String.format("Expected %s on geometry stack", clazz.getSimpleName()));
        }
        throw new IllegalArgumentException("Geometry stack is empty");
    }

    public GeomBuilder lineString() {
        this.gstack.push((Geometry)this.factory.createLineString(this.cpopAll()));
        return this;
    }

    public GeomBuilder multiLineString() {
        this.gstack.push((Geometry)this.factory.createMultiLineString((LineString[])this.gpopAll(LineString.class)));
        return this;
    }

    public GeomBuilder multiPoint() {
        if (!this.cstack.isEmpty()) {
            this.gstack.push((Geometry)this.factory.createMultiPoint(this.cpopAll()));
        } else {
            this.gstack.push((Geometry)this.factory.createMultiPoint((Point[])this.gpopAll(Point.class)));
        }
        return this;
    }

    public GeomBuilder multiPolygon() {
        this.gstack.push((Geometry)this.factory.createMultiPolygon((Polygon[])this.gpopAll(Polygon.class)));
        return this;
    }

    public GeomBuilder point() {
        this.gstack.push((Geometry)this.factory.createPoint(this.cpop()));
        return this;
    }

    public GeomBuilder point(double d, double d2) {
        this.cstack.push(new Coordinate(d, d2));
        return this;
    }

    public GeomBuilder points(double ... dArray) {
        if (dArray.length % 2 == 0) {
            for (int i = 0; i < dArray.length; i += 2) {
                this.point(dArray[i], dArray[i + 1]);
            }
            return this;
        }
        throw new IllegalArgumentException("Must specify even number of ordinates");
    }

    public GeomBuilder pointsz(double ... dArray) {
        if (dArray.length % 3 == 0) {
            for (int i = 0; i < dArray.length; i += 3) {
                this.pointz(dArray[i], dArray[i + 1], dArray[i + 2]);
            }
            return this;
        }
        throw new IllegalArgumentException("Must specify ordinates as triples");
    }

    public GeomBuilder pointz(double d, double d2, double d3) {
        this.cstack.push(new Coordinate(d, d2, d3));
        return this;
    }

    public GeomBuilder polygon() {
        if (this.gstack.isEmpty() || !(this.gstack.peek() instanceof LinearRing)) {
            this.ring();
        }
        LinearRing[] linearRingArray = (LinearRing[])this.gpopAll(LinearRing.class);
        LinearRing linearRing = linearRingArray[0];
        LinearRing[] linearRingArray2 = null;
        if (linearRingArray.length > 1) {
            linearRingArray2 = Arrays.copyOfRange(linearRingArray, 1, linearRingArray.length);
        }
        this.gstack.push((Geometry)this.factory.createPolygon(linearRing, linearRingArray2));
        return this;
    }

    public GeomBuilder ring() {
        Coordinate[] coordinateArray;
        Coordinate[] coordinateArray2 = coordinateArray = this.cpopAll();
        if (coordinateArray.length > 1) {
            coordinateArray2 = coordinateArray;
            if (!coordinateArray[0].equals((Object)coordinateArray[coordinateArray.length - 1])) {
                int n = coordinateArray.length + 1;
                coordinateArray2 = new Coordinate[n];
                System.arraycopy(coordinateArray, 0, coordinateArray2, 0, coordinateArray.length);
                coordinateArray2[n - 1] = new Coordinate(coordinateArray2[0]);
            }
        }
        this.gstack.push((Geometry)this.factory.createLinearRing(coordinateArray2));
        return this;
    }

    public GeometryCollection toCollection() {
        return this.collection().gpop(GeometryCollection.class);
    }

    public LineString toLineString() {
        return this.lineString().gpop(LineString.class);
    }

    public LinearRing toLinearRing() {
        return this.ring().gpop(LinearRing.class);
    }

    public MultiLineString toMultiLineString() {
        return this.multiLineString().gpop(MultiLineString.class);
    }

    public MultiPoint toMultiPoint() {
        return this.multiPoint().gpop(MultiPoint.class);
    }

    public MultiPolygon toMultiPolygon() {
        return this.multiPolygon().gpop(MultiPolygon.class);
    }

    public Point toPoint() {
        return this.point().gpop(Point.class);
    }

    public Polygon toPolygon() {
        return this.polygon().gpop(Polygon.class);
    }
}

