/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

public class OBB2D {
    private static final int AXIS_1 = 8;
    private static final int AXIS_2 = 10;
    private static final int AXIS_X = 8;
    private static final int AXIS_Y = 9;
    private static final int CORNER_0 = 0;
    private static final int CORNER_1 = 2;
    private static final int CORNER_3 = 6;
    private static final int CORNER_X = 0;
    private static final int CORNER_Y = 1;
    float originX;
    float originY;
    public final float[] vec;

    public OBB2D() {
        this.vec = new float[12];
    }

    public OBB2D(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float[] fArray = new float[12];
        this.vec = fArray;
        float f7 = f3 / 2.0f;
        float f8 = f4 / 2.0f;
        fArray[0] = f6 = f - f7;
        fArray[1] = f5 = f2 - f8;
        fArray[2] = f6;
        fArray[3] = f2 += f8;
        fArray[4] = f += f7;
        fArray[5] = f2;
        fArray[6] = f;
        fArray[7] = f5;
        fArray[8] = 0.0f;
        fArray[9] = 1.0f / f4;
        fArray[10] = 1.0f / f3;
        fArray[11] = 0.0f;
        fArray[0] = fArray[1] * fArray[9];
        fArray[1] = fArray[2] * fArray[10];
    }

    public OBB2D(float f, float f2, float f3, float f4, double d, double d2) {
        float[] fArray = new float[12];
        this.vec = fArray;
        float f5 = (float)d;
        float f6 = f5 * f3 / 2.0f;
        float f7 = (float)d2 * f3 / 2.0f;
        f3 = (float)(-d2) * f4 / 2.0f;
        float f8 = f5 * f4 / 2.0f;
        fArray[0] = f6 - f3 + f;
        fArray[1] = f7 - f8 + f2;
        f4 = -f6;
        fArray[2] = f4 - f3 + f;
        f5 = -f7;
        fArray[3] = f5 - f8 + f2;
        fArray[4] = f4 + f3 + f;
        fArray[5] = f5 + f8 + f2;
        fArray[6] = f + (f6 + f3);
        fArray[7] = f2 + (f7 + f8);
        this.computeAxes();
    }

    public OBB2D(float f, float f2, float f3, float f4, float f5, float f6) {
        float[] fArray = new float[12];
        this.vec = fArray;
        float f7 = f - f3;
        f3 = f2 - f4;
        f4 = (float)Math.sqrt(f7 * f7 + f3 * f3);
        f7 /= f4;
        float f8 = f3 / f4;
        f4 = f6 / 2.0f;
        f3 = f8 * f4;
        f4 = -f7 * f4;
        f6 = f7 * (f5 /= 2.0f);
        f8 *= f5;
        f7 = f - f6;
        fArray[0] = f7 - f3;
        f5 = f2 - f8;
        fArray[1] = f5 - f4;
        fArray[2] = (f += f6) - f3;
        fArray[3] = (f2 += f8) - f4;
        fArray[4] = f + f3;
        fArray[5] = f2 + f4;
        fArray[6] = f7 + f3;
        fArray[7] = f5 + f4;
        this.computeAxes();
    }

    private void computeAxes() {
        Vec2.sub(this.vec, 8, 2, 0);
        Vec2.sub(this.vec, 10, 6, 0);
        Vec2.normalizeSquared(this.vec, 8);
        this.originX = Vec2.dot(this.vec, 0, 8);
        Vec2.normalizeSquared(this.vec, 10);
        this.originY = Vec2.dot(this.vec, 0, 10);
    }

    private boolean overlaps1Way(OBB2D oBB2D) {
        int n = 0;
        while (true) {
            float f;
            float f2;
            if (n > 2) break;
            float[] fArray = this.vec;
            float f3 = fArray[n + 8];
            float f4 = fArray[n + 9];
            fArray = oBB2D.vec;
            float f5 = f2 = fArray[0] * f3 + fArray[1] * f4;
            for (int i = 2; i < 8; i += 2) {
                float f6;
                fArray = oBB2D.vec;
                float f7 = fArray[i] * f3 + fArray[i + 1] * f4;
                if (f7 < f2) {
                    f6 = f7;
                    f = f5;
                } else {
                    f = f5;
                    f6 = f2;
                    if (f7 > f5) {
                        f = f7;
                        f6 = f2;
                    }
                }
                f5 = f;
                f2 = f6;
            }
            if (n == 0 ? f2 > 1.0f + (f = this.originX) || f5 < f : f2 > 1.0f + (f = this.originY) || f5 < f) {
                return false;
            }
            n += 2;
        }
        return true;
    }

    public boolean overlaps(OBB2D oBB2D) {
        boolean bl = this.overlaps1Way(oBB2D) && oBB2D.overlaps1Way(this);
        return bl;
    }

    public void set(float f, float f2, float f3, float f4, float f5, float f6) {
        f3 = f - f3;
        f4 = f2 - f4;
        float f7 = (float)Math.sqrt(f3 * f3 + f4 * f4);
        float f8 = f3 / f7;
        f7 = f4 / f7;
        float f9 = f5 / 2.0f;
        f4 = f6 / 2.0f;
        f3 = f7 * f4;
        f4 = -f8 * f4;
        f5 = f8 * f9;
        float[] fArray = this.vec;
        f6 = f - f5;
        fArray[0] = f6 - f3;
        f8 = f2 - (f7 *= f9);
        fArray[1] = f8 - f4;
        fArray[2] = (f += f5) - f3;
        fArray[3] = (f2 += f7) - f4;
        fArray[4] = f + f3;
        fArray[5] = f2 + f4;
        fArray[6] = f6 + f3;
        fArray[7] = f8 + f4;
        this.computeAxes();
    }

    public void setNormalized(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = -f4;
        float f9 = f5 / 2.0f;
        float f10 = f6 / 2.0f;
        f6 = f;
        f5 = f2;
        if (f7 != 0.0f) {
            f5 = f3 * f7;
            f6 = f + (f4 * f7 + f5);
            f5 = f2 + (f7 * f8 + f5);
        }
        f = f3 * f9;
        f2 = f4 * f9;
        f4 = f8 * f10;
        float[] fArray = this.vec;
        f7 = f - f4;
        fArray[0] = f6 - f7;
        f8 = f2 - (f3 *= f10);
        fArray[1] = f5 - f8;
        fArray[2] = f7 + f6;
        fArray[3] = f8 + f5;
        fArray[4] = f6 + (f += f4);
        fArray[5] = f5 + (f2 += f3);
        fArray[6] = f6 - f;
        fArray[7] = f5 - f2;
        this.computeAxes();
    }

    public static class Vec2 {
        public static final void add(float[] fArray, int n, int n2, int n3) {
            fArray[n + 0] = fArray[n2 + 0] + fArray[n3 + 0];
            fArray[n + 1] = fArray[n2 + 1] + fArray[n3 + 1];
        }

        public static float dot(float[] fArray, int n, int n2) {
            return fArray[n] * fArray[n2] + fArray[n + 1] * fArray[n2 + 1];
        }

        public static final float length(float[] fArray, int n) {
            float f = fArray[n + 0];
            float f2 = fArray[n + 1];
            return (float)Math.sqrt(f * f + f2 * f2);
        }

        public static final float lengthSquared(float[] fArray, int n) {
            float f = fArray[n + 0];
            float f2 = fArray[n + 1];
            return f * f + f2 * f2;
        }

        public static final void mul(float[] fArray, int n, float f) {
            int n2 = n + 0;
            fArray[n2] = fArray[n2] * f;
            fArray[++n] = fArray[n] * f;
        }

        public static final void normalize(float[] fArray, int n) {
            int n2 = n + 0;
            float f = fArray[n2];
            float f2 = fArray[++n];
            double d = Math.sqrt(f * f + f2 * f2);
            fArray[n2] = (float)((double)f / d);
            fArray[n] = (float)((double)f2 / d);
        }

        public static final void normalizeSquared(float[] fArray, int n) {
            int n2 = n + 0;
            float f = fArray[n2];
            float f2 = fArray[++n];
            float f3 = f * f + f2 * f2;
            fArray[n2] = f / f3;
            fArray[n] = f2 / f3;
        }

        public static void set(float[] fArray, int n, float f, float f2) {
            fArray[n + 0] = f;
            fArray[n + 1] = f2;
        }

        public static final void sub(float[] fArray, int n, int n2, int n3) {
            fArray[n + 0] = fArray[n2 + 0] - fArray[n3 + 0];
            fArray[n + 1] = fArray[n2 + 1] - fArray[n3 + 1];
        }
    }
}

