/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.PointF;

public class PolyLabel {
    public static float PRECISION = 5.0f;
    private static final float SQRT2 = (float)Math.sqrt(2.0);

    public static PointF get(GeometryBuffer geometryBuffer) {
        Object object = PolyLabel.getCentroidCell(geometryBuffer);
        if (!Float.isNaN(((Cell)object).x) && !Float.isNaN(((Cell)object).y)) {
            float f;
            float f2;
            float f3;
            int n;
            Object object2 = geometryBuffer.index;
            int n2 = 0;
            int n3 = object2[0];
            float f4 = Float.MIN_VALUE;
            float f5 = Float.MIN_VALUE;
            float f6 = Float.MAX_VALUE;
            float f7 = Float.MAX_VALUE;
            while (n2 < n3) {
                object2 = geometryBuffer.points;
                int n4 = n2 + 1;
                n = object2[n2];
                f3 = geometryBuffer.points[n4];
                f2 = f6;
                if (n < f6) {
                    f2 = n;
                }
                f = f7;
                if (f3 < f7) {
                    f = f3;
                }
                f7 = f4;
                if (n > f4) {
                    f7 = n;
                }
                f6 = f5;
                if (f3 > f5) {
                    f6 = f3;
                }
                n2 = n4 + 1;
                f4 = f7;
                f5 = f6;
                f6 = f2;
                f7 = f;
            }
            float f8 = f4 - f6;
            f = f5 - f7;
            float f9 = Math.min(f8, f);
            n = (int)(f9 / 2.0f);
            PriorityQueue<Cell> priorityQueue = new PriorityQueue<Cell>(1, new MaxComparator());
            for (f2 = f6; f2 < f4; f2 += f9) {
                for (f3 = f7; f3 < f5; f3 += f9) {
                    priorityQueue.add(new Cell(f2 + n, f3 + n, n, geometryBuffer));
                }
            }
            Cell cell = new Cell(f6 + f8 / 2.0f, f7 + f / 2.0f, 0.0f, geometryBuffer);
            object2 = object;
            if (cell.d > ((Cell)object).d) {
                object2 = cell;
            }
            while (!priorityQueue.isEmpty()) {
                cell = (Cell)priorityQueue.remove();
                object = object2;
                if (cell.d > object2.d) {
                    object = cell;
                }
                if (cell.max - ((Cell)object).d <= PRECISION) {
                    object2 = object;
                    continue;
                }
                f7 = cell.h / 2.0f;
                priorityQueue.add(new Cell(cell.x - f7, cell.y - f7, f7, geometryBuffer));
                priorityQueue.add(new Cell(cell.x + f7, cell.y - f7, f7, geometryBuffer));
                priorityQueue.add(new Cell(cell.x - f7, cell.y + f7, f7, geometryBuffer));
                priorityQueue.add(new Cell(cell.x + f7, cell.y + f7, f7, geometryBuffer));
                object2 = object;
            }
            return new PointF(object2.x, object2.y);
        }
        return new PointF(-1.0f, -1.0f);
    }

    private static Cell getCentroidCell(GeometryBuffer geometryBuffer) {
        int[] nArray = geometryBuffer.index;
        int n = nArray[0];
        int n2 = n - 2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < n; i += 2) {
            float f4 = geometryBuffer.points[i];
            float f5 = geometryBuffer.points[i + 1];
            float f6 = geometryBuffer.points[n2];
            float f7 = geometryBuffer.points[n2 + 1];
            float f8 = f4 * f7 - f6 * f5;
            f += (f4 + f6) * f8;
            f3 += (f5 + f7) * f8;
            f2 += f8 * 3.0f;
            n2 = i;
        }
        return new Cell(f / f2, f3 / f2, 0.0f, geometryBuffer);
    }

    private static float getSegDistSq(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8;
        block7: {
            float f9;
            float f10;
            float f11;
            block6: {
                f11 = f5 - f3;
                f10 = f6 - f4;
                if (f11 != 0.0f) break block6;
                f8 = f3;
                f7 = f4;
                if (f10 == 0.0f) break block7;
            }
            if ((f9 = ((f - f3) * f11 + (f2 - f4) * f10) / (f11 * f11 + f10 * f10)) > 1.0f) {
                f8 = f5;
                f7 = f6;
            } else {
                f8 = f3;
                f7 = f4;
                if (f9 > 0.0f) {
                    f8 = f3 + f11 * f9;
                    f7 = f4 + f10 * f9;
                }
            }
        }
        return (f -= f8) * f + (f2 -= f7) * f2;
    }

    private static float pointToPolygonDist(float f, float f2, GeometryBuffer geometryBuffer) {
        int n;
        float f3 = Float.POSITIVE_INFINITY;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = geometryBuffer.index.length;
            n = 1;
            if (n3 >= n5 || geometryBuffer.index[n3] < 0) break;
            if (geometryBuffer.index[n3] != 0) {
                int n6 = geometryBuffer.index[n3];
                n5 = n6 - 2;
                for (n = 0; n < n6; n += 2) {
                    float[] fArray = geometryBuffer.points;
                    int n7 = n4 + n;
                    float f4 = fArray[n7];
                    float f5 = geometryBuffer.points[n7 + 1];
                    fArray = geometryBuffer.points;
                    float f6 = fArray[n5 += n4];
                    float f7 = geometryBuffer.points[n5 + 1];
                    n7 = f5 > f2 ? 1 : 0;
                    int n8 = f7 > f2 ? 1 : 0;
                    n5 = n2;
                    if ((n7 ^ n8) != 0) {
                        n5 = n2;
                        if (f < (f6 - f4) * (f2 - f5) / (f7 - f5) + f4) {
                            n5 = n2 ^ 1;
                        }
                    }
                    f3 = Math.min(f3, PolyLabel.getSegDistSq(f, f2, f4, f5, f6, f7));
                    n7 = n;
                    n2 = n5;
                    n5 = n7;
                }
                n4 += geometryBuffer.index[n3];
            }
            ++n3;
        }
        n2 = n2 != 0 ? n : -1;
        return (float)((double)n2 * Math.sqrt(f3));
    }

    private static class Cell {
        final float d;
        final float h;
        final float max;
        final float x;
        final float y;

        Cell(float f, float f2, float f3, GeometryBuffer geometryBuffer) {
            this.x = f;
            this.y = f2;
            this.h = f3;
            this.d = f = PolyLabel.pointToPolygonDist(f, f2, geometryBuffer);
            this.max = f + f3 * SQRT2;
        }
    }

    private static class MaxComparator
    implements Comparator<Cell> {
        private MaxComparator() {
        }

        @Override
        public int compare(Cell cell, Cell cell2) {
            return Float.compare(cell2.max, cell.max);
        }
    }
}

