/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import org.oscim.core.GeometryBuffer;
import org.oscim.utils.geom.GeometryUtils;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.Pool;

public class SimplifyVW {
    private Item[] heap;
    Pool<Item> pool = new Pool<Item>(){

        @Override
        protected Item createItem() {
            return new Item();
        }
    };
    private int size = 0;

    public SimplifyVW() {
        this.heap = new Item[100];
    }

    public static float area(float[] fArray, int n, int n2, int n3) {
        float f = GeometryUtils.area(fArray, n, n2, n3);
        double d = Math.abs(GeometryUtils.dotProduct(fArray, n, n2, n3));
        double d2 = 1.0;
        if (d < 0.5) {
            d2 = 0.1;
        } else if (d < 1.0) {
            d2 = 0.3;
        }
        return (float)((double)f * d2);
    }

    private void down(int n) {
        Item item = this.heap[n];
        while (true) {
            int n2 = n + 1 << 1;
            int n3 = n2 - 1;
            Item[] itemArray = this.heap;
            Item[] itemArray2 = itemArray[n];
            if (n3 < this.size && itemArray[n3].area < itemArray2.area) {
                itemArray2 = this.heap[n3];
            } else {
                n3 = n;
            }
            if (n2 < this.size && this.heap[n2].area < itemArray2.area) {
                itemArray2 = this.heap[n2];
                n3 = n2;
            }
            if (n3 == n) {
                return;
            }
            itemArray = this.heap;
            itemArray2.index = n;
            itemArray[n] = itemArray2;
            itemArray2 = this.heap;
            item.index = n3;
            itemArray2[n3] = item;
            n = n3;
        }
    }

    private void up(int n) {
        Item item = this.heap[n];
        while (n > 0) {
            int n2 = (n + 1 >> 1) - 1;
            Item item2 = this.heap[n2];
            if (item.area >= item2.area) break;
            item2.index = n;
            this.heap[n] = item2;
            item.index = n2;
            this.heap[n2] = item;
            n = n2;
        }
    }

    private void update(GeometryBuffer geometryBuffer, Item item) {
        this.update(item, SimplifyVW.area(geometryBuffer.points, item.prev.id, item.id, ((Item)item.next).id));
    }

    public Item pop() {
        int n = this.size;
        if (n == 0) {
            return null;
        }
        Item[] itemArray = this.heap;
        Item item = itemArray[0];
        this.size = --n;
        Item item2 = itemArray[n];
        itemArray[n] = null;
        if (n > 0) {
            item2.index = 0;
            itemArray[0] = item2;
            this.down(0);
        }
        return item;
    }

    public Item push(int n, float f) {
        Item item = this.pool.get();
        Item[] itemArray = this.heap;
        int n2 = this.size;
        itemArray[n2] = item;
        item.index = n2;
        item.area = f;
        item.id = n;
        n = this.size;
        this.size = n + 1;
        this.up(n);
        return item;
    }

    public void push(Item item) {
        Item[] itemArray = this.heap;
        int n = this.size;
        itemArray[n] = item;
        item.index = n;
        n = this.size;
        this.size = n + 1;
        this.up(n);
    }

    public int remove(Item item) {
        if (this.size != 0) {
            int n;
            int n2 = item.index;
            Item[] itemArray = this.heap;
            this.size = n = this.size - 1;
            Item item2 = itemArray[n];
            itemArray[n] = null;
            if (n2 == n) {
                return n2;
            }
            item2.index = n2;
            this.heap[n2] = item2;
            if (item2.area < item.area) {
                this.up(n2);
            } else {
                this.down(n2);
            }
            return n2;
        }
        throw new IllegalStateException("size == 0");
    }

    public void simplify(GeometryBuffer object, float f) {
        Object object2;
        this.size = 0;
        if (this.heap.length < ((GeometryBuffer)object).pointNextPos >> 1) {
            this.heap = new Item[((GeometryBuffer)object).pointNextPos >> 1];
        }
        Item item = this.push(0, Float.MAX_VALUE);
        Object object3 = item;
        int n = 2;
        while (n < ((GeometryBuffer)object).pointNextPos - 2) {
            object2 = ((GeometryBuffer)object).points;
            int n2 = n + 2;
            object2 = this.push(n, SimplifyVW.area(object2, n - 2, n, n2));
            ((Item)object3).next = object2;
            object2.prev = object3;
            object3 = object2;
            n = n2;
        }
        object2 = this.push(((GeometryBuffer)object).pointNextPos - 2, Float.MAX_VALUE);
        object2.prev = object3;
        ((Item)object3).next = object2;
        object2.next = item;
        item.prev = object2;
        while ((object3 = this.pop()) != null && !(((Item)object3).area > f) && ((Item)object3).prev != ((Item)object3).next) {
            ((Item)object3).prev.next = ((Item)object3).next;
            ((Item)((Item)object3).next).prev = ((Item)object3).prev;
            if (((Item)object3).prev != item) {
                this.update((GeometryBuffer)object, ((Item)object3).prev);
            }
            if (((Item)object3).next != item) {
                this.update((GeometryBuffer)object, (Item)((Item)object3).next);
            }
            object3 = this.pool.release((Item)object3);
        }
        item.prev.next = null;
        item.prev = null;
        object2 = new float[((GeometryBuffer)object).pointNextPos];
        System.arraycopy(((GeometryBuffer)object).points, 0, object2, 0, ((GeometryBuffer)object).pointNextPos);
        ((GeometryBuffer)object).clear();
        ((GeometryBuffer)object).startPolygon();
        object3 = item;
        while (object3 != null) {
            ((GeometryBuffer)object).addPoint(object2[((Item)object3).id], object2[((Item)object3).id + 1]);
            object3 = (Item)((Item)object3).next;
        }
        object = this.pool.release(item);
    }

    public void update(Item item, float f) {
        if (f < item.area) {
            item.area = f;
            this.up(item.index);
        } else {
            item.area = f;
            this.down(item.index);
        }
    }

    class Item
    extends Inlist<Item> {
        float area;
        int id;
        int index;
        Item prev;

        Item() {
        }
    }
}

