/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import org.oscim.core.GeometryBuffer;
import org.oscim.utils.geom.LineClipper;

public class TileClipper {
    private final GeometryBuffer mGeomOut = new GeometryBuffer(10, 1);
    private final LineClipper mLineClipper;
    private float xmax;
    private float xmin;
    private float ymax;
    private float ymin;

    public TileClipper(float f, float f2, float f3, float f4) {
        this.xmin = f;
        this.ymin = f2;
        this.xmax = f3;
        this.ymax = f4;
        this.mLineClipper = new LineClipper(f, f2, f3, f4);
    }

    private boolean clipEdge(GeometryBuffer geometryBuffer, GeometryBuffer geometryBuffer2, int n) {
        int n2;
        geometryBuffer2.startPolygon();
        int n3 = geometryBuffer.index.length;
        boolean bl = true;
        int n4 = 0;
        for (int i = 0; i < n3 && (n2 = geometryBuffer.index[i]) >= 0; ++i) {
            if (n2 == 0) {
                geometryBuffer2.startPolygon();
                bl = true;
                continue;
            }
            if (n2 < 6) {
                n4 += n2;
                continue;
            }
            if (!bl) {
                geometryBuffer2.startHole();
            }
            if (n != 1) {
                if (n != 2) {
                    if (n != 4) {
                        if (n == 8) {
                            this.clipRingTop(i, n4, geometryBuffer, geometryBuffer2);
                        }
                    } else {
                        this.clipRingBottom(i, n4, geometryBuffer, geometryBuffer2);
                    }
                } else {
                    this.clipRingRight(i, n4, geometryBuffer, geometryBuffer2);
                }
            } else {
                this.clipRingLeft(i, n4, geometryBuffer, geometryBuffer2);
            }
            n4 += n2;
            bl = false;
        }
        return true;
    }

    private void clipRingBottom(int n, int n2, GeometryBuffer geometryBuffer, GeometryBuffer geometryBuffer2) {
        n = geometryBuffer.index[n] + n2;
        float f = geometryBuffer.points[n - 2];
        float f2 = geometryBuffer.points[n - 1];
        while (n2 < n) {
            float[] fArray = geometryBuffer.points;
            int n3 = n2 + 1;
            float f3 = fArray[n2];
            float f4 = geometryBuffer.points[n3];
            float f5 = this.ymin;
            if (f4 > f5) {
                if (f2 > f5) {
                    geometryBuffer2.addPoint(f3, f4);
                } else {
                    geometryBuffer2.addPoint(f + (f3 - f) * (f5 - f2) / (f4 - f2), f5);
                    geometryBuffer2.addPoint(f3, f4);
                }
            } else if (f2 > f5) {
                geometryBuffer2.addPoint(f + (f3 - f) * (f5 - f2) / (f4 - f2), f5);
            }
            f = f3;
            f2 = f4;
            n2 = n3 + 1;
        }
    }

    private void clipRingLeft(int n, int n2, GeometryBuffer geometryBuffer, GeometryBuffer geometryBuffer2) {
        n = geometryBuffer.index[n] + n2;
        float f = geometryBuffer.points[n - 2];
        float f2 = geometryBuffer.points[n - 1];
        while (n2 < n) {
            float[] fArray = geometryBuffer.points;
            int n3 = n2 + 1;
            float f3 = fArray[n2];
            float f4 = geometryBuffer.points[n3];
            float f5 = this.xmin;
            if (f3 > f5) {
                if (f > f5) {
                    geometryBuffer2.addPoint(f3, f4);
                } else {
                    geometryBuffer2.addPoint(f5, f2 + (f4 - f2) * (f5 - f) / (f3 - f));
                    geometryBuffer2.addPoint(f3, f4);
                }
            } else if (f > f5) {
                geometryBuffer2.addPoint(f5, f2 + (f4 - f2) * (f5 - f) / (f3 - f));
            }
            f = f3;
            f2 = f4;
            n2 = n3 + 1;
        }
    }

    private void clipRingRight(int n, int n2, GeometryBuffer geometryBuffer, GeometryBuffer geometryBuffer2) {
        n = geometryBuffer.index[n] + n2;
        float f = geometryBuffer.points[n - 2];
        float f2 = geometryBuffer.points[n - 1];
        while (n2 < n) {
            float[] fArray = geometryBuffer.points;
            int n3 = n2 + 1;
            float f3 = fArray[n2];
            float f4 = geometryBuffer.points[n3];
            float f5 = this.xmax;
            if (f3 < f5) {
                if (f < f5) {
                    geometryBuffer2.addPoint(f3, f4);
                } else {
                    geometryBuffer2.addPoint(f5, f2 + (f4 - f2) * (f5 - f) / (f3 - f));
                    geometryBuffer2.addPoint(f3, f4);
                }
            } else if (f < f5) {
                geometryBuffer2.addPoint(f5, f2 + (f4 - f2) * (f5 - f) / (f3 - f));
            }
            f = f3;
            f2 = f4;
            n2 = n3 + 1;
        }
    }

    private void clipRingTop(int n, int n2, GeometryBuffer geometryBuffer, GeometryBuffer geometryBuffer2) {
        n = geometryBuffer.index[n] + n2;
        float f = geometryBuffer.points[n - 2];
        float f2 = geometryBuffer.points[n - 1];
        while (n2 < n) {
            float[] fArray = geometryBuffer.points;
            int n3 = n2 + 1;
            float f3 = fArray[n2];
            float f4 = geometryBuffer.points[n3];
            float f5 = this.ymax;
            if (f4 < f5) {
                if (f2 < f5) {
                    geometryBuffer2.addPoint(f3, f4);
                } else {
                    geometryBuffer2.addPoint(f + (f3 - f) * (f5 - f2) / (f4 - f2), f5);
                    geometryBuffer2.addPoint(f3, f4);
                }
            } else if (f2 < f5) {
                geometryBuffer2.addPoint(f + (f3 - f) * (f5 - f2) / (f4 - f2), f5);
            }
            f = f3;
            f2 = f4;
            n2 = n3 + 1;
        }
    }

    public boolean clip(GeometryBuffer geometryBuffer) {
        if (geometryBuffer.isPoly()) {
            GeometryBuffer geometryBuffer2 = this.mGeomOut;
            geometryBuffer2.clear();
            this.clipEdge(geometryBuffer, geometryBuffer2, 1);
            geometryBuffer.clear();
            this.clipEdge(geometryBuffer2, geometryBuffer, 8);
            geometryBuffer2.clear();
            this.clipEdge(geometryBuffer, geometryBuffer2, 2);
            geometryBuffer.clear();
            this.clipEdge(geometryBuffer2, geometryBuffer, 4);
            if (geometryBuffer.indexCurrentPos == 0 && geometryBuffer.index[0] < 6) {
                return false;
            }
        } else if (geometryBuffer.isLine()) {
            GeometryBuffer geometryBuffer3 = this.mGeomOut;
            geometryBuffer3.clear();
            int n = this.mLineClipper.clipLine(geometryBuffer, geometryBuffer3);
            Object[] objectArray = geometryBuffer.ensureIndexSize(n + 1, false);
            System.arraycopy(geometryBuffer3.index, 0, objectArray, 0, n);
            geometryBuffer.index[n] = -1;
            objectArray = geometryBuffer.ensurePointSize(geometryBuffer3.pointNextPos >> 1, false);
            System.arraycopy(geometryBuffer3.points, 0, objectArray, 0, geometryBuffer3.pointNextPos);
            geometryBuffer.indexCurrentPos = geometryBuffer3.indexCurrentPos;
            geometryBuffer.pointNextPos = geometryBuffer3.pointNextPos;
            if (geometryBuffer.indexCurrentPos == 0 && geometryBuffer.index[0] < 4) {
                return false;
            }
        }
        return true;
    }

    public void setRect(float f, float f2, float f3, float f4) {
        this.xmin = f;
        this.ymin = f2;
        this.xmax = f3;
        this.ymax = f4;
        this.mLineClipper.setRect(f, f2, f3, f4);
    }
}

