/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.math;

import java.util.Random;

public class MathUtils {
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_COUNT = 16384;
    static final int ATAN2_DIM;
    private static final int ATAN2_MASK = 16383;
    private static final double BIG_ENOUGH_CEIL;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_ROUND = 16384.5;
    private static final double CEIL = 0.9999999;
    private static final float INV_ATAN2_DIM_MINUS_1;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    private static final int SIN_BITS = 13;
    private static final int SIN_COUNT = 8192;
    private static final int SIN_MASK = 8191;
    private static final float degFull = 360.0f;
    public static final float degRad = (float)Math.PI / 180;
    private static final float degToIndex = 22.755556f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float nanoToSec = 1.0E-9f;
    public static final float radDeg = 57.295776f;
    private static final float radFull = (float)Math.PI * 2;
    private static final float radToIndex = 1303.7972f;
    public static final float radiansToDegrees = 57.295776f;
    public static Random random;

    static {
        int n;
        ATAN2_DIM = n = (int)Math.sqrt(16384.0);
        INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(n - 1);
        random = new Random();
        BIG_ENOUGH_CEIL = Double.longBitsToDouble(Double.doubleToLongBits(16385.0) - 1L);
    }

    public static final float atan2(float f, float f2) {
        float f3;
        float f4 = -1.0f;
        float f5 = 0.0f;
        if (f2 < 0.0f) {
            f3 = f;
            if (f < 0.0f) {
                f3 = -f;
                f4 = 1.0f;
            }
            f2 = -f2;
            f5 = (float)(-Math.PI);
            f = f3;
        } else if (f < 0.0f) {
            f = -f;
        } else {
            f4 = 1.0f;
        }
        f3 = f2 < f ? f : f2;
        f3 = 1.0f / (f3 * INV_ATAN2_DIM_MINUS_1);
        int n = (int)(f2 * f3);
        int n2 = (int)(f * f3);
        return (Atan2.table[n2 * ATAN2_DIM + n] + f5) * f4;
    }

    public static int ceil(float f) {
        return (int)((double)f + BIG_ENOUGH_CEIL) - 16384;
    }

    public static int ceilPositive(float f) {
        return (int)((double)f + 0.9999999);
    }

    public static float clamp(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    public static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static short clamp(short s, short s2, short s3) {
        if (s < s2) {
            return s2;
        }
        if (s > s3) {
            return s3;
        }
        return s;
    }

    public static final float cos(float f) {
        return Cos.table[(int)(f * 1303.7972f) & 0x1FFF];
    }

    public static final float cosDeg(float f) {
        return Cos.table[(int)(f * 22.755556f) & 0x1FFF];
    }

    public static int floor(float f) {
        return (int)((double)f + 16384.0) - 16384;
    }

    public static int floorPositive(float f) {
        return (int)f;
    }

    public static boolean isPowerOfTwo(int n) {
        boolean bl = n != 0 && (n & n - 1) == 0;
        return bl;
    }

    public static int nextPowerOfTwo(int n) {
        if (n == 0) {
            return 1;
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        return (n | n >> 16) + 1;
    }

    public static final float random() {
        return random.nextFloat();
    }

    public static final float random(float f) {
        return random.nextFloat() * f;
    }

    public static final float random(float f, float f2) {
        return f + random.nextFloat() * (f2 - f);
    }

    public static final int random(int n) {
        return random.nextInt(n + 1);
    }

    public static final int random(int n, int n2) {
        return n + random.nextInt(n2 - n + 1);
    }

    public static final boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static int round(float f) {
        return (int)((double)f + 16384.5) - 16384;
    }

    public static float round2(float f) {
        return (float)Math.round(f * 100.0f) / 100.0f;
    }

    public static int roundPositive(float f) {
        return (int)(f + 0.5f);
    }

    public static final float sin(float f) {
        return Sin.table[(int)(f * 1303.7972f) & 0x1FFF];
    }

    public static final float sinDeg(float f) {
        return Sin.table[(int)(f * 22.755556f) & 0x1FFF];
    }

    private static class Atan2 {
        static final float[] table = new float[16384];

        static {
            for (int i = 0; i < ATAN2_DIM; ++i) {
                for (int j = 0; j < ATAN2_DIM; ++j) {
                    float f = (float)i / (float)ATAN2_DIM;
                    float f2 = (float)j / (float)ATAN2_DIM;
                    Atan2.table[MathUtils.ATAN2_DIM * j + i] = (float)Math.atan2(f2, f);
                }
            }
        }

        private Atan2() {
        }
    }

    private static class Cos {
        static final float[] table = new float[8192];

        static {
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n2 >= 8192) break;
                Cos.table[n2] = (float)Math.cos(((float)n2 + 0.5f) / 8192.0f * ((float)Math.PI * 2));
                ++n2;
            }
            for (int i = n; i < 360; i += 90) {
                float[] fArray = table;
                float f = i;
                fArray[(int)(22.755556f * f) & 0x1FFF] = (float)Math.cos(f * ((float)Math.PI / 180));
            }
        }

        private Cos() {
        }
    }

    private static class Sin {
        static final float[] table = new float[8192];

        static {
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n2 >= 8192) break;
                Sin.table[n2] = (float)Math.sin(((float)n2 + 0.5f) / 8192.0f * ((float)Math.PI * 2));
                ++n2;
            }
            for (int i = n; i < 360; i += 90) {
                float[] fArray = table;
                float f = i;
                fArray[(int)(22.755556f * f) & 0x1FFF] = (float)Math.sin(f * ((float)Math.PI / 180));
            }
        }

        private Sin() {
        }
    }
}

