/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.pool;

import java.util.Iterator;
import javax.annotation.CheckReturnValue;

public class Inlist<T extends Inlist<T>> {
    public T next;

    @CheckReturnValue
    public static <T extends Inlist<?>> T appendItem(T t, T t2) {
        if (t2.next == null) {
            T t3;
            if (t == null) {
                return t2;
            }
            T t4 = t;
            while ((t3 = t4.next) != null) {
                t4 = t3;
            }
            t4.next = t2;
            return t;
        }
        throw new IllegalArgumentException("'item' is list");
    }

    @CheckReturnValue
    public static <T extends Inlist> T appendList(T t, T t2) {
        if (t == null) {
            return t2;
        }
        if (t2 == null) {
            return t;
        }
        T t3 = t;
        while (true) {
            T t4;
            if ((t4 = t3.next) == null) {
                t3.next = t2;
                return t;
            }
            t3 = t4;
        }
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T get(T t, int n) {
        int n2 = n;
        if (n < 0) {
            return null;
        }
        while (--n2 > 0 && t != null) {
            t = t.next;
        }
        if (n2 == 0) {
            return t;
        }
        return null;
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T last(T t) {
        while (t != null) {
            T t2 = t.next;
            if (t2 == null) {
                return t;
            }
            t = t2;
        }
        return null;
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T prependRelative(T t, T t2, T t3) {
        if (t2.next == null) {
            if (t != null) {
                T t4;
                if (t == t3) {
                    t2.next = t;
                    return t2;
                }
                T t5 = t;
                while (t5 != null && (t4 = t5.next) != t3) {
                    t5 = t4;
                }
                if (t5 != null) {
                    t2.next = t5.next;
                    t5.next = t2;
                    return t;
                }
                throw new IllegalArgumentException("'other' not in 'list'");
            }
            throw new IllegalArgumentException("'list' is null");
        }
        throw new IllegalArgumentException("'item' is list");
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T push(T t, T t2) {
        if (t2.next == null) {
            t2.next = t;
            return t2;
        }
        throw new IllegalArgumentException("'item' is a list");
    }

    @CheckReturnValue
    public static <T extends Inlist<?>> T remove(T t, T t2) {
        if (t2 == t) {
            t = t2.next;
            t2.next = null;
            return t;
        }
        T t3 = t.next;
        T t4 = t;
        while (t3 != null) {
            if (t3 == t2) {
                t4.next = t2.next;
                t2.next = null;
                return t;
            }
            T t5 = ((Inlist)t3).next;
            t4 = t3;
            t3 = t5;
        }
        return t;
    }

    public static <T extends Inlist<?>> int size(T t) {
        int n = 0;
        while (t != null) {
            ++n;
            t = t.next;
        }
        return n;
    }

    public T next() {
        return this.next;
    }

    public static class List<T extends Inlist<?>>
    implements Iterable<T>,
    Iterator<T> {
        private Inlist cur;
        private Inlist head;

        public void append(T t) {
            this.head = Inlist.appendItem(this.head, t);
        }

        public void appendList(T t) {
            this.head = Inlist.appendList(this.head, t);
        }

        public T clear() {
            Inlist inlist = this.head;
            this.head = null;
            this.cur = null;
            return (T)inlist;
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.cur != null;
            return bl;
        }

        public T head() {
            return (T)this.head;
        }

        @Override
        public Iterator<T> iterator() {
            this.cur = this.head;
            return this;
        }

        @Override
        public T next() {
            Inlist inlist = this.cur;
            if (inlist != null) {
                this.cur = inlist.next;
                return (T)inlist;
            }
            throw new IllegalStateException();
        }

        public T pop() {
            Inlist inlist = this.head;
            if (inlist == null) {
                return null;
            }
            this.head = inlist.next;
            inlist.next = null;
            return (T)inlist;
        }

        public void push(T t) {
            if (((Inlist)t).next == null) {
                ((Inlist)t).next = this.head;
                this.head = t;
                return;
            }
            throw new IllegalArgumentException("item.next must be null");
        }

        @Override
        public void remove() {
            Inlist inlist;
            Object t;
            if (this.head.next == this.cur) {
                this.head = this.head.next;
                return;
            }
            Inlist inlist2 = this.head;
            while ((t = ((Inlist)inlist2.next).next) != (inlist = this.cur)) {
                inlist2 = inlist2.next;
            }
            inlist2.next = inlist;
        }

        public void remove(T t) {
            this.cur = null;
            this.head = Inlist.remove(this.head, t);
        }

        public void reverse() {
            Inlist inlist = this.head;
            this.head = null;
            while (inlist != null) {
                Object t = inlist.next;
                inlist.next = this.head;
                this.head = inlist;
                inlist = t;
            }
        }

        public int size() {
            return Inlist.size(this.head);
        }
    }
}

