/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.pool;

import javax.annotation.CheckReturnValue;
import org.oscim.utils.pool.Inlist;

public abstract class Pool<T extends Inlist<?>> {
    protected int mFill;
    protected int mLimit;
    protected T mPool;

    protected boolean clearItem(T t) {
        return true;
    }

    protected abstract T createItem();

    public T get() {
        T t = this.mPool;
        if (t == null) {
            return this.createItem();
        }
        this.mPool = ((Inlist)t).next;
        ((Inlist)t).next = null;
        return t;
    }

    @CheckReturnValue
    public T release(T t) {
        if (t == null) {
            return null;
        }
        if (!this.clearItem(t)) {
            return null;
        }
        ((Inlist)t).next = this.mPool;
        this.mPool = t;
        return null;
    }

    public T release(T t, T t2) {
        if (t2 == null) {
            return t;
        }
        this.clearItem(t2);
        return Inlist.remove(t, t2);
    }

    @CheckReturnValue
    public T releaseAll(T t) {
        T t2 = t;
        if (t == null) {
            return null;
        }
        while (t2 != null) {
            t = ((Inlist)t2).next;
            this.clearItem(t2);
            ((Inlist)t2).next = this.mPool;
            this.mPool = t2;
            t2 = t;
        }
        return null;
    }
}

