/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.pool;

import javax.annotation.CheckReturnValue;
import org.oscim.utils.pool.Inlist;

public abstract class SyncPool<T extends Inlist<?>> {
    protected final boolean mClearItems;
    protected int mFill;
    protected final int mMaxFill;
    protected T mPool;

    public SyncPool(int n) {
        this(n, true);
    }

    public SyncPool(int n, boolean bl) {
        this.mMaxFill = n;
        this.mFill = 0;
        this.mClearItems = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        synchronized (this) {
            T t;
            while ((t = this.mPool) != null) {
                this.freeItem(t);
                this.mPool = ((Inlist)this.mPool).next;
            }
            return;
        }
    }

    protected boolean clearItem(T t) {
        return true;
    }

    protected abstract T createItem();

    protected void freeItem(T t) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T get() {
        synchronized (this) {
            T t = this.mPool;
            if (t == null) {
                t = this.createItem();
                return t;
            }
            --this.mFill;
            this.mPool = ((Inlist)t).next;
            ((Inlist)t).next = null;
            return t;
        }
    }

    public int getFill() {
        return this.mFill;
    }

    public void init(int n) {
        this.mFill = 0;
        this.mPool = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    public T release(T t) {
        if (t == null) {
            return null;
        }
        if (this.mClearItems && !this.clearItem(t)) {
            this.freeItem(t);
            return null;
        }
        if (this.mFill < this.mMaxFill) {
            synchronized (this) {
                ++this.mFill;
                ((Inlist)t).next = this.mPool;
                this.mPool = t;
                return null;
            }
        }
        if (!this.mClearItems) return null;
        this.freeItem(t);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    public T releaseAll(T t) {
        if (t == null) {
            return null;
        }
        if (this.mFill > this.mMaxFill) {
            while (true) {
                if (t == null) {
                    return null;
                }
                if (this.mClearItems) {
                    this.clearItem(t);
                    this.freeItem(t);
                }
                t = ((Inlist)t).next;
            }
        }
        synchronized (this) {
            while (t != null) {
                Object t2 = ((Inlist)t).next;
                if (this.mClearItems && !this.clearItem(t)) {
                    this.freeItem(t);
                } else {
                    ++this.mFill;
                    ((Inlist)t).next = this.mPool;
                    this.mPool = t;
                }
                t = t2;
            }
            return null;
        }
    }
}

