/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.quadtree;

import java.util.Arrays;
import org.oscim.core.Box;
import org.oscim.utils.SpatialIndex;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.Pool;
import org.oscim.utils.quadtree.TileIndex;
import org.oscim.utils.quadtree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxTree<T extends BoxItem<E>, E>
extends TileIndex<BoxNode<T>, T> {
    private static final int MAX_STACK = 32;
    static boolean dbg;
    static final Logger log;
    protected final int extents;
    protected final int maxDepth;
    Pool<Stack<BoxNode<T>>> stackPool = new Pool<Stack<BoxNode<T>>>(){

        @Override
        protected boolean clearItem(Stack<BoxNode<T>> stack) {
            if (stack.tos != 0) {
                stack.tos = 0;
                Arrays.fill(stack.nodes, null);
            }
            return true;
        }

        @Override
        protected Stack<BoxNode<T>> createItem() {
            return new Stack();
        }
    };

    static {
        log = LoggerFactory.getLogger(BoxTree.class);
        dbg = false;
    }

    public BoxTree(int n, int n2) {
        if (this.isPowerOfTwo(n)) {
            int n3;
            BoxNode boxNode = (BoxNode)this.root;
            boxNode.x1 = n3 = -n;
            ((BoxNode)this.root).y1 = n3;
            ((BoxNode)this.root).x2 = n;
            ((BoxNode)this.root).y2 = n;
            this.extents = n;
            this.maxDepth = n2;
            return;
        }
        throw new IllegalArgumentException("Extents must be power of two!");
    }

    private static boolean overlaps(BoxNode<?> boxNode, BoxItem<?> boxItem) {
        boolean bl = boxNode != null && boxNode.x1 <= boxItem.x2 && boxItem.x1 <= boxNode.x2 && boxNode.y1 <= boxItem.y2 && boxItem.y1 <= boxNode.y2;
        return bl;
    }

    public void clear() {
        ((BoxNode)this.root).child00 = null;
        ((BoxNode)this.root).child01 = null;
        ((BoxNode)this.root).child10 = null;
        ((BoxNode)this.root).child11 = null;
        ((BoxNode)this.root).item = null;
        ((BoxNode)this.root).refs = 0;
    }

    public void clearToPool() {
        BoxNode boxNode = (BoxNode)this.root;
        while (true) {
            if (boxNode.child00 != null) {
                boxNode = (BoxNode)boxNode.child00;
                continue;
            }
            if (boxNode.child01 != null) {
                boxNode = (BoxNode)boxNode.child01;
                continue;
            }
            if (boxNode.child10 != null) {
                boxNode = (BoxNode)boxNode.child10;
                continue;
            }
            if (boxNode.child11 != null) {
                boxNode = (BoxNode)boxNode.child11;
                continue;
            }
            if (boxNode == this.root) {
                ((BoxNode)this.root).child00 = null;
                ((BoxNode)this.root).child01 = null;
                ((BoxNode)this.root).child10 = null;
                ((BoxNode)this.root).child11 = null;
                ((BoxNode)this.root).item = null;
                ((BoxNode)this.root).refs = 0;
                return;
            }
            BoxNode boxNode2 = (BoxNode)boxNode.parent;
            int n = boxNode.id;
            if (n != 0) {
                if (n != 1) {
                    if (n != 2) {
                        if (n == 3) {
                            boxNode2.child11 = null;
                        }
                    } else {
                        boxNode2.child10 = null;
                    }
                } else {
                    boxNode2.child01 = null;
                }
            } else {
                boxNode2.child00 = null;
            }
            boxNode.item = null;
            boxNode.refs = 0;
            boxNode.parent = this.pool;
            this.pool = boxNode;
            boxNode = boxNode2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void collect(SearchNodeCb<BoxNode<T>> var1_1) {
        var2_2 = this.stackPool.get();
        var2_2.push((BoxNode<T>)this.root);
        while (!var2_2.empty()) {
            block10: {
                block9: {
                    var3_3 = var2_2.pop();
                    var1_1.call(var3_3);
                    var4_4 = (BoxNode)var3_3.parent;
                    var5_5 = var3_3.id;
                    if (var5_5 == 0) break block9;
                    if (var5_5 == 1) ** GOTO lbl-1000
                    if (var5_5 == 2) ** GOTO lbl-1000
                    break block10;
                }
                if (var4_4.child01 != null) {
                    var2_2.push((BoxNode<T>)var4_4.child01);
                } else if (var4_4.child10 != null) {
                    var2_2.push((BoxNode<T>)var4_4.child10);
                } else if (var4_4.child11 != null) {
                    var2_2.push((BoxNode<T>)var4_4.child11);
                }
            }
            if (var3_3.child00 != null) {
                var2_2.push((BoxNode<T>)var3_3.child00);
                continue;
            }
            if (var3_3.child01 != null) {
                var2_2.push((BoxNode<T>)var3_3.child01);
                continue;
            }
            if (var3_3.child10 != null) {
                var2_2.push((BoxNode<T>)var3_3.child10);
                continue;
            }
            if (var3_3.child11 == null) continue;
            var2_2.push((BoxNode<T>)var3_3.child11);
        }
        this.stackPool.release(var2_2);
    }

    @Override
    public BoxNode<T> create() {
        return new BoxNode();
    }

    public BoxNode<T> create(BoxNode<T> boxNode, int n) {
        BoxNode boxNode2;
        if (this.pool != null) {
            boxNode2 = (BoxNode)this.pool;
            this.pool = ((BoxNode)this.pool).parent;
            boxNode2.refs = 0;
        } else {
            boxNode2 = new BoxNode();
        }
        boxNode2.parent = boxNode;
        int n2 = boxNode.x2 - boxNode.x1 >> 1;
        boxNode2.x1 = boxNode.x1;
        boxNode2.y1 = boxNode.y1;
        if (n == 0) {
            boxNode.child00 = boxNode2;
        } else if (n == 1) {
            boxNode.child01 = boxNode2;
            boxNode2.y1 += n2;
        } else if (n == 2) {
            boxNode.child10 = boxNode2;
            boxNode2.x1 += n2;
        } else {
            boxNode.child11 = boxNode2;
            boxNode2.x1 += n2;
            boxNode2.y1 += n2;
        }
        boxNode2.x2 = boxNode2.x1 + n2;
        boxNode2.y2 = boxNode2.y1 + n2;
        boxNode2.id = (byte)n;
        return boxNode2;
    }

    public BoxNode<T> getNode(T object, boolean bl) {
        if (((BoxItem)object).x1 <= ((BoxItem)object).x2 && ((BoxItem)object).y1 <= ((BoxItem)object).y2) {
            block18: {
                BoxNode boxNode = (BoxNode)this.root;
                int n = ((BoxItem)object).x1;
                int n2 = ((BoxItem)object).x2;
                int n3 = ((BoxItem)object).y1;
                int n4 = ((BoxItem)object).y2;
                int n5 = 0;
                while (true) {
                    int n6 = this.maxDepth;
                    BoxNode boxNode2 = null;
                    if (n5 > n6) break block18;
                    ++boxNode.refs;
                    int n7 = boxNode.x2 - boxNode.x1 >> 1;
                    n6 = boxNode.x1 + n7;
                    n7 = boxNode.y1 + n7;
                    object = boxNode2;
                    if (n2 < n6) {
                        if (n4 < n7) {
                            boxNode2 = (BoxNode)boxNode.child00;
                            object = boxNode2;
                            if (boxNode2 == null) {
                                object = boxNode2;
                                if (bl) {
                                    object = this.create(boxNode, 0);
                                }
                            }
                        } else {
                            object = boxNode2;
                            if (n3 >= n7) {
                                boxNode2 = (BoxNode)boxNode.child01;
                                object = boxNode2;
                                if (boxNode2 == null) {
                                    object = boxNode2;
                                    if (bl) {
                                        object = this.create(boxNode, 1);
                                    }
                                }
                            }
                        }
                    }
                    if (n >= n6) {
                        if (n4 < n7) {
                            boxNode2 = (BoxNode)boxNode.child10;
                            object = boxNode2;
                            if (boxNode2 == null) {
                                object = boxNode2;
                                if (bl) {
                                    object = this.create(boxNode, 2);
                                }
                            }
                        } else if (n3 >= n7) {
                            boxNode2 = (BoxNode)boxNode.child11;
                            object = boxNode2;
                            if (boxNode2 == null) {
                                object = boxNode2;
                                if (bl) {
                                    object = this.create(boxNode, 3);
                                }
                            }
                        }
                    }
                    if (object == null || n5 == this.maxDepth) break;
                    ++n5;
                    boxNode = object;
                }
                return boxNode;
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    public void insert(T t) {
        if (((BoxItem)t).x1 <= ((BoxItem)t).x2 && ((BoxItem)t).y1 <= ((BoxItem)t).y2) {
            if (((BoxItem)t).next == null) {
                BoxNode boxNode = (BoxNode)this.root;
                int n = ((BoxItem)t).x1;
                int n2 = ((BoxItem)t).x2;
                int n3 = ((BoxItem)t).y1;
                int n4 = ((BoxItem)t).y2;
                for (int i = 0; i <= this.maxDepth; ++i) {
                    BoxNode<T> boxNode2;
                    ++boxNode.refs;
                    int n5 = boxNode.x2 - boxNode.x1 >> 1;
                    int n6 = boxNode.x1 + n5;
                    n5 = boxNode.y1 + n5;
                    BoxNode<T> boxNode3 = null;
                    BoxNode boxNode4 = null;
                    if (i < this.maxDepth) {
                        boxNode2 = boxNode4;
                        if (n2 < n6) {
                            if (n4 < n5) {
                                boxNode3 = (BoxNode)boxNode.child00;
                                boxNode2 = boxNode3;
                                if (boxNode3 == null) {
                                    boxNode2 = this.create(boxNode, 0);
                                }
                            } else {
                                boxNode2 = boxNode4;
                                if (n3 >= n5) {
                                    boxNode3 = (BoxNode)boxNode.child01;
                                    boxNode2 = boxNode3;
                                    if (boxNode3 == null) {
                                        boxNode2 = this.create(boxNode, 1);
                                    }
                                }
                            }
                        }
                        boxNode3 = boxNode2;
                        if (n >= n6) {
                            if (n4 < n5) {
                                boxNode2 = (BoxNode)boxNode.child10;
                                boxNode3 = boxNode2;
                                if (boxNode2 == null) {
                                    boxNode3 = this.create(boxNode, 2);
                                }
                            } else {
                                boxNode3 = boxNode2;
                                if (n3 >= n5) {
                                    boxNode2 = (BoxNode<T>)boxNode.child11;
                                    boxNode3 = boxNode2;
                                    if (boxNode2 == null) {
                                        boxNode3 = this.create(boxNode, 3);
                                    }
                                }
                            }
                        }
                    }
                    if (boxNode3 == null) {
                        ((BoxItem)t).next = (Inlist)boxNode.item;
                        boxNode.item = t;
                        if (!dbg) break;
                        boxNode3 = log;
                        boxNode2 = new StringBuilder();
                        ((StringBuilder)((Object)boxNode2)).append("insert: ");
                        ((StringBuilder)((Object)boxNode2)).append(i);
                        ((StringBuilder)((Object)boxNode2)).append(" cnt:");
                        ((StringBuilder)((Object)boxNode2)).append(Inlist.size((Inlist)boxNode.item));
                        ((StringBuilder)((Object)boxNode2)).append(" ");
                        ((StringBuilder)((Object)boxNode2)).append(n);
                        ((StringBuilder)((Object)boxNode2)).append(":");
                        ((StringBuilder)((Object)boxNode2)).append(n3);
                        ((StringBuilder)((Object)boxNode2)).append(" /");
                        ((StringBuilder)((Object)boxNode2)).append(n2);
                        ((StringBuilder)((Object)boxNode2)).append("x");
                        ((StringBuilder)((Object)boxNode2)).append(n4);
                        ((StringBuilder)((Object)boxNode2)).append(" ");
                        ((StringBuilder)((Object)boxNode2)).append(((BoxItem)t).item);
                        boxNode3.debug(((StringBuilder)((Object)boxNode2)).toString());
                        break;
                    }
                    boxNode = boxNode3;
                }
                return;
            }
            throw new IllegalStateException("BoxItem is list");
        }
        throw new IllegalArgumentException();
    }

    boolean isPowerOfTwo(int n) {
        boolean bl = n > 0 && (n & n - 1) == 0;
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean remove(T var1_1, E var2_2) {
        block11: {
            if (var1_1 /* !! */ .x1 > var1_1 /* !! */ .x2 || var1_1 /* !! */ .y1 > var1_1 /* !! */ .y2) break block11;
            var3_3 /* !! */  = (BoxNode)this.root;
            var4_4 = var1_1 /* !! */ .x1;
            var5_5 = var1_1 /* !! */ .x2;
            var6_6 = var1_1 /* !! */ .y1;
            var7_7 = var1_1 /* !! */ .y2;
            for (var8_8 = 0; var8_8 <= this.maxDepth; ++var8_8) {
                block14: {
                    block12: {
                        block13: {
                            var9_9 = var3_3 /* !! */ .x2 - var3_3 /* !! */ .x1 >> 1;
                            var10_10 = var3_3 /* !! */ .x1 + var9_9;
                            var9_9 = var3_3 /* !! */ .y1 + var9_9;
                            if (var8_8 >= this.maxDepth) ** GOTO lbl-1000
                            if (var5_5 >= var10_10) break block12;
                            if (var7_7 >= var9_9) break block13;
                            var1_1 /* !! */  = (BoxNode)var3_3 /* !! */ .child00;
                            break block14;
                        }
                        if (var6_6 < var9_9) ** GOTO lbl-1000
                        var1_1 /* !! */  = (BoxNode)var3_3 /* !! */ .child01;
                        break block14;
                    }
                    if (var4_4 < var10_10) ** GOTO lbl-1000
                    if (var7_7 < var9_9) {
                        var1_1 /* !! */  = (BoxNode)var3_3 /* !! */ .child10;
                    } else if (var6_6 >= var9_9) {
                        var1_1 /* !! */  = (BoxNode)var3_3 /* !! */ .child11;
                    } else lbl-1000:
                    // 4 sources

                    {
                        var1_1 /* !! */  = null;
                    }
                }
                if (var1_1 /* !! */  == null) {
                    var1_1 /* !! */  = (BoxItem)var3_3 /* !! */ .item;
                    var11_11 = var3_3 /* !! */ .item;
                    while ((var11_11 = (BoxItem)var11_11) != null) {
                        if (var11_11.item == var2_2) {
                            if (BoxTree.dbg) {
                                var12_13 = BoxTree.log;
                                var13_12 = new StringBuilder();
                                var13_12.append("remove: ");
                                var13_12.append(var8_8);
                                var13_12.append(" cnt:");
                                var13_12.append(Inlist.size((Inlist)var3_3 /* !! */ .item));
                                var13_12.append(" ");
                                var13_12.append(var4_4);
                                var13_12.append(":");
                                var13_12.append(var6_6);
                                var13_12.append(" /");
                                var13_12.append(var5_5);
                                var13_12.append("x");
                                var13_12.append(var7_7);
                                var13_12.append(" ");
                                var13_12.append(var2_2);
                                var12_13.debug(var13_12.toString());
                            }
                            if (var3_3 /* !! */ .item == var11_11) {
                                var3_3 /* !! */ .item = (BoxItem)var11_11.next;
                            } else {
                                var1_1 /* !! */ .next = var11_11.next;
                            }
                            var11_11.next = null;
                            this.remove(var3_3 /* !! */ );
                            return true;
                        }
                        var13_12 = var11_11.next;
                        var1_1 /* !! */  = var11_11;
                        var11_11 = var13_12;
                    }
                    return false;
                }
                var3_3 /* !! */  = var1_1 /* !! */ ;
            }
            return false;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void removeItem(T t) {
    }

    /*
     * Unable to fully structure code
     */
    public boolean search(BoxItem<?> var1_1, SpatialIndex.SearchCb<E> var2_2, Object var3_3) {
        var4_4 = this.stackPool.get();
        var4_4.push((BoxNode<T>)this.root);
        while (!var4_4.empty()) {
            block12: {
                block11: {
                    var5_5 = var4_4.pop();
                    var6_6 = var5_5.item;
                    while ((var6_6 = (BoxItem)var6_6) != null) {
                        if (var6_6.overlaps(var1_1) && !var2_2.call(var6_6.item, var3_3)) {
                            this.stackPool.release(var4_4);
                            return false;
                        }
                        var6_6 = var6_6.next;
                    }
                    var6_6 = (BoxNode)var5_5.parent;
                    var7_7 = var5_5.id;
                    if (var7_7 == 0) break block11;
                    if (var7_7 == 1) ** GOTO lbl-1000
                    if (var7_7 == 2) ** GOTO lbl-1000
                    break block12;
                }
                if (BoxTree.overlaps((BoxNode)var6_6.child01, var1_1)) {
                    var4_4.push((BoxNode<T>)var6_6.child01);
                } else if (BoxTree.overlaps((BoxNode)var6_6.child10, var1_1)) {
                    var4_4.push((BoxNode<T>)var6_6.child10);
                } else if (BoxTree.overlaps((BoxNode)var6_6.child11, var1_1)) {
                    var4_4.push((BoxNode<T>)var6_6.child11);
                }
            }
            if (BoxTree.overlaps((BoxNode)var5_5.child00, var1_1)) {
                var4_4.push((BoxNode<T>)var5_5.child00);
                continue;
            }
            if (BoxTree.overlaps((BoxNode)var5_5.child01, var1_1)) {
                var4_4.push((BoxNode<T>)var5_5.child01);
                continue;
            }
            if (BoxTree.overlaps((BoxNode)var5_5.child10, var1_1)) {
                var4_4.push((BoxNode<T>)var5_5.child10);
                continue;
            }
            if (!BoxTree.overlaps((BoxNode)var5_5.child11, var1_1)) continue;
            var4_4.push((BoxNode<T>)var5_5.child11);
        }
        this.stackPool.release(var4_4);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean search(BoxItem<?> var1_1, SearchBoxCb<T> var2_2) {
        if (((BoxNode)this.root).refs == 0) {
            return true;
        }
        var3_3 = this.stackPool.get();
        var3_3.push((BoxNode<T>)this.root);
        while (!var3_3.empty()) {
            block13: {
                block12: {
                    var4_4 = var3_3.pop();
                    var5_5 = var4_4.item;
                    while ((var5_5 = (BoxItem)var5_5) != null) {
                        if (var5_5.overlaps(var1_1) && !var2_2.call(var5_5)) {
                            this.stackPool.release(var3_3);
                            return false;
                        }
                        var5_5 = var5_5.next;
                    }
                    var5_5 = (BoxNode)var4_4.parent;
                    var6_6 = var4_4.id;
                    if (var6_6 == 0) break block12;
                    if (var6_6 == 1) ** GOTO lbl-1000
                    if (var6_6 == 2) ** GOTO lbl-1000
                    break block13;
                }
                if (BoxTree.overlaps((BoxNode)var5_5.child01, var1_1)) {
                    var3_3.push((BoxNode<T>)var5_5.child01);
                } else if (BoxTree.overlaps((BoxNode)var5_5.child10, var1_1)) {
                    var3_3.push((BoxNode<T>)var5_5.child10);
                } else if (BoxTree.overlaps((BoxNode)var5_5.child11, var1_1)) {
                    var3_3.push((BoxNode<T>)var5_5.child11);
                }
            }
            if (BoxTree.overlaps((BoxNode)var4_4.child00, var1_1)) {
                var3_3.push((BoxNode<T>)var4_4.child00);
                continue;
            }
            if (BoxTree.overlaps((BoxNode)var4_4.child01, var1_1)) {
                var3_3.push((BoxNode<T>)var4_4.child01);
                continue;
            }
            if (BoxTree.overlaps((BoxNode)var4_4.child10, var1_1)) {
                var3_3.push((BoxNode<T>)var4_4.child10);
                continue;
            }
            if (!BoxTree.overlaps((BoxNode)var4_4.child11, var1_1)) continue;
            var3_3.push((BoxNode<T>)var4_4.child11);
        }
        this.stackPool.release(var3_3);
        return true;
    }

    @Override
    public int size() {
        return ((BoxNode)this.root).refs;
    }

    public static class BoxItem<T>
    extends Inlist<BoxItem<T>> {
        public T item;
        public int x1;
        public int x2;
        public int y1;
        public int y2;

        public BoxItem() {
        }

        public BoxItem(float f, float f2, float f3, float f4) {
            this.x1 = (int)f;
            this.y1 = (int)f2;
            this.x2 = (int)f3;
            this.y2 = (int)f4;
        }

        public BoxItem(int n, int n2, int n3, int n4) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
        }

        public BoxItem(Box box, T t) {
            this.x1 = (int)box.xmin;
            this.y1 = (int)box.ymin;
            this.x2 = (int)box.xmax;
            this.y2 = (int)box.ymax;
            this.item = t;
        }

        public boolean overlaps(BoxItem<?> boxItem) {
            boolean bl = this.x1 <= boxItem.x2 && boxItem.x1 <= this.x2 && this.y1 <= boxItem.y2 && boxItem.y1 <= this.y2;
            return bl;
        }

        public void setExtents(float[] fArray, float f) {
            this.setExtents(fArray, f, fArray.length);
        }

        public void setExtents(float[] fArray, float f, int n) {
            float f2;
            float f3 = fArray[0];
            float f4 = f2 = fArray[1];
            float f5 = f3;
            for (int i = 2; i < n; i += 2) {
                float f6;
                float f7;
                float f8;
                float f9 = fArray[i];
                if (f9 < f3) {
                    f8 = f9;
                    f7 = f5;
                } else {
                    f8 = f3;
                    f7 = f5;
                    if (f9 > f5) {
                        f7 = f9;
                        f8 = f3;
                    }
                }
                f5 = fArray[i + 1];
                if (f5 < f2) {
                    f9 = f5;
                    f6 = f4;
                } else {
                    f9 = f2;
                    f6 = f4;
                    if (f5 > f4) {
                        f6 = f5;
                        f9 = f2;
                    }
                }
                f3 = f8;
                f5 = f7;
                f2 = f9;
                f4 = f6;
            }
            this.x1 = (int)(f3 - f);
            this.y1 = (int)(f2 - f);
            this.x2 = (int)(f5 + f);
            this.y2 = (int)(f4 + f);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append(this.x1);
            stringBuilder.append(',');
            stringBuilder.append(this.y1);
            stringBuilder.append('/');
            stringBuilder.append(this.x2);
            stringBuilder.append(',');
            stringBuilder.append(this.y2);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    public static class BoxNode<T extends BoxItem<?>>
    extends TreeNode<BoxNode<T>, T> {
        public int x1;
        public int x2;
        public int y1;
        public int y2;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.x1);
            stringBuilder.append(":");
            stringBuilder.append(this.y1);
            stringBuilder.append(":");
            stringBuilder.append(this.x2 - this.x1);
            return stringBuilder.toString();
        }
    }

    public static interface SearchBoxCb<T extends BoxItem<?>> {
        public boolean call(T var1);
    }

    public static interface SearchNodeCb<E extends BoxNode<?>> {
        public boolean call(E var1);
    }

    static class Stack<E>
    extends Inlist<Stack<E>> {
        final E[] nodes = new BoxNode[32];
        int tos;

        Stack() {
        }

        boolean empty() {
            boolean bl = this.tos <= 0;
            return bl;
        }

        E node() {
            return this.nodes[this.tos];
        }

        E pop() {
            int n;
            E[] EArray = this.nodes;
            int n2 = this.tos;
            this.tos = n = n2 - 1;
            EArray[n2] = null;
            return EArray[n];
        }

        void push(E e) {
            E[] EArray = this.nodes;
            int n = this.tos;
            EArray[n] = e;
            this.tos = n + 1;
        }
    }

    public static interface Visitor<T> {
        public boolean process(T var1);
    }
}

