/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.quadtree;

import org.oscim.utils.quadtree.TreeNode;

public abstract class TileIndex<T extends TreeNode<T, E>, E> {
    protected T pool;
    protected final T root;

    public TileIndex() {
        T t = this.create();
        this.root = t;
        ((TreeNode)t).id = -1;
        ((TreeNode)t).parent = t;
    }

    static void checkIndex(int n, int n2, int n3) {
        if (n >= 0 && n < n3 && n2 >= 0 && n2 < n3) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid position ");
        stringBuilder.append(n);
        stringBuilder.append('/');
        stringBuilder.append(n2);
        stringBuilder.append('/');
        stringBuilder.append(n3 >> 1);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public T add(int n, int n2, int n3) {
        TileIndex.checkIndex(n, n2, 1 << n3);
        if (n3 == 0) {
            return this.root;
        }
        T t = this.root;
        --n3;
        while (n3 >= 0) {
            int n4 = n >> n3 & 1 | (n2 >> n3 & 1) << 1;
            ++((TreeNode)t).refs;
            Object var6_6 = null;
            if (n4 != 0) {
                if (n4 != 1) {
                    if (n4 != 2) {
                        if (n4 == 3) {
                            var6_6 = ((TreeNode)t).child11;
                        }
                    } else {
                        var6_6 = ((TreeNode)t).child10;
                    }
                } else {
                    var6_6 = ((TreeNode)t).child01;
                }
            } else {
                var6_6 = ((TreeNode)t).child00;
            }
            if (var6_6 == null) {
                var6_6 = this.pool;
                if (var6_6 != null) {
                    this.pool = var6_6.parent;
                } else {
                    var6_6 = this.create();
                }
                var6_6.refs = 0;
                var6_6.id = (byte)n4;
                var6_6.parent = t;
                if (n4 != 0) {
                    if (n4 != 1) {
                        if (n4 != 2) {
                            if (n4 == 3) {
                                ((TreeNode)var6_6.parent).child11 = var6_6;
                            }
                        } else {
                            ((TreeNode)var6_6.parent).child10 = var6_6;
                        }
                    } else {
                        ((TreeNode)var6_6.parent).child01 = var6_6;
                    }
                } else {
                    ((TreeNode)var6_6.parent).child00 = var6_6;
                }
            }
            --n3;
            t = var6_6;
        }
        ++((TreeNode)t).refs;
        return t;
    }

    public abstract T create();

    public void drop() {
        ((TreeNode)this.root).item = null;
        ((TreeNode)this.root).child00 = null;
        ((TreeNode)this.root).child01 = null;
        ((TreeNode)this.root).child10 = null;
        ((TreeNode)this.root).child11 = null;
    }

    public E getTile(int n, int n2, int n3) {
        TileIndex.checkIndex(n, n2, 1 << n3);
        if (n3 == 0) {
            return ((TreeNode)this.root).item;
        }
        T t = this.root;
        --n3;
        while (n3 >= 0) {
            int n4 = n >> n3 & 1 | (n2 >> n3 & 1) << 1;
            if (n4 != 0) {
                if (n4 != 1) {
                    if (n4 != 2) {
                        if (n4 == 3) {
                            t = ((TreeNode)t).child11;
                        }
                    } else {
                        t = ((TreeNode)t).child10;
                    }
                } else {
                    t = ((TreeNode)t).child01;
                }
            } else {
                t = ((TreeNode)t).child00;
            }
            if (t == null) {
                return null;
            }
            if (n3 == 0) {
                return ((TreeNode)t).item;
            }
            --n3;
        }
        return null;
    }

    public boolean remove(T t) {
        T t2;
        while (t != (t2 = this.root)) {
            if (t != null) {
                t2 = ((TreeNode)t).parent;
                --((TreeNode)t).refs;
                if (((TreeNode)t).refs == 0) {
                    int n = ((TreeNode)t).id;
                    if (n != 0) {
                        if (n != 1) {
                            if (n != 2) {
                                if (n == 3) {
                                    ((TreeNode)t2).child11 = null;
                                }
                            } else {
                                ((TreeNode)t2).child10 = null;
                            }
                        } else {
                            ((TreeNode)t2).child01 = null;
                        }
                    } else {
                        ((TreeNode)t2).child00 = null;
                    }
                    ((TreeNode)t).parent = this.pool;
                    this.pool = t;
                }
                t = t2;
                continue;
            }
            throw new IllegalStateException("Item not in index");
        }
        --((TreeNode)t2).refs;
        return true;
    }

    public abstract void removeItem(E var1);

    public int size() {
        return ((TreeNode)this.root).refs;
    }
}

