/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.NOPLoggerFactory;
import org.slf4j.helpers.SubstituteLogger;
import org.slf4j.helpers.SubstituteLoggerFactory;
import org.slf4j.helpers.Util;
import org.slf4j.impl.StaticLoggerBinder;

public final class LoggerFactory {
    private static final String[] API_COMPATIBILITY_LIST;
    static final String CODES_PREFIX = "http://www.slf4j.org/codes.html";
    static boolean DETECT_LOGGER_NAME_MISMATCH = false;
    static final String DETECT_LOGGER_NAME_MISMATCH_PROPERTY = "slf4j.detectLoggerNameMismatch";
    static final int FAILED_INITIALIZATION = 2;
    static volatile int INITIALIZATION_STATE = 0;
    static final String JAVA_VENDOR_PROPERTY = "java.vendor.url";
    static final String LOGGER_NAME_MISMATCH_URL = "http://www.slf4j.org/codes.html#loggerNameMismatch";
    static final String MULTIPLE_BINDINGS_URL = "http://www.slf4j.org/codes.html#multiple_bindings";
    static final NOPLoggerFactory NOP_FALLBACK_FACTORY;
    static final int NOP_FALLBACK_INITIALIZATION = 4;
    static final String NO_STATICLOGGERBINDER_URL = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String NULL_LF_URL = "http://www.slf4j.org/codes.html#null_LF";
    static final int ONGOING_INITIALIZATION = 1;
    static final String REPLAY_URL = "http://www.slf4j.org/codes.html#replay";
    private static String STATIC_LOGGER_BINDER_PATH;
    static final String SUBSTITUTE_LOGGER_URL = "http://www.slf4j.org/codes.html#substituteLogger";
    static final SubstituteLoggerFactory SUBST_FACTORY;
    static final int SUCCESSFUL_INITIALIZATION = 3;
    static final int UNINITIALIZED = 0;
    static final String UNSUCCESSFUL_INIT_MSG = "org.slf4j.LoggerFactory in failed state. Original exception was thrown EARLIER. See also http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String UNSUCCESSFUL_INIT_URL = "http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String VERSION_MISMATCH = "http://www.slf4j.org/codes.html#version_mismatch";

    static {
        SUBST_FACTORY = new SubstituteLoggerFactory();
        NOP_FALLBACK_FACTORY = new NOPLoggerFactory();
        DETECT_LOGGER_NAME_MISMATCH = Util.safeGetBooleanSystemProperty(DETECT_LOGGER_NAME_MISMATCH_PROPERTY);
        API_COMPATIBILITY_LIST = new String[]{"1.6", "1.7"};
        STATIC_LOGGER_BINDER_PATH = "org/slf4j/impl/StaticLoggerBinder.class";
    }

    private LoggerFactory() {
    }

    private static final void bind() {
        NoClassDefFoundError noClassDefFoundError2;
        block6: {
            Object object = null;
            try {
                if (!LoggerFactory.isAndroid()) {
                    object = LoggerFactory.findPossibleStaticLoggerBinderPathSet();
                    LoggerFactory.reportMultipleBindingAmbiguity(object);
                }
                StaticLoggerBinder.getSingleton();
                INITIALIZATION_STATE = 3;
                LoggerFactory.reportActualBinding((Set<URL>)object);
                LoggerFactory.fixSubstituteLoggers();
                LoggerFactory.replayEvents();
                SUBST_FACTORY.clear();
            }
            catch (Exception exception) {
                LoggerFactory.failedBinding(exception);
                throw new IllegalStateException("Unexpected initialization failure", exception);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                object = noSuchMethodError.getMessage();
                if (object != null && ((String)object).contains("org.slf4j.impl.StaticLoggerBinder.getSingleton()")) {
                    INITIALIZATION_STATE = 2;
                    Util.report("slf4j-api 1.6.x (or later) is incompatible with this binding.");
                    Util.report("Your binding is version 1.5.5 or earlier.");
                    Util.report("Upgrade your binding to version 1.6.x.");
                }
                throw noSuchMethodError;
            }
            catch (NoClassDefFoundError noClassDefFoundError2) {
                if (!LoggerFactory.messageContainsOrgSlf4jImplStaticLoggerBinder(noClassDefFoundError2.getMessage())) break block6;
                INITIALIZATION_STATE = 4;
                Util.report("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                Util.report("Defaulting to no-operation (NOP) logger implementation");
                Util.report("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
            }
            return;
        }
        LoggerFactory.failedBinding(noClassDefFoundError2);
        throw noClassDefFoundError2;
    }

    private static void emitReplayOrSubstituionWarning(SubstituteLoggingEvent substituteLoggingEvent, int n) {
        if (substituteLoggingEvent.getLogger().isDelegateEventAware()) {
            LoggerFactory.emitReplayWarning(n);
        } else if (!substituteLoggingEvent.getLogger().isDelegateNOP()) {
            LoggerFactory.emitSubstitutionWarning();
        }
    }

    private static void emitReplayWarning(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("A number (");
        stringBuilder.append(n);
        stringBuilder.append(") of logging calls during the initialization phase have been intercepted and are");
        Util.report(stringBuilder.toString());
        Util.report("now being replayed. These are subject to the filtering rules of the underlying logging system.");
        Util.report("See also http://www.slf4j.org/codes.html#replay");
    }

    private static void emitSubstitutionWarning() {
        Util.report("The following set of substitute loggers may have been accessed");
        Util.report("during the initialization phase. Logging calls during this");
        Util.report("phase were not honored. However, subsequent logging calls to these");
        Util.report("loggers will work as normally expected.");
        Util.report("See also http://www.slf4j.org/codes.html#substituteLogger");
    }

    static void failedBinding(Throwable throwable) {
        INITIALIZATION_STATE = 2;
        Util.report("Failed to instantiate SLF4J LoggerFactory", throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Set<URL> findPossibleStaticLoggerBinderPathSet() {
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> enumeration = LoggerFactory.class.getClassLoader();
            enumeration = enumeration == null ? ClassLoader.getSystemResources(STATIC_LOGGER_BINDER_PATH) : ((ClassLoader)((Object)enumeration)).getResources(STATIC_LOGGER_BINDER_PATH);
            while (enumeration.hasMoreElements()) {
                linkedHashSet.add(enumeration.nextElement());
            }
            return linkedHashSet;
        }
        catch (IOException iOException) {
            Util.report("Error getting resources from path", iOException);
        }
        return linkedHashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void fixSubstituteLoggers() {
        SubstituteLoggerFactory substituteLoggerFactory = SUBST_FACTORY;
        synchronized (substituteLoggerFactory) {
            substituteLoggerFactory.postInitialization();
            Iterator<SubstituteLogger> iterator2 = substituteLoggerFactory.getLoggers().iterator();
            while (iterator2.hasNext()) {
                SubstituteLogger substituteLogger = iterator2.next();
                substituteLogger.setDelegate(LoggerFactory.getLogger(substituteLogger.getName()));
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ILoggerFactory getILoggerFactory() {
        int n;
        if (INITIALIZATION_STATE == 0) {
            synchronized (LoggerFactory.class) {
                if (INITIALIZATION_STATE == 0) {
                    INITIALIZATION_STATE = 1;
                    LoggerFactory.performInitialization();
                }
            }
        }
        if ((n = INITIALIZATION_STATE) == 1) {
            return SUBST_FACTORY;
        }
        if (n == 2) {
            throw new IllegalStateException(UNSUCCESSFUL_INIT_MSG);
        }
        if (n == 3) {
            return StaticLoggerBinder.getSingleton().getLoggerFactory();
        }
        if (n == 4) {
            return NOP_FALLBACK_FACTORY;
        }
        throw new IllegalStateException("Unreachable code");
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        Logger logger = LoggerFactory.getLogger(clazz.getName());
        if (DETECT_LOGGER_NAME_MISMATCH && (clazz2 = Util.getCallingClass()) != null && LoggerFactory.nonMatchingClasses(clazz, clazz2)) {
            Util.report(String.format("Detected logger name mismatch. Given name: \"%s\"; computed name: \"%s\".", logger.getName(), clazz2.getName()));
            Util.report("See http://www.slf4j.org/codes.html#loggerNameMismatch for an explanation");
        }
        return logger;
    }

    public static Logger getLogger(String string2) {
        return LoggerFactory.getILoggerFactory().getLogger(string2);
    }

    private static boolean isAmbiguousStaticLoggerBinderPathSet(Set<URL> set) {
        int n = set.size();
        boolean bl = true;
        if (n <= 1) {
            bl = false;
        }
        return bl;
    }

    private static boolean isAndroid() {
        String string2 = Util.safeGetSystemProperty(JAVA_VENDOR_PROPERTY);
        if (string2 == null) {
            return false;
        }
        return string2.toLowerCase().contains("android");
    }

    private static boolean messageContainsOrgSlf4jImplStaticLoggerBinder(String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.contains("org/slf4j/impl/StaticLoggerBinder")) {
            return true;
        }
        return string2.contains("org.slf4j.impl.StaticLoggerBinder");
    }

    private static boolean nonMatchingClasses(Class<?> clazz, Class<?> clazz2) {
        return clazz2.isAssignableFrom(clazz) ^ true;
    }

    private static final void performInitialization() {
        LoggerFactory.bind();
        if (INITIALIZATION_STATE == 3) {
            LoggerFactory.versionSanityCheck();
        }
    }

    private static void replayEvents() {
        LinkedBlockingQueue<SubstituteLoggingEvent> linkedBlockingQueue = SUBST_FACTORY.getEventQueue();
        int n = linkedBlockingQueue.size();
        ArrayList arrayList = new ArrayList(128);
        int n2 = 0;
        while (linkedBlockingQueue.drainTo(arrayList, 128) != 0) {
            for (SubstituteLoggingEvent substituteLoggingEvent : arrayList) {
                LoggerFactory.replaySingleEvent(substituteLoggingEvent);
                if (n2 == 0) {
                    LoggerFactory.emitReplayOrSubstituionWarning(substituteLoggingEvent, n);
                }
                ++n2;
            }
            arrayList.clear();
        }
        return;
    }

    private static void replaySingleEvent(SubstituteLoggingEvent substituteLoggingEvent) {
        if (substituteLoggingEvent == null) {
            return;
        }
        SubstituteLogger substituteLogger = substituteLoggingEvent.getLogger();
        String string2 = substituteLogger.getName();
        if (!substituteLogger.isDelegateNull()) {
            if (!substituteLogger.isDelegateNOP()) {
                if (substituteLogger.isDelegateEventAware()) {
                    substituteLogger.log(substituteLoggingEvent);
                } else {
                    Util.report(string2);
                }
            }
            return;
        }
        throw new IllegalStateException("Delegate logger cannot be null at this state.");
    }

    private static void reportActualBinding(Set<URL> object) {
        if (object != null && LoggerFactory.isAmbiguousStaticLoggerBinderPathSet(object)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Actual binding is of type [");
            ((StringBuilder)object).append(StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr());
            ((StringBuilder)object).append("]");
            Util.report(((StringBuilder)object).toString());
        }
    }

    private static void reportMultipleBindingAmbiguity(Set<URL> object) {
        if (LoggerFactory.isAmbiguousStaticLoggerBinderPathSet(object)) {
            Util.report("Class path contains multiple SLF4J bindings.");
            Iterator<URL> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                URL uRL = iterator2.next();
                object = new StringBuilder();
                ((StringBuilder)object).append("Found binding in [");
                ((StringBuilder)object).append(uRL);
                ((StringBuilder)object).append("]");
                Util.report(((StringBuilder)object).toString());
            }
            Util.report("See http://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
        }
    }

    static void reset() {
        INITIALIZATION_STATE = 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void versionSanityCheck() {
        Object object;
        String string2;
        try {
            string2 = StaticLoggerBinder.REQUESTED_API_VERSION;
            object = API_COMPATIBILITY_LIST;
            int n = ((String[])object).length;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (!string2.startsWith(object[i])) continue;
                bl = true;
            }
            if (bl) return;
        }
        catch (Throwable throwable) {
            Util.report("Unexpected problem occured during version sanity check", throwable);
            return;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            return;
        }
        {
            object = new StringBuilder();
            ((StringBuilder)object).append("The requested version ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" by your slf4j binding is not compatible with ");
            ((StringBuilder)object).append(Arrays.asList(API_COMPATIBILITY_LIST).toString());
            Util.report(((StringBuilder)object).toString());
            Util.report("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            return;
        }
    }
}

