/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.event;

import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.SubstituteLogger;

public class EventRecodingLogger
implements Logger {
    Queue<SubstituteLoggingEvent> eventQueue;
    SubstituteLogger logger;
    String name;

    public EventRecodingLogger(SubstituteLogger substituteLogger, Queue<SubstituteLoggingEvent> queue) {
        this.logger = substituteLogger;
        this.name = substituteLogger.getName();
        this.eventQueue = queue;
    }

    private void recordEvent(Level level, String string2, Object[] objectArray, Throwable throwable) {
        this.recordEvent(level, null, string2, objectArray, throwable);
    }

    private void recordEvent(Level level, Marker marker, String string2, Object[] objectArray, Throwable throwable) {
        SubstituteLoggingEvent substituteLoggingEvent = new SubstituteLoggingEvent();
        substituteLoggingEvent.setTimeStamp(System.currentTimeMillis());
        substituteLoggingEvent.setLevel(level);
        substituteLoggingEvent.setLogger(this.logger);
        substituteLoggingEvent.setLoggerName(this.name);
        substituteLoggingEvent.setMarker(marker);
        substituteLoggingEvent.setMessage(string2);
        substituteLoggingEvent.setArgumentArray(objectArray);
        substituteLoggingEvent.setThrowable(throwable);
        substituteLoggingEvent.setThreadName(Thread.currentThread().getName());
        this.eventQueue.add(substituteLoggingEvent);
    }

    @Override
    public void debug(String string2) {
        this.recordEvent(Level.TRACE, string2, null, null);
    }

    @Override
    public void debug(String string2, Object object) {
        this.recordEvent(Level.DEBUG, string2, new Object[]{object}, null);
    }

    @Override
    public void debug(String string2, Object object, Object object2) {
        this.recordEvent(Level.DEBUG, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void debug(String string2, Throwable throwable) {
        this.recordEvent(Level.DEBUG, string2, null, throwable);
    }

    @Override
    public void debug(String string2, Object ... objectArray) {
        this.recordEvent(Level.DEBUG, string2, objectArray, null);
    }

    @Override
    public void debug(Marker marker, String string2) {
        this.recordEvent(Level.DEBUG, marker, string2, null, null);
    }

    @Override
    public void debug(Marker marker, String string2, Object object) {
        this.recordEvent(Level.DEBUG, marker, string2, new Object[]{object}, null);
    }

    @Override
    public void debug(Marker marker, String string2, Object object, Object object2) {
        this.recordEvent(Level.DEBUG, marker, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void debug(Marker marker, String string2, Throwable throwable) {
        this.recordEvent(Level.DEBUG, marker, string2, null, throwable);
    }

    @Override
    public void debug(Marker marker, String string2, Object ... objectArray) {
        this.recordEvent(Level.DEBUG, marker, string2, objectArray, null);
    }

    @Override
    public void error(String string2) {
        this.recordEvent(Level.ERROR, string2, null, null);
    }

    @Override
    public void error(String string2, Object object) {
        this.recordEvent(Level.ERROR, string2, new Object[]{object}, null);
    }

    @Override
    public void error(String string2, Object object, Object object2) {
        this.recordEvent(Level.ERROR, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void error(String string2, Throwable throwable) {
        this.recordEvent(Level.ERROR, string2, null, throwable);
    }

    @Override
    public void error(String string2, Object ... objectArray) {
        this.recordEvent(Level.ERROR, string2, objectArray, null);
    }

    @Override
    public void error(Marker marker, String string2) {
        this.recordEvent(Level.ERROR, marker, string2, null, null);
    }

    @Override
    public void error(Marker marker, String string2, Object object) {
        this.recordEvent(Level.ERROR, marker, string2, new Object[]{object}, null);
    }

    @Override
    public void error(Marker marker, String string2, Object object, Object object2) {
        this.recordEvent(Level.ERROR, marker, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void error(Marker marker, String string2, Throwable throwable) {
        this.recordEvent(Level.ERROR, marker, string2, null, throwable);
    }

    @Override
    public void error(Marker marker, String string2, Object ... objectArray) {
        this.recordEvent(Level.ERROR, marker, string2, objectArray, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void info(String string2) {
        this.recordEvent(Level.INFO, string2, null, null);
    }

    @Override
    public void info(String string2, Object object) {
        this.recordEvent(Level.INFO, string2, new Object[]{object}, null);
    }

    @Override
    public void info(String string2, Object object, Object object2) {
        this.recordEvent(Level.INFO, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void info(String string2, Throwable throwable) {
        this.recordEvent(Level.INFO, string2, null, throwable);
    }

    @Override
    public void info(String string2, Object ... objectArray) {
        this.recordEvent(Level.INFO, string2, objectArray, null);
    }

    @Override
    public void info(Marker marker, String string2) {
        this.recordEvent(Level.INFO, marker, string2, null, null);
    }

    @Override
    public void info(Marker marker, String string2, Object object) {
        this.recordEvent(Level.INFO, marker, string2, new Object[]{object}, null);
    }

    @Override
    public void info(Marker marker, String string2, Object object, Object object2) {
        this.recordEvent(Level.INFO, marker, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void info(Marker marker, String string2, Throwable throwable) {
        this.recordEvent(Level.INFO, marker, string2, null, throwable);
    }

    @Override
    public void info(Marker marker, String string2, Object ... objectArray) {
        this.recordEvent(Level.INFO, marker, string2, objectArray, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return true;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return true;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    @Override
    public void trace(String string2) {
        this.recordEvent(Level.TRACE, string2, null, null);
    }

    @Override
    public void trace(String string2, Object object) {
        this.recordEvent(Level.TRACE, string2, new Object[]{object}, null);
    }

    @Override
    public void trace(String string2, Object object, Object object2) {
        this.recordEvent(Level.TRACE, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void trace(String string2, Throwable throwable) {
        this.recordEvent(Level.TRACE, string2, null, throwable);
    }

    @Override
    public void trace(String string2, Object ... objectArray) {
        this.recordEvent(Level.TRACE, string2, objectArray, null);
    }

    @Override
    public void trace(Marker marker, String string2) {
        this.recordEvent(Level.TRACE, marker, string2, null, null);
    }

    @Override
    public void trace(Marker marker, String string2, Object object) {
        this.recordEvent(Level.TRACE, marker, string2, new Object[]{object}, null);
    }

    @Override
    public void trace(Marker marker, String string2, Object object, Object object2) {
        this.recordEvent(Level.TRACE, marker, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void trace(Marker marker, String string2, Throwable throwable) {
        this.recordEvent(Level.TRACE, marker, string2, null, throwable);
    }

    @Override
    public void trace(Marker marker, String string2, Object ... objectArray) {
        this.recordEvent(Level.TRACE, marker, string2, objectArray, null);
    }

    @Override
    public void warn(String string2) {
        this.recordEvent(Level.WARN, string2, null, null);
    }

    @Override
    public void warn(String string2, Object object) {
        this.recordEvent(Level.WARN, string2, new Object[]{object}, null);
    }

    @Override
    public void warn(String string2, Object object, Object object2) {
        this.recordEvent(Level.WARN, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void warn(String string2, Throwable throwable) {
        this.recordEvent(Level.WARN, string2, null, throwable);
    }

    @Override
    public void warn(String string2, Object ... objectArray) {
        this.recordEvent(Level.WARN, string2, objectArray, null);
    }

    @Override
    public void warn(Marker marker, String string2) {
        this.recordEvent(Level.WARN, string2, null, null);
    }

    @Override
    public void warn(Marker marker, String string2, Object object) {
        this.recordEvent(Level.WARN, string2, new Object[]{object}, null);
    }

    @Override
    public void warn(Marker marker, String string2, Object object, Object object2) {
        this.recordEvent(Level.WARN, marker, string2, new Object[]{object, object2}, null);
    }

    @Override
    public void warn(Marker marker, String string2, Throwable throwable) {
        this.recordEvent(Level.WARN, marker, string2, null, throwable);
    }

    @Override
    public void warn(Marker marker, String string2, Object ... objectArray) {
        this.recordEvent(Level.WARN, marker, string2, objectArray, null);
    }
}

