/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Marker;

public class BasicMarker
implements Marker {
    private static String CLOSE = " ]";
    private static String OPEN = "[ ";
    private static String SEP = ", ";
    private static final long serialVersionUID = -2849567615646933777L;
    private final String name;
    private List<Marker> referenceList = new CopyOnWriteArrayList<Marker>();

    BasicMarker(String string2) {
        if (string2 != null) {
            this.name = string2;
            return;
        }
        throw new IllegalArgumentException("A marker name cannot be null");
    }

    @Override
    public void add(Marker marker) {
        if (marker != null) {
            if (this.contains(marker)) {
                return;
            }
            if (marker.contains(this)) {
                return;
            }
            this.referenceList.add(marker);
            return;
        }
        throw new IllegalArgumentException("A null value cannot be added to a Marker as reference.");
    }

    @Override
    public boolean contains(String string2) {
        if (string2 != null) {
            if (this.name.equals(string2)) {
                return true;
            }
            if (this.hasReferences()) {
                Iterator<Marker> iterator2 = this.referenceList.iterator();
                while (iterator2.hasNext()) {
                    if (!iterator2.next().contains(string2)) continue;
                    return true;
                }
            }
            return false;
        }
        throw new IllegalArgumentException("Other cannot be null");
    }

    @Override
    public boolean contains(Marker marker) {
        if (marker != null) {
            if (this.equals(marker)) {
                return true;
            }
            if (this.hasReferences()) {
                Iterator<Marker> iterator2 = this.referenceList.iterator();
                while (iterator2.hasNext()) {
                    if (!iterator2.next().contains(marker)) continue;
                    return true;
                }
            }
            return false;
        }
        throw new IllegalArgumentException("Other cannot be null");
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Marker)) {
            return false;
        }
        object = (Marker)object;
        return this.name.equals(object.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasChildren() {
        return this.hasReferences();
    }

    @Override
    public boolean hasReferences() {
        boolean bl = this.referenceList.size() > 0;
        return bl;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.referenceList.iterator();
    }

    @Override
    public boolean remove(Marker marker) {
        return this.referenceList.remove(marker);
    }

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        Iterator<Marker> iterator2 = this.iterator();
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        stringBuilder.append(' ');
        stringBuilder.append(OPEN);
        while (iterator2.hasNext()) {
            stringBuilder.append(iterator2.next().getName());
            if (!iterator2.hasNext()) continue;
            stringBuilder.append(SEP);
        }
        stringBuilder.append(CLOSE);
        return stringBuilder.toString();
    }
}

