/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.Util;

public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static final FormattingTuple arrayFormat(String string2, Object[] objectArray) {
        Throwable throwable = MessageFormatter.getThrowableCandidate(objectArray);
        Object[] objectArray2 = objectArray;
        if (throwable != null) {
            objectArray2 = MessageFormatter.trimmedCopy(objectArray);
        }
        return MessageFormatter.arrayFormat(string2, objectArray2, throwable);
    }

    public static final FormattingTuple arrayFormat(String string2, Object[] objectArray, Throwable throwable) {
        if (string2 == null) {
            return new FormattingTuple(null, objectArray, throwable);
        }
        if (objectArray == null) {
            return new FormattingTuple(string2);
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 50);
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = string2.indexOf(DELIM_STR, n);
            if (n2 == -1) {
                if (n == 0) {
                    return new FormattingTuple(string2, objectArray, throwable);
                }
                stringBuilder.append(string2, n, string2.length());
                return new FormattingTuple(stringBuilder.toString(), objectArray, throwable);
            }
            if (MessageFormatter.isEscapedDelimeter(string2, n2)) {
                if (!MessageFormatter.isDoubleEscaped(string2, n2)) {
                    --i;
                    stringBuilder.append(string2, n, n2 - 1);
                    stringBuilder.append('{');
                    n = n2 + 1;
                    continue;
                }
                stringBuilder.append(string2, n, n2 - 1);
                MessageFormatter.deeplyAppendParameter(stringBuilder, objectArray[i], new HashMap<Object[], Object>());
            } else {
                stringBuilder.append(string2, n, n2);
                MessageFormatter.deeplyAppendParameter(stringBuilder, objectArray[i], new HashMap<Object[], Object>());
            }
            n = n2 + 2;
        }
        stringBuilder.append(string2, n, string2.length());
        return new FormattingTuple(stringBuilder.toString(), objectArray, throwable);
    }

    private static void booleanArrayAppend(StringBuilder stringBuilder, boolean[] blArray) {
        stringBuilder.append('[');
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(blArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void byteArrayAppend(StringBuilder stringBuilder, byte[] byArray) {
        stringBuilder.append('[');
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(byArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void charArrayAppend(StringBuilder stringBuilder, char[] cArray) {
        stringBuilder.append('[');
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(cArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void deeplyAppendParameter(StringBuilder stringBuilder, Object object, Map<Object[], Object> map) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (!object.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(stringBuilder, object);
        } else if (object instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(stringBuilder, (boolean[])object);
        } else if (object instanceof byte[]) {
            MessageFormatter.byteArrayAppend(stringBuilder, (byte[])object);
        } else if (object instanceof char[]) {
            MessageFormatter.charArrayAppend(stringBuilder, (char[])object);
        } else if (object instanceof short[]) {
            MessageFormatter.shortArrayAppend(stringBuilder, (short[])object);
        } else if (object instanceof int[]) {
            MessageFormatter.intArrayAppend(stringBuilder, (int[])object);
        } else if (object instanceof long[]) {
            MessageFormatter.longArrayAppend(stringBuilder, (long[])object);
        } else if (object instanceof float[]) {
            MessageFormatter.floatArrayAppend(stringBuilder, (float[])object);
        } else if (object instanceof double[]) {
            MessageFormatter.doubleArrayAppend(stringBuilder, (double[])object);
        } else {
            MessageFormatter.objectArrayAppend(stringBuilder, (Object[])object, map);
        }
    }

    private static void doubleArrayAppend(StringBuilder stringBuilder, double[] dArray) {
        stringBuilder.append('[');
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(dArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void floatArrayAppend(StringBuilder stringBuilder, float[] fArray) {
        stringBuilder.append('[');
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(fArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    public static final FormattingTuple format(String string2, Object object) {
        return MessageFormatter.arrayFormat(string2, new Object[]{object});
    }

    public static final FormattingTuple format(String string2, Object object, Object object2) {
        return MessageFormatter.arrayFormat(string2, new Object[]{object, object2});
    }

    static final Throwable getThrowableCandidate(Object[] object) {
        if (object != null && ((Object[])object).length != 0 && (object = object[((Object[])object).length - 1]) instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }

    private static void intArrayAppend(StringBuilder stringBuilder, int[] nArray) {
        stringBuilder.append('[');
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(nArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    static final boolean isDoubleEscaped(String string2, int n) {
        return n >= 2 && string2.charAt(n - 2) == '\\';
    }

    static final boolean isEscapedDelimeter(String string2, int n) {
        if (n == 0) {
            return false;
        }
        return string2.charAt(n - 1) == '\\';
    }

    private static void longArrayAppend(StringBuilder stringBuilder, long[] lArray) {
        stringBuilder.append('[');
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(lArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void objectArrayAppend(StringBuilder stringBuilder, Object[] objectArray, Map<Object[], Object> map) {
        stringBuilder.append('[');
        if (!map.containsKey(objectArray)) {
            map.put(objectArray, null);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                MessageFormatter.deeplyAppendParameter(stringBuilder, objectArray[i], map);
                if (i == n - 1) continue;
                stringBuilder.append(", ");
            }
            map.remove(objectArray);
        } else {
            stringBuilder.append("...");
        }
        stringBuilder.append(']');
    }

    private static void safeObjectAppend(StringBuilder stringBuilder, Object object) {
        try {
            stringBuilder.append(object.toString());
        }
        catch (Throwable throwable) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("SLF4J: Failed toString() invocation on an object of type [");
            stringBuilder2.append(object.getClass().getName());
            stringBuilder2.append("]");
            Util.report(stringBuilder2.toString(), throwable);
            stringBuilder.append("[FAILED toString()]");
        }
    }

    private static void shortArrayAppend(StringBuilder stringBuilder, short[] sArray) {
        stringBuilder.append('[');
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(sArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static Object[] trimmedCopy(Object[] objectArray) {
        if (objectArray != null && objectArray.length != 0) {
            int n = objectArray.length - 1;
            Object[] objectArray2 = new Object[n];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            return objectArray2;
        }
        throw new IllegalStateException("non-sensical empty or null argument array");
    }
}

