/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.EventRecodingLogger;
import org.slf4j.event.LoggingEvent;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.NOPLogger;

public class SubstituteLogger
implements Logger {
    private volatile Logger _delegate;
    private final boolean createdPostInitialization;
    private Boolean delegateEventAware;
    private Queue<SubstituteLoggingEvent> eventQueue;
    private EventRecodingLogger eventRecodingLogger;
    private Method logMethodCache;
    private final String name;

    public SubstituteLogger(String string2, Queue<SubstituteLoggingEvent> queue, boolean bl) {
        this.name = string2;
        this.eventQueue = queue;
        this.createdPostInitialization = bl;
    }

    private Logger getEventRecordingLogger() {
        if (this.eventRecodingLogger == null) {
            this.eventRecodingLogger = new EventRecodingLogger(this, this.eventQueue);
        }
        return this.eventRecodingLogger;
    }

    @Override
    public void debug(String string2) {
        this.delegate().debug(string2);
    }

    @Override
    public void debug(String string2, Object object) {
        this.delegate().debug(string2, object);
    }

    @Override
    public void debug(String string2, Object object, Object object2) {
        this.delegate().debug(string2, object, object2);
    }

    @Override
    public void debug(String string2, Throwable throwable) {
        this.delegate().debug(string2, throwable);
    }

    @Override
    public void debug(String string2, Object ... objectArray) {
        this.delegate().debug(string2, objectArray);
    }

    @Override
    public void debug(Marker marker, String string2) {
        this.delegate().debug(marker, string2);
    }

    @Override
    public void debug(Marker marker, String string2, Object object) {
        this.delegate().debug(marker, string2, object);
    }

    @Override
    public void debug(Marker marker, String string2, Object object, Object object2) {
        this.delegate().debug(marker, string2, object, object2);
    }

    @Override
    public void debug(Marker marker, String string2, Throwable throwable) {
        this.delegate().debug(marker, string2, throwable);
    }

    @Override
    public void debug(Marker marker, String string2, Object ... objectArray) {
        this.delegate().debug(marker, string2, objectArray);
    }

    Logger delegate() {
        if (this._delegate != null) {
            return this._delegate;
        }
        if (this.createdPostInitialization) {
            return NOPLogger.NOP_LOGGER;
        }
        return this.getEventRecordingLogger();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (SubstituteLogger)object;
            return this.name.equals(((SubstituteLogger)object).name);
        }
        return false;
    }

    @Override
    public void error(String string2) {
        this.delegate().error(string2);
    }

    @Override
    public void error(String string2, Object object) {
        this.delegate().error(string2, object);
    }

    @Override
    public void error(String string2, Object object, Object object2) {
        this.delegate().error(string2, object, object2);
    }

    @Override
    public void error(String string2, Throwable throwable) {
        this.delegate().error(string2, throwable);
    }

    @Override
    public void error(String string2, Object ... objectArray) {
        this.delegate().error(string2, objectArray);
    }

    @Override
    public void error(Marker marker, String string2) {
        this.delegate().error(marker, string2);
    }

    @Override
    public void error(Marker marker, String string2, Object object) {
        this.delegate().error(marker, string2, object);
    }

    @Override
    public void error(Marker marker, String string2, Object object, Object object2) {
        this.delegate().error(marker, string2, object, object2);
    }

    @Override
    public void error(Marker marker, String string2, Throwable throwable) {
        this.delegate().error(marker, string2, throwable);
    }

    @Override
    public void error(Marker marker, String string2, Object ... objectArray) {
        this.delegate().error(marker, string2, objectArray);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void info(String string2) {
        this.delegate().info(string2);
    }

    @Override
    public void info(String string2, Object object) {
        this.delegate().info(string2, object);
    }

    @Override
    public void info(String string2, Object object, Object object2) {
        this.delegate().info(string2, object, object2);
    }

    @Override
    public void info(String string2, Throwable throwable) {
        this.delegate().info(string2, throwable);
    }

    @Override
    public void info(String string2, Object ... objectArray) {
        this.delegate().info(string2, objectArray);
    }

    @Override
    public void info(Marker marker, String string2) {
        this.delegate().info(marker, string2);
    }

    @Override
    public void info(Marker marker, String string2, Object object) {
        this.delegate().info(marker, string2, object);
    }

    @Override
    public void info(Marker marker, String string2, Object object, Object object2) {
        this.delegate().info(marker, string2, object, object2);
    }

    @Override
    public void info(Marker marker, String string2, Throwable throwable) {
        this.delegate().info(marker, string2, throwable);
    }

    @Override
    public void info(Marker marker, String string2, Object ... objectArray) {
        this.delegate().info(marker, string2, objectArray);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate().isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.delegate().isDebugEnabled(marker);
    }

    public boolean isDelegateEventAware() {
        Boolean bl = this.delegateEventAware;
        if (bl != null) {
            return bl;
        }
        try {
            this.logMethodCache = this._delegate.getClass().getMethod("log", LoggingEvent.class);
            this.delegateEventAware = Boolean.TRUE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.delegateEventAware = Boolean.FALSE;
        }
        return this.delegateEventAware;
    }

    public boolean isDelegateNOP() {
        return this._delegate instanceof NOPLogger;
    }

    public boolean isDelegateNull() {
        boolean bl = this._delegate == null;
        return bl;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate().isErrorEnabled();
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.delegate().isErrorEnabled(marker);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate().isInfoEnabled();
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.delegate().isInfoEnabled(marker);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate().isTraceEnabled();
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.delegate().isTraceEnabled(marker);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate().isWarnEnabled();
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.delegate().isWarnEnabled(marker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void log(LoggingEvent loggingEvent) {
        if (!this.isDelegateEventAware()) return;
        try {
            this.logMethodCache.invoke((Object)this._delegate, loggingEvent);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return;
        }
    }

    public void setDelegate(Logger logger) {
        this._delegate = logger;
    }

    @Override
    public void trace(String string2) {
        this.delegate().trace(string2);
    }

    @Override
    public void trace(String string2, Object object) {
        this.delegate().trace(string2, object);
    }

    @Override
    public void trace(String string2, Object object, Object object2) {
        this.delegate().trace(string2, object, object2);
    }

    @Override
    public void trace(String string2, Throwable throwable) {
        this.delegate().trace(string2, throwable);
    }

    @Override
    public void trace(String string2, Object ... objectArray) {
        this.delegate().trace(string2, objectArray);
    }

    @Override
    public void trace(Marker marker, String string2) {
        this.delegate().trace(marker, string2);
    }

    @Override
    public void trace(Marker marker, String string2, Object object) {
        this.delegate().trace(marker, string2, object);
    }

    @Override
    public void trace(Marker marker, String string2, Object object, Object object2) {
        this.delegate().trace(marker, string2, object, object2);
    }

    @Override
    public void trace(Marker marker, String string2, Throwable throwable) {
        this.delegate().trace(marker, string2, throwable);
    }

    @Override
    public void trace(Marker marker, String string2, Object ... objectArray) {
        this.delegate().trace(marker, string2, objectArray);
    }

    @Override
    public void warn(String string2) {
        this.delegate().warn(string2);
    }

    @Override
    public void warn(String string2, Object object) {
        this.delegate().warn(string2, object);
    }

    @Override
    public void warn(String string2, Object object, Object object2) {
        this.delegate().warn(string2, object, object2);
    }

    @Override
    public void warn(String string2, Throwable throwable) {
        this.delegate().warn(string2, throwable);
    }

    @Override
    public void warn(String string2, Object ... objectArray) {
        this.delegate().warn(string2, objectArray);
    }

    @Override
    public void warn(Marker marker, String string2) {
        this.delegate().warn(marker, string2);
    }

    @Override
    public void warn(Marker marker, String string2, Object object) {
        this.delegate().warn(marker, string2, object);
    }

    @Override
    public void warn(Marker marker, String string2, Object object, Object object2) {
        this.delegate().warn(marker, string2, object, object2);
    }

    @Override
    public void warn(Marker marker, String string2, Throwable throwable) {
        this.delegate().warn(marker, string2, throwable);
    }

    @Override
    public void warn(Marker marker, String string2, Object ... objectArray) {
        this.delegate().warn(marker, string2, objectArray);
    }
}

