/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.SubstituteLogger;

public class SubstituteLoggerFactory
implements ILoggerFactory {
    final LinkedBlockingQueue<SubstituteLoggingEvent> eventQueue;
    final Map<String, SubstituteLogger> loggers = new HashMap<String, SubstituteLogger>();
    boolean postInitialization = false;

    public SubstituteLoggerFactory() {
        this.eventQueue = new LinkedBlockingQueue();
    }

    public void clear() {
        this.loggers.clear();
        this.eventQueue.clear();
    }

    public LinkedBlockingQueue<SubstituteLoggingEvent> getEventQueue() {
        return this.eventQueue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Logger getLogger(String string2) {
        synchronized (this) {
            SubstituteLogger substituteLogger;
            SubstituteLogger substituteLogger2 = substituteLogger = this.loggers.get(string2);
            if (substituteLogger == null) {
                substituteLogger2 = new SubstituteLogger(string2, this.eventQueue, this.postInitialization);
                this.loggers.put(string2, substituteLogger2);
            }
            return substituteLogger2;
        }
    }

    public List<String> getLoggerNames() {
        return new ArrayList<String>(this.loggers.keySet());
    }

    public List<SubstituteLogger> getLoggers() {
        return new ArrayList<SubstituteLogger>(this.loggers.values());
    }

    public void postInitialization() {
        this.postInitialization = true;
    }
}

