/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.io.PrintStream;

public final class Util {
    private static ClassContextSecurityManager SECURITY_MANAGER;
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;

    private Util() {
    }

    public static Class<?> getCallingClass() {
        int n;
        Class<?>[] classArray = Util.getSecurityManager();
        if (classArray == null) {
            return null;
        }
        classArray = classArray.getClassContext();
        String string2 = Util.class.getName();
        for (n = 0; n < classArray.length && !string2.equals(classArray[n].getName()); ++n) {
        }
        if (n < classArray.length && (n += 2) < classArray.length) {
            return classArray[n];
        }
        throw new IllegalStateException("Failed to find org.slf4j.helpers.Util or its caller in the stack; this should not happen");
    }

    private static ClassContextSecurityManager getSecurityManager() {
        ClassContextSecurityManager classContextSecurityManager = SECURITY_MANAGER;
        if (classContextSecurityManager != null) {
            return classContextSecurityManager;
        }
        if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            return null;
        }
        SECURITY_MANAGER = classContextSecurityManager = Util.safeCreateSecurityManager();
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
        return classContextSecurityManager;
    }

    public static final void report(String string2) {
        PrintStream printStream = System.err;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SLF4J: ");
        stringBuilder.append(string2);
        printStream.println(stringBuilder.toString());
    }

    public static final void report(String string2, Throwable throwable) {
        System.err.println(string2);
        System.err.println("Reported exception:");
        throwable.printStackTrace();
    }

    private static ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            ClassContextSecurityManager classContextSecurityManager = new ClassContextSecurityManager();
            return classContextSecurityManager;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static boolean safeGetBooleanSystemProperty(String string2) {
        if ((string2 = Util.safeGetSystemProperty(string2)) == null) {
            return false;
        }
        return string2.equalsIgnoreCase("true");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String safeGetSystemProperty(String string2) {
        if (string2 == null) throw new IllegalArgumentException("null input");
        Object var1_2 = null;
        try {
            return System.getProperty(string2);
        }
        catch (SecurityException securityException) {
            return var1_2;
        }
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        private ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

