/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import android.util.Log;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

class AndroidLoggerAdapter
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -1227274521521287937L;

    AndroidLoggerAdapter(String string2) {
        this.name = string2;
    }

    private void formatAndLog(int n, String object, Object ... objectArray) {
        if (this.isLoggable(n)) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.logInternal(n, ((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    private boolean isLoggable(int n) {
        return Log.isLoggable((String)this.name, (int)n);
    }

    private void log(int n, String string2, Throwable throwable) {
        if (this.isLoggable(n)) {
            this.logInternal(n, string2, throwable);
        }
    }

    private void logInternal(int n, String string2, Throwable throwable) {
        CharSequence charSequence = string2;
        if (throwable != null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append('\n');
            ((StringBuilder)charSequence).append(Log.getStackTraceString((Throwable)throwable));
            charSequence = ((StringBuilder)charSequence).toString();
        }
        Log.println((int)n, (String)this.name, (String)charSequence);
    }

    @Override
    public void debug(String string2) {
        this.log(3, string2, null);
    }

    @Override
    public void debug(String string2, Object object) {
        this.formatAndLog(3, string2, object);
    }

    @Override
    public void debug(String string2, Object object, Object object2) {
        this.formatAndLog(3, string2, object, object2);
    }

    @Override
    public void debug(String string2, Throwable throwable) {
        this.log(2, string2, throwable);
    }

    @Override
    public void debug(String string2, Object ... objectArray) {
        this.formatAndLog(3, string2, objectArray);
    }

    @Override
    public void error(String string2) {
        this.log(6, string2, null);
    }

    @Override
    public void error(String string2, Object object) {
        this.formatAndLog(6, string2, object);
    }

    @Override
    public void error(String string2, Object object, Object object2) {
        this.formatAndLog(6, string2, object, object2);
    }

    @Override
    public void error(String string2, Throwable throwable) {
        this.log(6, string2, throwable);
    }

    @Override
    public void error(String string2, Object ... objectArray) {
        this.formatAndLog(6, string2, objectArray);
    }

    @Override
    public void info(String string2) {
        this.log(4, string2, null);
    }

    @Override
    public void info(String string2, Object object) {
        this.formatAndLog(4, string2, object);
    }

    @Override
    public void info(String string2, Object object, Object object2) {
        this.formatAndLog(4, string2, object, object2);
    }

    @Override
    public void info(String string2, Throwable throwable) {
        this.log(4, string2, throwable);
    }

    @Override
    public void info(String string2, Object ... objectArray) {
        this.formatAndLog(4, string2, objectArray);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLoggable(3);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLoggable(6);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLoggable(4);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLoggable(2);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLoggable(5);
    }

    @Override
    public void trace(String string2) {
        this.log(2, string2, null);
    }

    @Override
    public void trace(String string2, Object object) {
        this.formatAndLog(2, string2, object);
    }

    @Override
    public void trace(String string2, Object object, Object object2) {
        this.formatAndLog(2, string2, object, object2);
    }

    @Override
    public void trace(String string2, Throwable throwable) {
        this.log(2, string2, throwable);
    }

    @Override
    public void trace(String string2, Object ... objectArray) {
        this.formatAndLog(2, string2, objectArray);
    }

    @Override
    public void warn(String string2) {
        this.log(5, string2, null);
    }

    @Override
    public void warn(String string2, Object object) {
        this.formatAndLog(5, string2, object);
    }

    @Override
    public void warn(String string2, Object object, Object object2) {
        this.formatAndLog(5, string2, object, object2);
    }

    @Override
    public void warn(String string2, Throwable throwable) {
        this.log(5, string2, throwable);
    }

    @Override
    public void warn(String string2, Object ... objectArray) {
        this.formatAndLog(5, string2, objectArray);
    }
}

