/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Locale;
import pl.droidsonroids.gif.GifInfoHandle;

public class GifAnimationMetaData
implements Serializable,
Parcelable {
    public static final Parcelable.Creator<GifAnimationMetaData> CREATOR = new Parcelable.Creator<GifAnimationMetaData>(){

        public GifAnimationMetaData createFromParcel(Parcel parcel) {
            return new GifAnimationMetaData(parcel);
        }

        public GifAnimationMetaData[] newArray(int n) {
            return new GifAnimationMetaData[n];
        }
    };
    private static final long serialVersionUID = 5692363926580237325L;
    private final int mDuration;
    private final int mHeight;
    private final int mImageCount;
    private final int mLoopCount;
    private final int mWidth;

    public GifAnimationMetaData(ContentResolver contentResolver, Uri uri) throws IOException {
        this(GifInfoHandle.openUri(contentResolver, uri, true));
    }

    public GifAnimationMetaData(AssetFileDescriptor assetFileDescriptor) throws IOException {
        this(new GifInfoHandle(assetFileDescriptor, true));
    }

    public GifAnimationMetaData(AssetManager assetManager, String string2) throws IOException {
        this(assetManager.openFd(string2));
    }

    public GifAnimationMetaData(Resources resources, int n) throws Resources.NotFoundException, IOException {
        this(resources.openRawResourceFd(n));
    }

    private GifAnimationMetaData(Parcel parcel) {
        this.mLoopCount = parcel.readInt();
        this.mDuration = parcel.readInt();
        this.mHeight = parcel.readInt();
        this.mWidth = parcel.readInt();
        this.mImageCount = parcel.readInt();
    }

    public GifAnimationMetaData(File file) throws IOException {
        this(file.getPath());
    }

    public GifAnimationMetaData(FileDescriptor fileDescriptor) throws IOException {
        this(new GifInfoHandle(fileDescriptor, true));
    }

    public GifAnimationMetaData(InputStream inputStream) throws IOException {
        this(new GifInfoHandle(inputStream, true));
    }

    public GifAnimationMetaData(String string2) throws IOException {
        this(new GifInfoHandle(string2, true));
    }

    public GifAnimationMetaData(ByteBuffer byteBuffer) throws IOException {
        this(new GifInfoHandle(byteBuffer, true));
    }

    private GifAnimationMetaData(GifInfoHandle gifInfoHandle) {
        this.mLoopCount = gifInfoHandle.getLoopCount();
        this.mDuration = gifInfoHandle.getDuration();
        this.mWidth = gifInfoHandle.getWidth();
        this.mHeight = gifInfoHandle.getHeight();
        this.mImageCount = gifInfoHandle.getNumberOfFrames();
        gifInfoHandle.recycle();
    }

    public GifAnimationMetaData(byte[] byArray) throws IOException {
        this(new GifInfoHandle(byArray, true));
    }

    public int describeContents() {
        return 0;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getLoopCount() {
        return this.mLoopCount;
    }

    public int getNumberOfFrames() {
        return this.mImageCount;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public boolean isAnimated() {
        int n = this.mImageCount;
        boolean bl = true;
        if (n <= 1 || this.mDuration <= 0) {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        int n = this.mLoopCount;
        CharSequence charSequence = n == 0 ? "Infinity" : Integer.toString(n);
        String string2 = String.format(Locale.ENGLISH, "GIF: size: %dx%d, frames: %d, loops: %s, duration: %d", this.mWidth, this.mHeight, this.mImageCount, charSequence, this.mDuration);
        charSequence = string2;
        if (this.isAnimated()) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Animated ");
            ((StringBuilder)charSequence).append(string2);
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mLoopCount);
        parcel.writeInt(this.mDuration);
        parcel.writeInt(this.mHeight);
        parcel.writeInt(this.mWidth);
        parcel.writeInt(this.mImageCount);
    }
}

