/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.graphics.Bitmap;
import java.io.IOException;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifOptions;
import pl.droidsonroids.gif.InputSource;

public class GifDecoder {
    private final GifInfoHandle mGifInfoHandle;

    public GifDecoder(InputSource inputSource) throws IOException {
        this(inputSource, null);
    }

    public GifDecoder(InputSource object, GifOptions gifOptions) throws IOException {
        this.mGifInfoHandle = object = ((InputSource)object).open();
        if (gifOptions != null) {
            ((GifInfoHandle)object).setOptions(gifOptions.inSampleSize, gifOptions.inIsOpaque);
        }
    }

    private void checkBuffer(Bitmap bitmap) {
        if (!bitmap.isRecycled()) {
            if (bitmap.getWidth() >= this.mGifInfoHandle.getWidth() && bitmap.getHeight() >= this.mGifInfoHandle.getHeight()) {
                return;
            }
            throw new IllegalArgumentException("Bitmap ia too small, size must be greater than or equal to GIF size");
        }
        throw new IllegalArgumentException("Bitmap is recycled");
    }

    public long getAllocationByteCount() {
        return this.mGifInfoHandle.getAllocationByteCount();
    }

    public String getComment() {
        return this.mGifInfoHandle.getComment();
    }

    public int getDuration() {
        return this.mGifInfoHandle.getDuration();
    }

    public int getFrameDuration(int n) {
        return this.mGifInfoHandle.getFrameDuration(n);
    }

    public int getHeight() {
        return this.mGifInfoHandle.getHeight();
    }

    public int getLoopCount() {
        return this.mGifInfoHandle.getLoopCount();
    }

    public int getNumberOfFrames() {
        return this.mGifInfoHandle.getNumberOfFrames();
    }

    public long getSourceLength() {
        return this.mGifInfoHandle.getSourceLength();
    }

    public int getWidth() {
        return this.mGifInfoHandle.getWidth();
    }

    public boolean isAnimated() {
        int n = this.mGifInfoHandle.getNumberOfFrames();
        boolean bl = true;
        if (n <= 1 || this.getDuration() <= 0) {
            bl = false;
        }
        return bl;
    }

    public void recycle() {
        this.mGifInfoHandle.recycle();
    }

    public void seekToFrame(int n, Bitmap bitmap) {
        this.checkBuffer(bitmap);
        this.mGifInfoHandle.seekToFrame(n, bitmap);
    }

    public void seekToTime(int n, Bitmap bitmap) {
        this.checkBuffer(bitmap);
        this.mGifInfoHandle.seekToTime(n, bitmap);
    }
}

