/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.SystemClock;
import android.widget.MediaController;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import pl.droidsonroids.gif.AnimationListener;
import pl.droidsonroids.gif.GifError;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifRenderingExecutor;
import pl.droidsonroids.gif.GifViewUtils;
import pl.droidsonroids.gif.InvalidationHandler;
import pl.droidsonroids.gif.RenderTask;
import pl.droidsonroids.gif.SafeRunnable;
import pl.droidsonroids.gif.transforms.CornerRadiusTransform;
import pl.droidsonroids.gif.transforms.Transform;

public class GifDrawable
extends Drawable
implements Animatable,
MediaController.MediaPlayerControl {
    final Bitmap mBuffer;
    private final Rect mDstRect;
    final ScheduledThreadPoolExecutor mExecutor;
    final InvalidationHandler mInvalidationHandler;
    final boolean mIsRenderingTriggeredOnDraw;
    volatile boolean mIsRunning = true;
    final ConcurrentLinkedQueue<AnimationListener> mListeners;
    final GifInfoHandle mNativeInfoHandle;
    long mNextFrameRenderTime = Long.MIN_VALUE;
    protected final Paint mPaint;
    private final RenderTask mRenderTask;
    ScheduledFuture<?> mRenderTaskSchedule;
    private int mScaledHeight;
    private int mScaledWidth;
    private final Rect mSrcRect;
    private ColorStateList mTint;
    private PorterDuffColorFilter mTintFilter;
    private PorterDuff.Mode mTintMode;
    private Transform mTransform;

    public GifDrawable(ContentResolver contentResolver, Uri uri) throws IOException {
        this(GifInfoHandle.openUri(contentResolver, uri, false), null, null, true);
    }

    public GifDrawable(AssetFileDescriptor assetFileDescriptor) throws IOException {
        this(new GifInfoHandle(assetFileDescriptor, false), null, null, true);
    }

    public GifDrawable(AssetManager assetManager, String string2) throws IOException {
        this(assetManager.openFd(string2));
    }

    public GifDrawable(Resources resources, int n) throws Resources.NotFoundException, IOException {
        this(resources.openRawResourceFd(n));
        float f = GifViewUtils.getDensityScale(resources, n);
        this.mScaledHeight = (int)((float)this.mNativeInfoHandle.getHeight() * f);
        this.mScaledWidth = (int)((float)this.mNativeInfoHandle.getWidth() * f);
    }

    public GifDrawable(File file) throws IOException {
        this(file.getPath());
    }

    public GifDrawable(FileDescriptor fileDescriptor) throws IOException {
        this(new GifInfoHandle(fileDescriptor, false), null, null, true);
    }

    public GifDrawable(InputStream inputStream) throws IOException {
        this(new GifInfoHandle(inputStream, false), null, null, true);
    }

    public GifDrawable(String string2) throws IOException {
        this(new GifInfoHandle(string2, false), null, null, true);
    }

    public GifDrawable(ByteBuffer byteBuffer) throws IOException {
        this(new GifInfoHandle(byteBuffer, false), null, null, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GifDrawable(GifInfoHandle gifInfoHandle, GifDrawable gifDrawable, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, boolean bl) {
        RenderTask renderTask;
        this.mDstRect = new Rect();
        this.mPaint = new Paint(6);
        this.mListeners = new ConcurrentLinkedQueue();
        this.mRenderTask = renderTask = new RenderTask(this);
        this.mIsRenderingTriggeredOnDraw = bl;
        if (scheduledThreadPoolExecutor == null) {
            scheduledThreadPoolExecutor = GifRenderingExecutor.getInstance();
        }
        this.mExecutor = scheduledThreadPoolExecutor;
        this.mNativeInfoHandle = gifInfoHandle;
        scheduledThreadPoolExecutor = null;
        Object var6_6 = null;
        if (gifDrawable != null) {
            GifInfoHandle gifInfoHandle2 = gifDrawable.mNativeInfoHandle;
            synchronized (gifInfoHandle2) {
                scheduledThreadPoolExecutor = var6_6;
                if (!gifDrawable.mNativeInfoHandle.isRecycled()) {
                    scheduledThreadPoolExecutor = var6_6;
                    if (gifDrawable.mNativeInfoHandle.getHeight() >= gifInfoHandle.getHeight()) {
                        scheduledThreadPoolExecutor = var6_6;
                        if (gifDrawable.mNativeInfoHandle.getWidth() >= gifInfoHandle.getWidth()) {
                            gifDrawable.shutdown();
                            scheduledThreadPoolExecutor = gifDrawable.mBuffer;
                            scheduledThreadPoolExecutor.eraseColor(0);
                        }
                    }
                }
            }
        }
        this.mBuffer = scheduledThreadPoolExecutor == null ? Bitmap.createBitmap((int)gifInfoHandle.getWidth(), (int)gifInfoHandle.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : scheduledThreadPoolExecutor;
        if (Build.VERSION.SDK_INT >= 12) {
            this.mBuffer.setHasAlpha(gifInfoHandle.isOpaque() ^ true);
        }
        this.mSrcRect = new Rect(0, 0, gifInfoHandle.getWidth(), gifInfoHandle.getHeight());
        this.mInvalidationHandler = new InvalidationHandler(this);
        renderTask.doWork();
        this.mScaledWidth = gifInfoHandle.getWidth();
        this.mScaledHeight = gifInfoHandle.getHeight();
    }

    public GifDrawable(byte[] byArray) throws IOException {
        this(new GifInfoHandle(byArray, false), null, null, true);
    }

    private void cancelPendingRenderTask() {
        ScheduledFuture<?> scheduledFuture = this.mRenderTaskSchedule;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.mInvalidationHandler.removeMessages(-1);
    }

    public static GifDrawable createFromResource(Resources object, int n) {
        try {
            object = new GifDrawable((Resources)object, n);
            return object;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void shutdown() {
        this.mIsRunning = false;
        this.mInvalidationHandler.removeMessages(-1);
        this.mNativeInfoHandle.recycle();
    }

    private PorterDuffColorFilter updateTintFilter(ColorStateList colorStateList, PorterDuff.Mode mode) {
        if (colorStateList != null && mode != null) {
            return new PorterDuffColorFilter(colorStateList.getColorForState(this.getState(), 0), mode);
        }
        return null;
    }

    public void addAnimationListener(AnimationListener animationListener) {
        this.mListeners.add(animationListener);
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        int n = this.getNumberOfFrames();
        boolean bl = true;
        if (n <= 1) {
            bl = false;
        }
        return bl;
    }

    public boolean canSeekForward() {
        int n = this.getNumberOfFrames();
        boolean bl = true;
        if (n <= 1) {
            bl = false;
        }
        return bl;
    }

    public void draw(Canvas canvas) {
        long l;
        boolean bl;
        if (this.mTintFilter != null && this.mPaint.getColorFilter() == null) {
            this.mPaint.setColorFilter((ColorFilter)this.mTintFilter);
            bl = true;
        } else {
            bl = false;
        }
        Transform transform = this.mTransform;
        if (transform == null) {
            canvas.drawBitmap(this.mBuffer, this.mSrcRect, this.mDstRect, this.mPaint);
        } else {
            transform.onDraw(canvas, this.mPaint, this.mBuffer);
        }
        if (bl) {
            this.mPaint.setColorFilter(null);
        }
        if (this.mIsRenderingTriggeredOnDraw && this.mIsRunning && (l = this.mNextFrameRenderTime) != Long.MIN_VALUE) {
            l = Math.max(0L, l - SystemClock.uptimeMillis());
            this.mNextFrameRenderTime = Long.MIN_VALUE;
            this.mExecutor.remove(this.mRenderTask);
            this.mRenderTaskSchedule = this.mExecutor.schedule(this.mRenderTask, l, TimeUnit.MILLISECONDS);
        }
    }

    public long getAllocationByteCount() {
        long l = this.mNativeInfoHandle.getAllocationByteCount();
        int n = Build.VERSION.SDK_INT >= 19 ? this.mBuffer.getAllocationByteCount() : this.mBuffer.getRowBytes() * this.mBuffer.getHeight();
        return l + (long)n;
    }

    public int getAlpha() {
        return this.mPaint.getAlpha();
    }

    public int getAudioSessionId() {
        return 0;
    }

    public int getBufferPercentage() {
        return 100;
    }

    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    public String getComment() {
        return this.mNativeInfoHandle.getComment();
    }

    public float getCornerRadius() {
        Transform transform = this.mTransform;
        if (transform instanceof CornerRadiusTransform) {
            return ((CornerRadiusTransform)transform).getCornerRadius();
        }
        return 0.0f;
    }

    public Bitmap getCurrentFrame() {
        Bitmap bitmap = this.mBuffer;
        bitmap = bitmap.copy(bitmap.getConfig(), this.mBuffer.isMutable());
        if (Build.VERSION.SDK_INT >= 12) {
            bitmap.setHasAlpha(this.mBuffer.hasAlpha());
        }
        return bitmap;
    }

    public int getCurrentFrameIndex() {
        return this.mNativeInfoHandle.getCurrentFrameIndex();
    }

    public int getCurrentLoop() {
        int n;
        int n2 = n = this.mNativeInfoHandle.getCurrentLoop();
        if (n != 0) {
            n2 = n < this.mNativeInfoHandle.getLoopCount() ? n : n - 1;
        }
        return n2;
    }

    public int getCurrentPosition() {
        return this.mNativeInfoHandle.getCurrentPosition();
    }

    public int getDuration() {
        return this.mNativeInfoHandle.getDuration();
    }

    public GifError getError() {
        return GifError.fromCode(this.mNativeInfoHandle.getNativeErrorCode());
    }

    public int getFrameByteCount() {
        return this.mBuffer.getRowBytes() * this.mBuffer.getHeight();
    }

    public int getFrameDuration(int n) {
        return this.mNativeInfoHandle.getFrameDuration(n);
    }

    public long getInputSourceByteCount() {
        return this.mNativeInfoHandle.getSourceLength();
    }

    public int getIntrinsicHeight() {
        return this.mScaledHeight;
    }

    public int getIntrinsicWidth() {
        return this.mScaledWidth;
    }

    public int getLoopCount() {
        return this.mNativeInfoHandle.getLoopCount();
    }

    public int getNumberOfFrames() {
        return this.mNativeInfoHandle.getNumberOfFrames();
    }

    public int getOpacity() {
        if (this.mNativeInfoHandle.isOpaque() && this.mPaint.getAlpha() >= 255) {
            return -1;
        }
        return -2;
    }

    public final Paint getPaint() {
        return this.mPaint;
    }

    public int getPixel(int n, int n2) {
        if (n < this.mNativeInfoHandle.getWidth()) {
            if (n2 < this.mNativeInfoHandle.getHeight()) {
                return this.mBuffer.getPixel(n, n2);
            }
            throw new IllegalArgumentException("y must be < height");
        }
        throw new IllegalArgumentException("x must be < width");
    }

    public void getPixels(int[] nArray) {
        this.mBuffer.getPixels(nArray, 0, this.mNativeInfoHandle.getWidth(), 0, 0, this.mNativeInfoHandle.getWidth(), this.mNativeInfoHandle.getHeight());
    }

    public Transform getTransform() {
        return this.mTransform;
    }

    public boolean isAnimationCompleted() {
        return this.mNativeInfoHandle.isAnimationCompleted();
    }

    public boolean isPlaying() {
        return this.mIsRunning;
    }

    public boolean isRecycled() {
        return this.mNativeInfoHandle.isRecycled();
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public boolean isStateful() {
        ColorStateList colorStateList;
        boolean bl = super.isStateful() || (colorStateList = this.mTint) != null && colorStateList.isStateful();
        return bl;
    }

    protected void onBoundsChange(Rect rect) {
        this.mDstRect.set(rect);
        Transform transform = this.mTransform;
        if (transform != null) {
            transform.onBoundsChange(rect);
        }
    }

    protected boolean onStateChange(int[] object) {
        PorterDuff.Mode mode;
        object = this.mTint;
        if (object != null && (mode = this.mTintMode) != null) {
            this.mTintFilter = this.updateTintFilter((ColorStateList)object, mode);
            return true;
        }
        return false;
    }

    public void pause() {
        this.stop();
    }

    public void recycle() {
        this.shutdown();
        this.mBuffer.recycle();
    }

    public boolean removeAnimationListener(AnimationListener animationListener) {
        return this.mListeners.remove(animationListener);
    }

    public void reset() {
        this.mExecutor.execute(new SafeRunnable(this){

            @Override
            public void doWork() {
                if (GifDrawable.this.mNativeInfoHandle.reset()) {
                    GifDrawable.this.start();
                }
            }
        });
    }

    public void seekTo(final int n) {
        if (n >= 0) {
            this.mExecutor.execute(new SafeRunnable(this){

                @Override
                public void doWork() {
                    GifDrawable.this.mNativeInfoHandle.seekToTime(n, GifDrawable.this.mBuffer);
                    this.mGifDrawable.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
                }
            });
            return;
        }
        throw new IllegalArgumentException("Position is not positive");
    }

    public void seekToFrame(final int n) {
        if (n >= 0) {
            this.mExecutor.execute(new SafeRunnable(this){

                @Override
                public void doWork() {
                    GifDrawable.this.mNativeInfoHandle.seekToFrame(n, GifDrawable.this.mBuffer);
                    GifDrawable.this.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
                }
            });
            return;
        }
        throw new IndexOutOfBoundsException("Frame index is not positive");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap seekToFrameAndGet(int n) {
        if (n >= 0) {
            Bitmap bitmap;
            GifInfoHandle gifInfoHandle = this.mNativeInfoHandle;
            synchronized (gifInfoHandle) {
                this.mNativeInfoHandle.seekToFrame(n, this.mBuffer);
                bitmap = this.getCurrentFrame();
            }
            this.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
            return bitmap;
        }
        throw new IndexOutOfBoundsException("Frame index is not positive");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap seekToPositionAndGet(int n) {
        if (n >= 0) {
            Bitmap bitmap;
            GifInfoHandle gifInfoHandle = this.mNativeInfoHandle;
            synchronized (gifInfoHandle) {
                this.mNativeInfoHandle.seekToTime(n, this.mBuffer);
                bitmap = this.getCurrentFrame();
            }
            this.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
            return bitmap;
        }
        throw new IllegalArgumentException("Position is not positive");
    }

    public void setAlpha(int n) {
        this.mPaint.setAlpha(n);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public void setCornerRadius(float f) {
        this.mTransform = new CornerRadiusTransform(f);
    }

    @Deprecated
    public void setDither(boolean bl) {
        this.mPaint.setDither(bl);
        this.invalidateSelf();
    }

    public void setFilterBitmap(boolean bl) {
        this.mPaint.setFilterBitmap(bl);
        this.invalidateSelf();
    }

    public void setLoopCount(int n) {
        this.mNativeInfoHandle.setLoopCount(n);
    }

    public void setSpeed(float f) {
        this.mNativeInfoHandle.setSpeedFactor(f);
    }

    public void setTintList(ColorStateList colorStateList) {
        this.mTint = colorStateList;
        this.mTintFilter = this.updateTintFilter(colorStateList, this.mTintMode);
        this.invalidateSelf();
    }

    public void setTintMode(PorterDuff.Mode mode) {
        this.mTintMode = mode;
        this.mTintFilter = this.updateTintFilter(this.mTint, mode);
        this.invalidateSelf();
    }

    public void setTransform(Transform transform) {
        this.mTransform = transform;
    }

    public boolean setVisible(boolean bl, boolean bl2) {
        boolean bl3 = super.setVisible(bl, bl2);
        if (!this.mIsRenderingTriggeredOnDraw) {
            if (bl) {
                if (bl2) {
                    this.reset();
                }
                if (bl3) {
                    this.start();
                }
            } else if (bl3) {
                this.stop();
            }
        }
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        synchronized (this) {
            if (this.mIsRunning) {
                return;
            }
            this.mIsRunning = true;
        }
        this.startAnimation(this.mNativeInfoHandle.restoreRemainder());
    }

    void startAnimation(long l) {
        if (this.mIsRenderingTriggeredOnDraw) {
            this.mNextFrameRenderTime = 0L;
            this.mInvalidationHandler.sendEmptyMessageAtTime(-1, 0L);
        } else {
            this.cancelPendingRenderTask();
            this.mRenderTaskSchedule = this.mExecutor.schedule(this.mRenderTask, Math.max(l, 0L), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        synchronized (this) {
            if (!this.mIsRunning) {
                return;
            }
            this.mIsRunning = false;
        }
        this.cancelPendingRenderTask();
        this.mNativeInfoHandle.saveRemainder();
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "GIF: size: %dx%d, frames: %d, error: %d", this.mNativeInfoHandle.getWidth(), this.mNativeInfoHandle.getHeight(), this.mNativeInfoHandle.getNumberOfFrames(), this.mNativeInfoHandle.getNativeErrorCode());
    }
}

