/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifOptions;
import pl.droidsonroids.gif.InputSource;

public class GifDrawableBuilder {
    private ScheduledThreadPoolExecutor mExecutor;
    private InputSource mInputSource;
    private boolean mIsRenderingTriggeredOnDraw = true;
    private GifDrawable mOldDrawable;
    private GifOptions mOptions = new GifOptions();

    public GifDrawable build() throws IOException {
        InputSource inputSource = this.mInputSource;
        Objects.requireNonNull(inputSource, "Source is not set");
        return inputSource.build(this.mOldDrawable, this.mExecutor, this.mIsRenderingTriggeredOnDraw, this.mOptions);
    }

    public GifDrawableBuilder from(ContentResolver contentResolver, Uri uri) {
        this.mInputSource = new InputSource.UriSource(contentResolver, uri);
        return this;
    }

    public GifDrawableBuilder from(AssetFileDescriptor assetFileDescriptor) {
        this.mInputSource = new InputSource.AssetFileDescriptorSource(assetFileDescriptor);
        return this;
    }

    public GifDrawableBuilder from(AssetManager assetManager, String string2) {
        this.mInputSource = new InputSource.AssetSource(assetManager, string2);
        return this;
    }

    public GifDrawableBuilder from(Resources resources, int n) {
        this.mInputSource = new InputSource.ResourcesSource(resources, n);
        return this;
    }

    public GifDrawableBuilder from(File file) {
        this.mInputSource = new InputSource.FileSource(file);
        return this;
    }

    public GifDrawableBuilder from(FileDescriptor fileDescriptor) {
        this.mInputSource = new InputSource.FileDescriptorSource(fileDescriptor);
        return this;
    }

    public GifDrawableBuilder from(InputStream inputStream) {
        this.mInputSource = new InputSource.InputStreamSource(inputStream);
        return this;
    }

    public GifDrawableBuilder from(String string2) {
        this.mInputSource = new InputSource.FileSource(string2);
        return this;
    }

    public GifDrawableBuilder from(ByteBuffer byteBuffer) {
        this.mInputSource = new InputSource.DirectByteBufferSource(byteBuffer);
        return this;
    }

    public GifDrawableBuilder from(byte[] byArray) {
        this.mInputSource = new InputSource.ByteArraySource(byArray);
        return this;
    }

    public GifDrawableBuilder options(GifOptions gifOptions) {
        this.mOptions.setFrom(gifOptions);
        return this;
    }

    public GifDrawableBuilder renderingTriggeredOnDraw(boolean bl) {
        this.mIsRenderingTriggeredOnDraw = bl;
        return this;
    }

    public void sampleSize(int n) {
        this.mOptions.inSampleSize = n;
    }

    public GifDrawableBuilder setRenderingTriggeredOnDraw(boolean bl) {
        return this.renderingTriggeredOnDraw(bl);
    }

    public GifDrawableBuilder taskExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        this.mExecutor = scheduledThreadPoolExecutor;
        return this;
    }

    public GifDrawableBuilder threadPoolSize(int n) {
        this.mExecutor = new ScheduledThreadPoolExecutor(n);
        return this;
    }

    public GifDrawableBuilder with(GifDrawable gifDrawable) {
        this.mOldDrawable = gifDrawable;
        return this;
    }
}

