/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.Surface;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import pl.droidsonroids.gif.GifIOException;
import pl.droidsonroids.gif.LibraryLoader;

final class GifInfoHandle {
    static final GifInfoHandle NULL_INFO = new GifInfoHandle();
    private volatile long gifInfoPtr;

    static {
        LibraryLoader.loadLibrary(null, "pl_droidsonroids_gif");
    }

    private GifInfoHandle() {
    }

    GifInfoHandle(AssetFileDescriptor assetFileDescriptor, boolean bl) throws IOException {
        try {
            this.gifInfoPtr = GifInfoHandle.openFd(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), bl);
            return;
        }
        finally {
            assetFileDescriptor.close();
        }
    }

    GifInfoHandle(FileDescriptor fileDescriptor, boolean bl) throws GifIOException {
        this.gifInfoPtr = GifInfoHandle.openFd(fileDescriptor, 0L, bl);
    }

    GifInfoHandle(InputStream inputStream, boolean bl) throws GifIOException {
        if (inputStream.markSupported()) {
            this.gifInfoPtr = GifInfoHandle.openStream(inputStream, bl);
            return;
        }
        throw new IllegalArgumentException("InputStream does not support marking");
    }

    GifInfoHandle(String string2, boolean bl) throws GifIOException {
        this.gifInfoPtr = GifInfoHandle.openFile(string2, bl);
    }

    GifInfoHandle(ByteBuffer byteBuffer, boolean bl) throws GifIOException {
        this.gifInfoPtr = GifInfoHandle.openDirectByteBuffer(byteBuffer, bl);
    }

    GifInfoHandle(byte[] byArray, boolean bl) throws GifIOException {
        this.gifInfoPtr = GifInfoHandle.openByteArray(byArray, bl);
    }

    private static native void bindSurface(long var0, Surface var2, long[] var3);

    private static native void free(long var0);

    private static native long getAllocationByteCount(long var0);

    private static native String getComment(long var0);

    private static native int getCurrentFrameIndex(long var0);

    private static native int getCurrentLoop(long var0);

    private static native int getCurrentPosition(long var0);

    private static native int getDuration(long var0);

    private static native int getFrameDuration(long var0, int var2);

    private static native int getHeight(long var0);

    private static native int getLoopCount(long var0);

    private static native int getNativeErrorCode(long var0);

    private static native int getNumberOfFrames(long var0);

    private static native long[] getSavedState(long var0);

    private static native long getSourceLength(long var0);

    private static native int getWidth(long var0);

    private static native void glTexImage2D(long var0, int var2, int var3);

    private static native void glTexSubImage2D(long var0, int var2, int var3);

    private static native void initTexImageDescriptor(long var0);

    private static native boolean isAnimationCompleted(long var0);

    private static native boolean isOpaque(long var0);

    static native long openByteArray(byte[] var0, boolean var1) throws GifIOException;

    static native long openDirectByteBuffer(ByteBuffer var0, boolean var1) throws GifIOException;

    static native long openFd(FileDescriptor var0, long var1, boolean var3) throws GifIOException;

    static native long openFile(String var0, boolean var1) throws GifIOException;

    static native long openStream(InputStream var0, boolean var1) throws GifIOException;

    static GifInfoHandle openUri(ContentResolver contentResolver, Uri uri, boolean bl) throws IOException {
        if ("file".equals(uri.getScheme())) {
            return new GifInfoHandle(uri.getPath(), bl);
        }
        return new GifInfoHandle(contentResolver.openAssetFileDescriptor(uri, "r"), bl);
    }

    private static native void postUnbindSurface(long var0);

    private static native long renderFrame(long var0, Bitmap var2);

    private static native boolean reset(long var0);

    private static native long restoreRemainder(long var0);

    private static native int restoreSavedState(long var0, long[] var2, Bitmap var3);

    private static native void saveRemainder(long var0);

    private static native void seekToFrame(long var0, int var2, Bitmap var3);

    private static native void seekToFrameGL(long var0, int var2);

    private static native void seekToTime(long var0, int var2, Bitmap var3);

    private static native void setLoopCount(long var0, int var2);

    private static native void setOptions(long var0, int var2, boolean var3);

    private static native void setSpeedFactor(long var0, float var2);

    private static native void startDecoderThread(long var0);

    private static native void stopDecoderThread(long var0);

    void bindSurface(Surface surface, long[] lArray) {
        GifInfoHandle.bindSurface(this.gifInfoPtr, surface, lArray);
    }

    protected void finalize() throws Throwable {
        try {
            this.recycle();
            return;
        }
        finally {
            super.finalize();
        }
    }

    long getAllocationByteCount() {
        synchronized (this) {
            long l = GifInfoHandle.getAllocationByteCount(this.gifInfoPtr);
            return l;
        }
    }

    String getComment() {
        synchronized (this) {
            String string2 = GifInfoHandle.getComment(this.gifInfoPtr);
            return string2;
        }
    }

    int getCurrentFrameIndex() {
        synchronized (this) {
            int n = GifInfoHandle.getCurrentFrameIndex(this.gifInfoPtr);
            return n;
        }
    }

    int getCurrentLoop() {
        synchronized (this) {
            int n = GifInfoHandle.getCurrentLoop(this.gifInfoPtr);
            return n;
        }
    }

    int getCurrentPosition() {
        synchronized (this) {
            int n = GifInfoHandle.getCurrentPosition(this.gifInfoPtr);
            return n;
        }
    }

    int getDuration() {
        synchronized (this) {
            int n = GifInfoHandle.getDuration(this.gifInfoPtr);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getFrameDuration(int n) {
        synchronized (this) {
            if (n >= 0 && n < GifInfoHandle.getNumberOfFrames(this.gifInfoPtr)) {
                return GifInfoHandle.getFrameDuration(this.gifInfoPtr, n);
            }
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("Frame index is out of bounds");
            throw indexOutOfBoundsException;
        }
    }

    int getHeight() {
        synchronized (this) {
            int n = GifInfoHandle.getHeight(this.gifInfoPtr);
            return n;
        }
    }

    int getLoopCount() {
        synchronized (this) {
            int n = GifInfoHandle.getLoopCount(this.gifInfoPtr);
            return n;
        }
    }

    int getNativeErrorCode() {
        synchronized (this) {
            int n = GifInfoHandle.getNativeErrorCode(this.gifInfoPtr);
            return n;
        }
    }

    int getNumberOfFrames() {
        synchronized (this) {
            int n = GifInfoHandle.getNumberOfFrames(this.gifInfoPtr);
            return n;
        }
    }

    long[] getSavedState() {
        synchronized (this) {
            long[] lArray = GifInfoHandle.getSavedState(this.gifInfoPtr);
            return lArray;
        }
    }

    long getSourceLength() {
        synchronized (this) {
            long l = GifInfoHandle.getSourceLength(this.gifInfoPtr);
            return l;
        }
    }

    int getWidth() {
        synchronized (this) {
            int n = GifInfoHandle.getWidth(this.gifInfoPtr);
            return n;
        }
    }

    void glTexImage2D(int n, int n2) {
        GifInfoHandle.glTexImage2D(this.gifInfoPtr, n, n2);
    }

    void glTexSubImage2D(int n, int n2) {
        GifInfoHandle.glTexSubImage2D(this.gifInfoPtr, n, n2);
    }

    void initTexImageDescriptor() {
        GifInfoHandle.initTexImageDescriptor(this.gifInfoPtr);
    }

    boolean isAnimationCompleted() {
        synchronized (this) {
            boolean bl = GifInfoHandle.isAnimationCompleted(this.gifInfoPtr);
            return bl;
        }
    }

    boolean isOpaque() {
        synchronized (this) {
            boolean bl = GifInfoHandle.isOpaque(this.gifInfoPtr);
            return bl;
        }
    }

    boolean isRecycled() {
        synchronized (this) {
            long l = this.gifInfoPtr;
            boolean bl = l == 0L;
            return bl;
        }
    }

    void postUnbindSurface() {
        synchronized (this) {
            GifInfoHandle.postUnbindSurface(this.gifInfoPtr);
            return;
        }
    }

    void recycle() {
        synchronized (this) {
            GifInfoHandle.free(this.gifInfoPtr);
            this.gifInfoPtr = 0L;
            return;
        }
    }

    long renderFrame(Bitmap bitmap) {
        synchronized (this) {
            long l = GifInfoHandle.renderFrame(this.gifInfoPtr, bitmap);
            return l;
        }
    }

    boolean reset() {
        synchronized (this) {
            boolean bl = GifInfoHandle.reset(this.gifInfoPtr);
            return bl;
        }
    }

    long restoreRemainder() {
        synchronized (this) {
            long l = GifInfoHandle.restoreRemainder(this.gifInfoPtr);
            return l;
        }
    }

    int restoreSavedState(long[] lArray, Bitmap bitmap) {
        synchronized (this) {
            int n = GifInfoHandle.restoreSavedState(this.gifInfoPtr, lArray, bitmap);
            return n;
        }
    }

    void saveRemainder() {
        synchronized (this) {
            GifInfoHandle.saveRemainder(this.gifInfoPtr);
            return;
        }
    }

    void seekToFrame(int n, Bitmap bitmap) {
        synchronized (this) {
            GifInfoHandle.seekToFrame(this.gifInfoPtr, n, bitmap);
            return;
        }
    }

    void seekToFrameGL(int n) {
        if (n >= 0 && n < GifInfoHandle.getNumberOfFrames(this.gifInfoPtr)) {
            GifInfoHandle.seekToFrameGL(this.gifInfoPtr, n);
            return;
        }
        throw new IndexOutOfBoundsException("Frame index is out of bounds");
    }

    void seekToTime(int n, Bitmap bitmap) {
        synchronized (this) {
            GifInfoHandle.seekToTime(this.gifInfoPtr, n, bitmap);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setLoopCount(int n) {
        if (n >= 0 && n <= 65535) {
            synchronized (this) {
                GifInfoHandle.setLoopCount(this.gifInfoPtr, n);
                return;
            }
        }
        throw new IllegalArgumentException("Loop count of range <0, 65535>");
    }

    void setOptions(int n, boolean bl) {
        GifInfoHandle.setOptions(this.gifInfoPtr, n, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setSpeedFactor(float f) {
        if (!(f <= 0.0f) && !Float.isNaN(f)) {
            float f2 = f;
            if (f < 4.656613E-10f) {
                f2 = 4.656613E-10f;
            }
            synchronized (this) {
                GifInfoHandle.setSpeedFactor(this.gifInfoPtr, f2);
                return;
            }
        }
        throw new IllegalArgumentException("Speed factor is not positive");
    }

    void startDecoderThread() {
        GifInfoHandle.startDecoderThread(this.gifInfoPtr);
    }

    void stopDecoderThread() {
        GifInfoHandle.stopDecoderThread(this.gifInfoPtr);
    }
}

