/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import java.io.IOException;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifViewSavedState;
import pl.droidsonroids.gif.GifViewUtils;

public class GifTextView
extends TextView {
    private boolean mFreezesAnimation;

    public GifTextView(Context context) {
        super(context);
    }

    public GifTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet, 0, 0);
    }

    public GifTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(attributeSet, n, 0);
    }

    public GifTextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.init(attributeSet, n, n2);
    }

    private Drawable getGifOrDefaultDrawable(int n) {
        if (n == 0) {
            return null;
        }
        Resources resources = this.getResources();
        if (!this.isInEditMode() && "drawable".equals(resources.getResourceTypeName(n))) {
            try {
                GifDrawable gifDrawable = new GifDrawable(resources, n);
                return gifDrawable;
            }
            catch (Resources.NotFoundException | IOException throwable) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return resources.getDrawable(n, this.getContext().getTheme());
        }
        return resources.getDrawable(n);
    }

    private void hideCompoundDrawables(Drawable[] drawableArray) {
        for (Drawable drawable2 : drawableArray) {
            if (drawable2 == null) continue;
            drawable2.setVisible(false, false);
        }
    }

    private void init(AttributeSet attributeSet, int n, int n2) {
        if (attributeSet != null) {
            Drawable drawable2 = this.getGifOrDefaultDrawable(attributeSet.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableLeft", 0));
            Drawable drawable3 = this.getGifOrDefaultDrawable(attributeSet.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableTop", 0));
            Drawable drawable4 = this.getGifOrDefaultDrawable(attributeSet.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableRight", 0));
            Drawable drawable5 = this.getGifOrDefaultDrawable(attributeSet.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableBottom", 0));
            Drawable drawable6 = this.getGifOrDefaultDrawable(attributeSet.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableStart", 0));
            Drawable drawable7 = this.getGifOrDefaultDrawable(attributeSet.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "drawableEnd", 0));
            if (Build.VERSION.SDK_INT >= 17) {
                Drawable drawable8;
                if (this.getLayoutDirection() == 0) {
                    Drawable drawable9 = drawable6;
                    if (drawable6 == null) {
                        drawable9 = drawable2;
                    }
                    drawable8 = drawable9;
                    drawable6 = drawable7;
                    if (drawable7 == null) {
                        drawable6 = drawable4;
                        drawable8 = drawable9;
                    }
                } else {
                    Drawable drawable10 = drawable6;
                    if (drawable6 == null) {
                        drawable10 = drawable4;
                    }
                    drawable8 = drawable10;
                    drawable6 = drawable7;
                    if (drawable7 == null) {
                        drawable6 = drawable2;
                        drawable8 = drawable10;
                    }
                }
                this.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable8, drawable3, drawable6, drawable5);
                this.setCompoundDrawablesWithIntrinsicBounds(drawable2, drawable3, drawable4, drawable5);
            } else {
                this.setCompoundDrawablesWithIntrinsicBounds(drawable2, drawable3, drawable4, drawable5);
            }
            this.setBackgroundInternal(this.getGifOrDefaultDrawable(attributeSet.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "background", 0)));
        }
        this.mFreezesAnimation = GifViewUtils.isFreezingAnimation((View)this, attributeSet, n, n2);
    }

    private void setBackgroundInternal(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.hideCompoundDrawables(this.getCompoundDrawables());
        if (Build.VERSION.SDK_INT >= 17) {
            this.hideCompoundDrawables(this.getCompoundDrawablesRelative());
        }
    }

    public void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof GifViewSavedState)) {
            super.onRestoreInstanceState((Parcelable)object);
            return;
        }
        object = (GifViewSavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        Drawable[] drawableArray = this.getCompoundDrawables();
        ((GifViewSavedState)((Object)object)).restoreState(drawableArray[0], 0);
        ((GifViewSavedState)((Object)object)).restoreState(drawableArray[1], 1);
        ((GifViewSavedState)((Object)object)).restoreState(drawableArray[2], 2);
        ((GifViewSavedState)((Object)object)).restoreState(drawableArray[3], 3);
        if (Build.VERSION.SDK_INT >= 17) {
            drawableArray = this.getCompoundDrawablesRelative();
            ((GifViewSavedState)((Object)object)).restoreState(drawableArray[0], 4);
            ((GifViewSavedState)((Object)object)).restoreState(drawableArray[2], 5);
        }
        ((GifViewSavedState)((Object)object)).restoreState(this.getBackground(), 6);
    }

    public Parcelable onSaveInstanceState() {
        Drawable[] drawableArray = new Drawable[7];
        if (this.mFreezesAnimation) {
            Drawable[] drawableArray2 = this.getCompoundDrawables();
            System.arraycopy(drawableArray2, 0, drawableArray, 0, drawableArray2.length);
            if (Build.VERSION.SDK_INT >= 17) {
                drawableArray2 = this.getCompoundDrawablesRelative();
                drawableArray[4] = drawableArray2[0];
                drawableArray[5] = drawableArray2[2];
            }
            drawableArray[6] = this.getBackground();
        }
        return new GifViewSavedState(super.onSaveInstanceState(), drawableArray);
    }

    public void setBackgroundResource(int n) {
        this.setBackgroundInternal(this.getGifOrDefaultDrawable(n));
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int n, int n2, int n3, int n4) {
        this.setCompoundDrawablesRelativeWithIntrinsicBounds(this.getGifOrDefaultDrawable(n), this.getGifOrDefaultDrawable(n2), this.getGifOrDefaultDrawable(n3), this.getGifOrDefaultDrawable(n4));
    }

    public void setCompoundDrawablesWithIntrinsicBounds(int n, int n2, int n3, int n4) {
        this.setCompoundDrawablesWithIntrinsicBounds(this.getGifOrDefaultDrawable(n), this.getGifOrDefaultDrawable(n2), this.getGifOrDefaultDrawable(n3), this.getGifOrDefaultDrawable(n4));
    }

    public void setFreezesAnimation(boolean bl) {
        this.mFreezesAnimation = bl;
    }
}

