/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.widget.ImageView;
import java.io.IOException;
import java.lang.ref.WeakReference;
import pl.droidsonroids.gif.ConditionVariable;
import pl.droidsonroids.gif.GifIOException;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifViewSavedState;
import pl.droidsonroids.gif.GifViewUtils;
import pl.droidsonroids.gif.InputSource;
import pl.droidsonroids.gif.LibraryLoader;
import pl.droidsonroids.gif.R;

public class GifTextureView
extends TextureView {
    private static final ImageView.ScaleType[] sScaleTypeArray = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private boolean mFreezesAnimation;
    private InputSource mInputSource;
    private RenderThread mRenderThread;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
    private float mSpeedFactor = 1.0f;
    private final Matrix mTransform = new Matrix();

    public GifTextureView(Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public GifTextureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet, 0, 0);
    }

    public GifTextureView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(attributeSet, n, 0);
    }

    public GifTextureView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.init(attributeSet, n, n2);
    }

    private static InputSource findSource(TypedArray object) {
        TypedValue typedValue = new TypedValue();
        if (!object.getValue(R.styleable.GifTextureView_gifSource, typedValue)) {
            return null;
        }
        if (typedValue.resourceId != 0) {
            String string2 = object.getResources().getResourceTypeName(typedValue.resourceId);
            if (GifViewUtils.SUPPORTED_RESOURCE_TYPE_NAMES.contains(string2)) {
                return new InputSource.ResourcesSource(object.getResources(), typedValue.resourceId);
            }
            if (!"string".equals(string2)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Expected string, drawable, mipmap or raw resource type. '");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("' is not supported");
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
        }
        return new InputSource.AssetSource(object.getResources().getAssets(), typedValue.string.toString());
    }

    private void init(AttributeSet object, int n, int n2) {
        if (object != null) {
            TypedArray typedArray;
            int n3 = object.getAttributeIntValue("http://schemas.android.com/apk/res/android", "scaleType", -1);
            if (n3 >= 0 && n3 < ((ImageView.ScaleType[])(typedArray = sScaleTypeArray)).length) {
                this.mScaleType = typedArray[n3];
            }
            typedArray = this.getContext().obtainStyledAttributes((AttributeSet)object, R.styleable.GifTextureView, n, n2);
            this.mInputSource = GifTextureView.findSource(typedArray);
            super.setOpaque(typedArray.getBoolean(R.styleable.GifTextureView_isOpaque, false));
            typedArray.recycle();
            this.mFreezesAnimation = GifViewUtils.isFreezingAnimation((View)this, (AttributeSet)object, n, n2);
        } else {
            super.setOpaque(false);
        }
        if (!this.isInEditMode()) {
            LibraryLoader.loadLibrary(this.getContext(), "pl_droidsonroids_gif_surface");
            object = new RenderThread(this);
            this.mRenderThread = object;
            if (this.mInputSource != null) {
                ((Thread)object).start();
            }
        }
    }

    private void setSuperSurfaceTextureListener(RenderThread renderThread) {
        super.setSurfaceTextureListener((TextureView.SurfaceTextureListener)renderThread);
    }

    private void updateTextureViewSize(GifInfoHandle gifInfoHandle) {
        Matrix matrix = new Matrix();
        float f = this.getWidth();
        float f2 = this.getHeight();
        float f3 = (float)gifInfoHandle.getWidth() / f;
        float f4 = (float)gifInfoHandle.getHeight() / f2;
        RectF rectF = new RectF(0.0f, 0.0f, (float)gifInfoHandle.getWidth(), (float)gifInfoHandle.getHeight());
        RectF rectF2 = new RectF(0.0f, 0.0f, f, f2);
        int n = 1.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()];
        float f5 = 1.0f;
        switch (n) {
            default: {
                break;
            }
            case 8: {
                matrix.set(this.mTransform);
                matrix.preScale(f3, f4);
                break;
            }
            case 7: {
                return;
            }
            case 6: {
                matrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.START);
                matrix.preScale(f3, f4);
                break;
            }
            case 5: {
                matrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.END);
                matrix.preScale(f3, f4);
                break;
            }
            case 4: {
                matrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.CENTER);
                matrix.preScale(f3, f4);
                break;
            }
            case 3: {
                if (!((float)gifInfoHandle.getWidth() <= f) || !((float)gifInfoHandle.getHeight() <= f2)) {
                    f5 = Math.min(1.0f / f3, 1.0f / f4);
                }
                matrix.setScale(f3 * f5, f5 * f4, f / 2.0f, f2 / 2.0f);
                break;
            }
            case 2: {
                f5 = 1.0f / Math.min(f3, f4);
                matrix.setScale(f3 * f5, f5 * f4, f / 2.0f, f2 / 2.0f);
                break;
            }
            case 1: {
                matrix.setScale(f3, f4, f / 2.0f, f2 / 2.0f);
            }
        }
        super.setTransform(matrix);
    }

    public IOException getIOException() {
        if (this.mRenderThread.mIOException != null) {
            return this.mRenderThread.mIOException;
        }
        return GifIOException.fromCode(this.mRenderThread.mGifInfoHandle.getNativeErrorCode());
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public TextureView.SurfaceTextureListener getSurfaceTextureListener() {
        return null;
    }

    public Matrix getTransform(Matrix matrix) {
        Matrix matrix2 = matrix;
        if (matrix == null) {
            matrix2 = new Matrix();
        }
        matrix2.set(this.mTransform);
        return matrix2;
    }

    protected void onDetachedFromWindow() {
        this.mRenderThread.dispose(this);
        super.onDetachedFromWindow();
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (surfaceTexture != null) {
            surfaceTexture.release();
        }
    }

    public void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof GifViewSavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        object = (GifViewSavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.mRenderThread.mSavedState = object.mStates[0];
    }

    public Parcelable onSaveInstanceState() {
        Object object = this.mRenderThread;
        ((RenderThread)object).mSavedState = ((RenderThread)object).mGifInfoHandle.getSavedState();
        Parcelable parcelable = super.onSaveInstanceState();
        object = this.mFreezesAnimation ? (Object)this.mRenderThread.mSavedState : null;
        return new GifViewSavedState(parcelable, (long[])object);
    }

    public void setFreezesAnimation(boolean bl) {
        this.mFreezesAnimation = bl;
    }

    public void setImageMatrix(Matrix matrix) {
        this.setTransform(matrix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInputSource(InputSource inputSource) {
        synchronized (this) {
            RenderThread renderThread;
            this.mRenderThread.dispose(this);
            this.mInputSource = inputSource;
            this.mRenderThread = renderThread = new RenderThread(this);
            if (inputSource != null) {
                renderThread.start();
            }
            return;
        }
    }

    public void setOpaque(boolean bl) {
        if (bl != this.isOpaque()) {
            super.setOpaque(bl);
            this.setInputSource(this.mInputSource);
        }
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.mScaleType = scaleType;
        this.updateTextureViewSize(this.mRenderThread.mGifInfoHandle);
    }

    public void setSpeed(float f) {
        this.mSpeedFactor = f;
        this.mRenderThread.mGifInfoHandle.setSpeedFactor(f);
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        throw new UnsupportedOperationException("Changing SurfaceTexture is not supported");
    }

    public void setSurfaceTextureListener(TextureView.SurfaceTextureListener surfaceTextureListener) {
        throw new UnsupportedOperationException("Changing SurfaceTextureListener is not supported");
    }

    public void setTransform(Matrix matrix) {
        this.mTransform.set(matrix);
        this.updateTextureViewSize(this.mRenderThread.mGifInfoHandle);
    }

    private static class RenderThread
    extends Thread
    implements TextureView.SurfaceTextureListener {
        final ConditionVariable isSurfaceValid = new ConditionVariable();
        private GifInfoHandle mGifInfoHandle = GifInfoHandle.NULL_INFO;
        private final WeakReference<GifTextureView> mGifTextureViewReference;
        private IOException mIOException;
        long[] mSavedState;

        RenderThread(GifTextureView gifTextureView) {
            super("GifRenderThread");
            this.mGifTextureViewReference = new WeakReference<GifTextureView>(gifTextureView);
        }

        void dispose(GifTextureView gifTextureView) {
            this.isSurfaceValid.close();
            gifTextureView.setSuperSurfaceTextureListener(null);
            this.mGifInfoHandle.postUnbindSurface();
            this.interrupt();
        }

        public void onSurfaceTextureAvailable(SurfaceTexture object, int n, int n2) {
            object = (GifTextureView)((Object)this.mGifTextureViewReference.get());
            if (object != null) {
                ((GifTextureView)((Object)object)).updateTextureViewSize(this.mGifInfoHandle);
            }
            this.isSurfaceValid.open();
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            this.isSurfaceValid.close();
            this.mGifInfoHandle.postUnbindSurface();
            return false;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            GifInfoHandle gifInfoHandle;
            GifTextureView gifTextureView;
            try {
                gifTextureView = (GifTextureView)((Object)this.mGifTextureViewReference.get());
                if (gifTextureView == null) {
                    return;
                }
                this.mGifInfoHandle = gifInfoHandle = gifTextureView.mInputSource.open();
                gifInfoHandle.setOptions(1, gifTextureView.isOpaque());
            }
            catch (IOException iOException) {
                this.mIOException = iOException;
                return;
            }
            gifTextureView = (GifTextureView)((Object)this.mGifTextureViewReference.get());
            if (gifTextureView == null) {
                this.mGifInfoHandle.recycle();
                return;
            }
            gifTextureView.setSuperSurfaceTextureListener(this);
            boolean bl = gifTextureView.isAvailable();
            this.isSurfaceValid.set(bl);
            if (bl) {
                gifTextureView.post(new Runnable(){

                    @Override
                    public void run() {
                        gifTextureView.updateTextureViewSize(RenderThread.this.mGifInfoHandle);
                    }
                });
            }
            this.mGifInfoHandle.setSpeedFactor(gifTextureView.mSpeedFactor);
            while (!this.isInterrupted()) {
                try {
                    this.isSurfaceValid.block();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
                gifInfoHandle = gifTextureView.getSurfaceTexture();
                if (gifInfoHandle == null) continue;
                gifInfoHandle = new Surface((SurfaceTexture)gifInfoHandle);
                try {
                    this.mGifInfoHandle.bindSurface((Surface)gifInfoHandle, this.mSavedState);
                }
                finally {
                    gifInfoHandle.release();
                }
            }
            this.mGifInfoHandle.recycle();
            this.mGifInfoHandle = GifInfoHandle.NULL_INFO;
        }
    }
}

